/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class FormatStringDescriptorProvider
extends FormatDescriptorProvider {
    public static final String PRESERVE_WHITE_SPACES = Messages.getString((String)"FormatStringPage.Label.PreserveWhiteSpaces");
    private static String[][] choiceArray = null;
    private static String[] formatTypes = null;
    private List listeners = new ArrayList();
    private Object input;
    public String STRING_FORMAT_TYPE_UNFORMATTED = "Unformatted";
    public String STRING_FORMAT_TYPE_UPPERCASE = ">";
    public String STRING_FORMAT_TYPE_LOWERCASE = "<";
    public String STRING_FORMAT_TYPE_CUSTOM = "Custom";
    public String STRING_FORMAT_TYPE_ZIP_CODE = "Zip Code";
    public String STRING_FORMAT_TYPE_ZIP_CODE_4 = "Zip Code + 4";
    public String STRING_FORMAT_TYPE_PHONE_NUMBER = "Phone Number";
    public String STRING_FORMAT_TYPE_SOCIAL_SECURITY_NUMBER = "Social Security Number";
    public String STRING_FORMAT_TYPE_PRESERVE_SPACE = "^";
    public String FORMAT_VALUE_STRUCT = "StringFormatValue";
    public String CATEGORY_MEMBER = "category";

    public String getDisplayName() {
        return null;
    }

    public Object load() {
        PropertyHandle propHandle;
        FormatValue formatValueToSet;
        FormatValueHandle formatHandle;
        ULocale uLocale;
        StyleHandle style;
        Object formatValue;
        if (DEUtil.getInputElements((Object)this.input).isEmpty()) {
            return null;
        }
        String baseCategory = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getStringFormatCategory();
        String basePattern = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getStringFormat();
        String baseLocale = NONE;
        DesignElementHandle element = (DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input);
        if (element.getPrivateStyle() != null && (formatValue = (style = element.getPrivateStyle()).getProperty("stringFormat")) instanceof FormatValue && (uLocale = (formatHandle = (FormatValueHandle)(formatValueToSet = (FormatValue)formatValue).getHandle((SimpleValueHandle)(propHandle = style.getPropertyHandle("stringFormat")))).getLocale()) != null) {
            baseLocale = uLocale.getDisplayName();
        }
        for (DesignElementHandle handle : DEUtil.getInputElements((Object)this.input)) {
            PropertyHandle propHandle2;
            FormatValue formatValueToSet2;
            FormatValueHandle formatHandle2;
            ULocale uLocale2;
            StyleHandle style2;
            Object formatValue2;
            String category = handle.getPrivateStyle().getStringFormatCategory();
            String pattern = handle.getPrivateStyle().getStringFormat();
            String locale = NONE;
            if (handle.getPrivateStyle() != null && (formatValue2 = (style2 = handle.getPrivateStyle()).getProperty("stringFormat")) instanceof FormatValue && (uLocale2 = (formatHandle2 = (FormatValueHandle)(formatValueToSet2 = (FormatValue)formatValue2).getHandle((SimpleValueHandle)(propHandle2 = style2.getPropertyHandle("stringFormat")))).getLocale()) != null) {
                locale = uLocale2.getDisplayName();
            }
            if ((baseCategory == null && category == null || baseCategory != null && baseCategory.equals(category)) && (basePattern == null && pattern == null || basePattern != null && basePattern.equals(pattern)) && (baseLocale == null && locale == null || baseLocale != null && baseLocale.equals(locale))) continue;
            return null;
        }
        return new String[]{baseCategory, basePattern, baseLocale};
    }

    public void save(Object value) throws SemanticException {
        String[] values = (String[])value;
        if (values.length != 3) {
            return;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString((String)"FormatStringAttributePage.Trans.SetStringFormat"));
        for (DesignElementHandle element : DEUtil.getInputElements((Object)this.input)) {
            try {
                StyleHandle style;
                Object formatValue;
                if (values[0] == null && values[1] == null) {
                    element.setProperty("stringFormat", null);
                } else {
                    element.getPrivateStyle().setStringFormatCategory(values[0]);
                    element.getPrivateStyle().setStringFormat(values[1]);
                }
                if (element.getPrivateStyle() == null || !((formatValue = (style = element.getPrivateStyle()).getProperty("stringFormat")) instanceof FormatValue)) continue;
                PropertyHandle propHandle = style.getPropertyHandle("stringFormat");
                FormatValue formatValueToSet = (FormatValue)formatValue;
                FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                if (values[2] == null) continue;
                formatHandle.setLocale(this.getLocaleByDisplayName(values[2]));
            }
            catch (SemanticException e) {
                stack.rollbackAll();
                ExceptionHandler.handle((Throwable)e);
            }
        }
        stack.commit();
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public String[][] initChoiceArray() {
        if (choiceArray == null) {
            IChoiceSet set = ChoiceSetFactory.getStructChoiceSet((String)"StringFormatValue", (String)"category");
            IChoice[] choices = set.getChoices();
            if (choices.length > 0) {
                choiceArray = new String[4][2];
                int i = 0;
                int j = 0;
                while (i < choices.length) {
                    if (choices[i].getName().equals("Unformatted") || choices[i].getName().equals(">") || choices[i].getName().equals("<") || choices[i].getName().equals("Custom")) {
                        FormatStringDescriptorProvider.choiceArray[j][0] = choices[i].getDisplayName();
                        FormatStringDescriptorProvider.choiceArray[j][1] = choices[i].getName();
                        ++j;
                    }
                    ++i;
                }
            } else {
                choiceArray = new String[0][0];
            }
        }
        return choiceArray;
    }

    public String[] getFormatTypes() {
        if (this.initChoiceArray() != null) {
            formatTypes = new String[choiceArray.length];
            int i = 0;
            while (i < choiceArray.length) {
                FormatStringDescriptorProvider.formatTypes[i] = choiceArray[i][0];
                ++i;
            }
        } else {
            formatTypes = new String[0];
        }
        return formatTypes;
    }

    public int getIndexOfCategory(String name) {
        if (choiceArray != null) {
            int i = 0;
            while (i < choiceArray.length) {
                if (choiceArray[i][1].equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public String getCategory4DisplayName(String displayName) {
        if (choiceArray != null) {
            int i = 0;
            while (i < choiceArray.length) {
                if (choiceArray[i][0].equals(displayName)) {
                    return choiceArray[i][1];
                }
                ++i;
            }
        }
        return displayName;
    }

    public String getDisplayName4Category(String category) {
        if (category.equals(this.STRING_FORMAT_TYPE_PRESERVE_SPACE)) {
            return PRESERVE_WHITE_SPACES;
        }
        return ChoiceSetFactory.getStructDisplayName((String)"StringFormatValue", (String)"category", (String)category);
    }

    public void fireFormatChanged(String newCategory, String newPattern, String newLocale) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent((Object)this, "stringFormat", newCategory, newPattern, newLocale);
        for (Object listener : this.listeners) {
            if (!(listener instanceof IFormatChangeListener)) continue;
            ((IFormatChangeListener)listener).formatChange(event);
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean isBlank(String fmtStr) {
        return StringUtil.isBlank((String)fmtStr);
    }
}

