/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IToggleDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TogglePropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TogglesSection
extends Section {
    protected TogglePropertyDescriptor[] toggles;
    private int width = -1;
    private boolean fillToggle = false;
    IToggleDescriptorProvider[] providers;
    private Composite composite;
    private TogglePropertyDescriptor toggle;

    public TogglesSection(Composite parent) {
        super(" ", parent, true);
    }

    public TogglesSection(Composite parent, String title) {
        super(title, parent, true);
    }

    public void createSection() {
        if (!this.getLabelText().trim().equals("")) {
            this.getLabelControl(this.parent);
        }
        this.getTogglesControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public Composite getTogglesControl() {
        return this.composite;
    }

    protected Composite getTogglesControl(Composite parent) {
        if (this.toggles == null && this.providers != null) {
            this.composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 7;
            layout.numColumns = this.providers.length;
            this.composite.setLayout((Layout)layout);
            this.composite.setLayoutData((Object)new GridData());
            this.toggles = new TogglePropertyDescriptor[this.providers.length];
            int i = 0;
            while (i < this.providers.length) {
                this.toggles[i] = this.toggle = DescriptorToolkit.createTogglePropertyDescriptor();
                this.toggle.setDescriptorProvider(this.providers[i]);
                this.toggle.createControl(this.composite);
                this.toggle.getControl().setLayoutData((Object)new GridData());
                this.toggle.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        TogglesSection.this.toggle = null;
                        boolean flag = true;
                        int i = 0;
                        while (i < TogglesSection.this.providers.length) {
                            if (TogglesSection.this.toggles[i] != null) {
                                flag = false;
                                break;
                            }
                            ++i;
                        }
                        if (flag) {
                            TogglesSection.this.toggles = null;
                        }
                    }
                });
                ++i;
            }
        } else {
            this.checkParent((Control)this.composite, parent);
        }
        return this.composite;
    }

    public void layout() {
        GridData gd = (GridData)this.composite.getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
        if (this.getLabelControl() != null) {
            --gd.horizontalSpan;
        }
        gd.horizontalAlignment = 4;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillToggle;
        }
    }

    public void load() {
        int i = 0;
        while (i < this.toggles.length) {
            if (this.toggles[i] != null && !this.toggles[i].getControl().isDisposed()) {
                this.toggles[i].load();
            }
            ++i;
        }
    }

    public void reset() {
        int i = 0;
        while (i < this.toggles.length) {
            if (this.toggles[i] != null && !this.toggles[i].getControl().isDisposed()) {
                this.toggles[i].reset();
            }
            ++i;
        }
    }

    public void setInput(Object input) {
        assert (input != null);
        int i = 0;
        while (i < this.toggles.length) {
            this.toggles[i].setInput(input);
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isFillToggle() {
        return this.fillToggle;
    }

    public void setFillToggle(boolean fillToggle) {
        this.fillToggle = fillToggle;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.composite != null) {
            WidgetUtil.setExcludeGridData((Control)this.composite, isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.composite != null) {
            this.composite.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public IToggleDescriptorProvider[] getProviders() {
        return this.providers;
    }

    public void setProviders(IToggleDescriptorProvider[] providers) {
        this.providers = providers;
    }
}

