/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BindingGroupDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BindingGroupDescriptor
extends PropertyDescriptor {
    protected Composite container;
    private Button datasetRadio;
    private Button reportItemRadio;
    private CCombo datasetCombo;
    private CCombo reportItemCombo;
    private Button bindingButton;
    private BindingGroupDescriptorProvider provider;

    public BindingGroupDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(768));
        this.datasetRadio = FormWidgetFactory.getInstance().createButton(this.container, 16, this.isFormStyle());
        this.datasetRadio.setText(this.getProvider().getText(0));
        this.datasetRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.refreshBinding();
                if (BindingGroupDescriptor.this.datasetRadio.getSelection() && BindingGroupDescriptor.this.getProvider().isBindingReference()) {
                    BindingGroupDescriptor.this.saveBinding();
                }
            }
        });
        this.datasetCombo = this.isFormStyle() ? FormWidgetFactory.getInstance().createCCombo(this.container, true) : new CCombo(this.container, 8);
        this.datasetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.saveBinding();
            }
        });
        GridData gd = new GridData();
        gd.widthHint = 300;
        this.datasetCombo.setLayoutData((Object)gd);
        this.bindingButton = FormWidgetFactory.getInstance().createButton(this.container, 8, this.isFormStyle());
        this.bindingButton.setText(this.getProvider().getText(1));
        this.bindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.getProvider().bindingDialog();
            }
        });
        this.reportItemRadio = FormWidgetFactory.getInstance().createButton(this.container, 16, this.isFormStyle());
        this.reportItemRadio.setText(this.getProvider().getText(2));
        this.reportItemRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.refreshBinding();
            }
        });
        this.reportItemCombo = this.isFormStyle() ? FormWidgetFactory.getInstance().createCCombo(this.container, true) : new CCombo(this.container, 8);
        this.reportItemCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingGroupDescriptor.this.saveBinding();
            }
        });
        gd = new GridData();
        gd.widthHint = 300;
        this.reportItemCombo.setLayoutData((Object)gd);
        return this.container;
    }

    public Control getControl() {
        return this.container;
    }

    private void saveBinding() {
        BindingGroupDescriptorProvider.BindingInfo info = new BindingGroupDescriptorProvider.BindingInfo();
        if (this.datasetRadio.getSelection()) {
            info.setBindingType(1);
            info.setBindingValue(this.datasetCombo.getText());
        } else {
            info.setBindingType(2);
            info.setBindingValue(this.reportItemCombo.getText());
        }
        try {
            this.save(info);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void load() {
        if (!this.provider.isEnable()) {
            this.datasetRadio.setEnabled(false);
            this.datasetRadio.setSelection(false);
            this.datasetCombo.setEnabled(false);
            this.bindingButton.setEnabled(false);
            this.reportItemRadio.setSelection(false);
            this.reportItemRadio.setEnabled(false);
            this.reportItemCombo.setEnabled(false);
            this.datasetCombo.deselectAll();
            this.reportItemCombo.deselectAll();
            return;
        }
        this.datasetRadio.setEnabled(true);
        this.reportItemRadio.setEnabled(true);
        BindingGroupDescriptorProvider.BindingInfo info = (BindingGroupDescriptorProvider.BindingInfo)this.getDescriptorProvider().load();
        if (info != null) {
            this.refreshBindingInfo(info);
        }
    }

    private void refreshBinding() {
        if (this.datasetRadio.getSelection()) {
            this.datasetRadio.setSelection(true);
            this.datasetCombo.setEnabled(true);
            this.bindingButton.setEnabled(this.getProvider().enableBindingButton());
            this.reportItemRadio.setSelection(false);
            this.reportItemCombo.setEnabled(false);
            if (this.datasetCombo.getSelectionIndex() == -1) {
                this.datasetCombo.setItems(this.getProvider().getAvailableDatasetItems());
                this.datasetCombo.select(0);
            }
        } else {
            this.datasetRadio.setSelection(false);
            this.datasetCombo.setEnabled(false);
            this.bindingButton.setEnabled(false);
            this.reportItemRadio.setSelection(true);
            this.reportItemCombo.setEnabled(true);
            if (this.reportItemCombo.getSelectionIndex() == -1) {
                this.reportItemCombo.setItems(this.getProvider().getReferences());
                this.reportItemCombo.select(0);
            }
        }
    }

    private void refreshBindingInfo(BindingGroupDescriptorProvider.BindingInfo info) {
        int type = info.getBindingType();
        Object value = info.getBindingValue();
        this.datasetCombo.setItems(this.getProvider().getAvailableDatasetItems());
        this.reportItemCombo.setItems(this.getProvider().getReferences());
        if (type == 0 && DEUtil.getBindingHolder((DesignElementHandle)this.getProvider().getReportItemHandle(), (boolean)true) != null && DEUtil.getBindingHolder((DesignElementHandle)this.getProvider().getReportItemHandle(), (boolean)true).getDataBindingType() == 2) {
            type = 2;
        }
        switch (type) {
            case 0: 
            case 1: {
                this.datasetRadio.setSelection(true);
                this.datasetCombo.setEnabled(true);
                this.datasetCombo.setText(value.toString());
                this.bindingButton.setEnabled(this.getProvider().enableBindingButton());
                this.reportItemRadio.setSelection(false);
                this.reportItemCombo.setEnabled(false);
                break;
            }
            case 2: {
                this.datasetRadio.setSelection(false);
                this.datasetCombo.setEnabled(false);
                this.bindingButton.setEnabled(false);
                this.reportItemRadio.setSelection(true);
                this.reportItemCombo.setEnabled(true);
                this.reportItemCombo.setText(value.toString());
                if (!info.isReadOnly()) break;
                this.datasetRadio.setEnabled(false);
                this.reportItemRadio.setEnabled(false);
                this.reportItemCombo.setEnabled(false);
            }
        }
    }

    public void save(Object obj) throws SemanticException {
        this.getProvider().save(obj);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        this.descriptorProvider = (BindingGroupDescriptorProvider)provider;
        if (provider instanceof BindingGroupDescriptorProvider) {
            this.provider = (BindingGroupDescriptorProvider)provider;
        }
    }

    public BindingGroupDescriptorProvider getProvider() {
        return this.provider;
    }
}

