/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboPropertyDescriptor
extends PropertyDescriptor {
    protected CCombo combo;
    protected IChoiceSet choiceSet;
    protected String oldValue;
    private int style = 2056;

    public ComboPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    void refresh(String value) {
        if (this.getDescriptorProvider() instanceof ComboPropertyDescriptorProvider) {
            String displayName;
            boolean stateFlag;
            String[] items = ((ComboPropertyDescriptorProvider)this.getDescriptorProvider()).getItems();
            this.combo.setItems(items);
            this.oldValue = ((ComboPropertyDescriptorProvider)this.getDescriptorProvider()).load().toString();
            boolean bl = stateFlag = this.oldValue == null == this.combo.getEnabled();
            if (stateFlag) {
                this.combo.setEnabled(this.oldValue != null);
            }
            if (((ComboPropertyDescriptorProvider)this.getDescriptorProvider()).isReadOnly()) {
                this.combo.setEnabled(false);
            }
            if ((displayName = ((ComboPropertyDescriptorProvider)this.getDescriptorProvider()).getDisplayName(this.oldValue)) == null) {
                this.combo.deselectAll();
                if (this.oldValue != null && this.combo.indexOf(this.oldValue) > -1) {
                    this.combo.setText(this.oldValue);
                }
                return;
            }
            this.combo.select(Arrays.asList(items).indexOf(displayName));
        }
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        this.combo = this.isFormStyle() ? FormWidgetFactory.getInstance().createCCombo(parent) : new CCombo(parent, this.style);
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                ComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComboPropertyDescriptor.this.handleComboSelectEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ComboPropertyDescriptor.this.handleComboSelectEvent();
            }
        });
        return this.combo;
    }

    private void handleComboSelectEvent() {
        try {
            this.save(this.combo.getText());
        }
        catch (SemanticException e) {
            this.combo.setText(this.oldValue);
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
        }
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public String getStringValue() {
        return this.combo.getText();
    }

    public void setStringValue(String value) {
        this.combo.setText(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }

    public void load() {
        this.oldValue = this.getDescriptorProvider().load().toString();
        this.refresh(this.oldValue);
    }

    public void addStyle(int style) {
        this.style |= style;
    }
}

