/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatDataTimeDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormatDateTimeDescriptor
extends PropertyDescriptor
implements IFormatPage {
    private static final String LABEL_FORMAT_DATE_TIME_PAGE = Messages.getString((String)"FormatDateTimePage.label.format.page");
    private static final String LABEL_FORMAT_DATE_TIME_LOCALE = Messages.getString((String)"FormatDateTimePage.label.format.locale");
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatDateTimePage.label.general.preview.group");
    private static final String LABEL_CUSTOM_SETTINGS = Messages.getString((String)"FormatDateTimePage.label.custom.settings");
    private static final String LABEL_CUSTOM_SETTINGS_LABEL = Messages.getString((String)"FormatDateTimePage.label.custom.settings.label");
    private static final String LABEL_PREVIEW_DATETIME = Messages.getString((String)"FormatDateTimePage.label.preview.dateTime");
    private static final String LABEL_FORMAT_CODE = Messages.getString((String)"FormatDateTimePage.label.format.code");
    private static final String LABEL_PREVIEW_GROUP = Messages.getString((String)"FormatDateTimePage.label.preview.group");
    private static final String LABEL_PREVIEW_LABEL = Messages.getString((String)"FormatDateTimePage.label.preview.label");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_NAME = Messages.getString((String)"FormatDateTimePage.label.table.column.format.name");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT = Messages.getString((String)"FormatDateTimePage.label.table.column.format.result");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE = Messages.getString((String)"FormatDateTimePage.label.table.column.format.code");
    private static final String ENTER_DATE_TIME_GUIDE_FORMAT = Messages.getString((String)"FormatDateTimePage.label.guide.format");
    private static final String ENTER_DATE_TIME_GUIDE_TEXT = Messages.getString((String)"FormatDateTimePage.label.guide.text");
    private static final String PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW = Messages.getString((String)"FormatDateTimePage.preview.invalid.dateTime");
    private static final String PREVIEW_TEXT_INVALID_FORMAT_CODE = Messages.getString((String)"FormatDateTimePage.preview.invalid.formatCode");
    private String pattern = null;
    private String category = null;
    private String locale = null;
    private String oldCategory = null;
    private String oldPattern = null;
    private String oldLocale = null;
    private HashMap categoryPageMaps;
    private static final int FORMAT_CODE_INDEX = 2;
    private static final int DEFAULT_CATEGORY_CONTAINER_WIDTH = 220;
    private int pageAlignment;
    private CCombo typeChoicer;
    private CCombo localeChoicer;
    private Composite infoComp;
    private Composite formatCodeComp;
    private Composite generalPage;
    private Composite customPage;
    private Composite generalFormatCodePage;
    private Composite customFormatCodePage;
    private Label generalPreviewLabel;
    private Label cusPreviewLabel;
    private Label guideLabel;
    private Text previewTextBox;
    private Text formatCode;
    private Table table;
    private boolean hasLoaded = false;
    private String previewText = null;
    private boolean isDirty = false;
    private Date defaultDate = new Date();
    private String defaultDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, ULocale.getDefault()).format(this.defaultDate);
    private Composite content;
    private FormatDataTimeDescriptorProvider provider;

    public FormatDateTimeDescriptor() {
        this(0, true);
    }

    public FormatDateTimeDescriptor(int pageAlignment, boolean isFormStyle) {
        this.pageAlignment = pageAlignment;
        this.setFormStyle(isFormStyle);
    }

    public Control createControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.provider.initChoiceArray();
        this.provider.getFormatTypes(null);
        if (this.pageAlignment == 1) {
            this.createContentsHorizontally();
        } else {
            this.createContentsVirtically();
        }
        return this.content;
    }

    public Control getControl() {
        return this.content;
    }

    protected void createContentsVirtically() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        Composite topContainer = new Composite(this.content, 0);
        topContainer.setLayoutData((Object)new GridData(768));
        topContainer.setLayout((Layout)new GridLayout(2, false));
        FormWidgetFactory.getInstance().createLabel(topContainer, this.isFormStyle()).setText(LABEL_FORMAT_DATE_TIME_PAGE);
        this.typeChoicer = !this.isFormStyle() ? new CCombo(topContainer, 2056) : FormWidgetFactory.getInstance().createCCombo(topContainer, true);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimeDescriptor.this.reLayoutSubPages();
                FormatDateTimeDescriptor.this.updateTextByLocale();
                FormatDateTimeDescriptor.this.updatePreview();
                FormatDateTimeDescriptor.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.provider.getFormatTypes(null));
        this.typeChoicer.select(0);
        FormWidgetFactory.getInstance().createLabel(topContainer, this.isFormStyle()).setText(LABEL_FORMAT_DATE_TIME_LOCALE);
        this.localeChoicer = !this.isFormStyle() ? new CCombo(topContainer, 2056) : FormWidgetFactory.getInstance().createCCombo(topContainer, true);
        this.localeChoicer.setLayoutData((Object)new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimeDescriptor.this.updateTextByLocale();
                FormatDateTimeDescriptor.this.updatePreview();
                FormatDateTimeDescriptor.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(this.provider.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        this.infoComp = new Composite(this.content, 0);
        this.infoComp.setLayoutData((Object)new GridData(768));
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.setInput(null, null);
        this.setPreviewText(this.defaultDateTime);
    }

    protected void createContentsHorizontally() {
        this.content.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        Composite container = new Composite(this.content, 0);
        GridData data = new GridData();
        data.widthHint = 220;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(1, false));
        FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_DATE_TIME_PAGE);
        this.typeChoicer = !this.isFormStyle() ? new CCombo(container, 8) : FormWidgetFactory.getInstance().createCCombo(container, true);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimeDescriptor.this.reLayoutSubPages();
                FormatDateTimeDescriptor.this.updatePreview();
                FormatDateTimeDescriptor.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.provider.getFormatTypes(null));
        FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_DATE_TIME_LOCALE);
        this.localeChoicer = !this.isFormStyle() ? new CCombo(container, 2056) : FormWidgetFactory.getInstance().createCCombo(container, true);
        this.localeChoicer.setLayoutData((Object)new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimeDescriptor.this.updateTextByLocale();
                FormatDateTimeDescriptor.this.updatePreview();
                FormatDateTimeDescriptor.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(this.provider.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        this.infoComp = new Composite(this.content, 0);
        data = new GridData(1808);
        data.verticalSpan = 2;
        this.infoComp.setLayoutData((Object)data);
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.formatCodeComp = new Composite(this.content, 0);
        data = new GridData(1040);
        data.widthHint = 220;
        this.formatCodeComp.setLayoutData((Object)data);
        this.formatCodeComp.setLayout((Layout)new StackLayout());
        this.createFormatCodePages(this.formatCodeComp);
        this.setInput(null, null);
        this.setPreviewText(this.defaultDateTime);
    }

    private void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_UNFORMATTED, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_GENERAL_DATE, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_LONG_DATE, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_MUDIUM_DATE, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_SHORT_DATE, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_LONG_TIME, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_MEDIUM_TIME, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_SHORT_TIME, this.getGeneralPage(parent));
        this.categoryPageMaps.put(this.provider.DATETIEM_FORMAT_TYPE_CUSTOM, this.getCustomPage(parent));
    }

    private void createFormatCodePages(Composite parent) {
        this.getHorizonGeneralFormatCodePage(parent);
        this.getHorizonCustomFormatCodePage(parent);
    }

    private void notifyFormatChange() {
        if (this.hasLoaded) {
            this.provider.fireFormatChanged(this.getCategory(), this.getPattern(), this.locale);
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        this.provider.addFormatChangeListener(listener);
    }

    public void setInput(Object object) {
        super.setInput(object);
        this.getDescriptorProvider().setInput(object);
    }

    public void load() {
        this.setEnabled(true);
        String[] result = (String[])this.provider.load();
        if (result == null) {
            this.setEnabled(false);
        } else if (result.length == 1) {
            this.setInput(result[0]);
        } else if (result.length == 2) {
            this.setInput(result[0], result[1]);
        } else if (result.length == 3) {
            this.setInput(result[0], result[1], this.getLocaleByDisplayName(result[2]));
        }
    }

    public void save(Object obj) throws SemanticException {
        this.provider.save(obj);
    }

    private ULocale getLocaleByDisplayName(String name) {
        if (this.provider != null) {
            return this.provider.getLocaleByDisplayName(name);
        }
        return null;
    }

    public void setInput(String formatString) {
        if (formatString == null) {
            this.setInput(null, null);
            return;
        }
        String fmtStr = formatString;
        int pos = fmtStr.indexOf(":");
        if (StringUtil.isBlank((String)fmtStr)) {
            this.setInput(null, null);
            return;
        }
        if (pos == -1) {
            this.setInput(fmtStr, fmtStr);
            return;
        }
        String category = fmtStr.substring(0, pos);
        String patternStr = fmtStr.substring(pos + 1);
        this.setInput(category, patternStr);
    }

    public void setInput(String categoryStr, String patternStr, ULocale locale) {
        this.hasLoaded = false;
        String localeStr = this.provider.getLocaleDisplayName(locale);
        this.initiatePageLayout(categoryStr, patternStr, localeStr);
        this.reLayoutSubPages();
        this.updateTextByLocale();
        this.updatePreview();
        this.oldCategory = categoryStr;
        this.oldPattern = patternStr;
        this.oldLocale = localeStr;
        this.hasLoaded = true;
    }

    public void setInput(String categoryStr, String patternStr) {
        this.setInput(categoryStr, patternStr, null);
    }

    public void setPreviewText(String text) {
        this.setDefaultPreviewText(text);
        this.updatePreview();
    }

    public String getPattern() {
        return this.pattern;
    }

    public ULocale getLocale() {
        if (this.provider != null) {
            return this.getLocaleByDisplayName(this.locale);
        }
        return null;
    }

    public String getCategory() {
        return this.category;
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return this.provider.DATETIEM_FORMAT_TYPE_UNFORMATTED;
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return String.valueOf(this.category) + ":" + this.pattern;
    }

    public boolean isFormatModified() {
        String c = this.getCategory();
        String p = this.getPattern();
        String l = this.locale;
        if (this.oldCategory == null ? c != null : !this.oldCategory.equals(c)) {
            return true;
        }
        if (this.oldPattern == null ? p != null : !this.oldPattern.equals(p)) {
            return true;
        }
        return this.oldLocale == null ? l != null : !this.oldLocale.equals(l);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        if (this.content.isEnabled() != enabled) {
            this.content.setEnabled(enabled);
        }
        this.setControlsEnabeld(enabled);
    }

    private void setDefaultPreviewText(String text) {
        this.previewText = text == null || StringUtil.isBlank((String)text) ? null : text;
    }

    private String getPreviewText() {
        return this.previewText;
    }

    private void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private void setCategory(String category) {
        this.category = category;
    }

    private void setLocale(String locale) {
        this.locale = locale;
    }

    private void markDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private String validatedFmtStr(String fmtStr) {
        String text = fmtStr;
        if (text == null) {
            text = PREVIEW_TEXT_INVALID_FORMAT_CODE;
        }
        return text;
    }

    private void updatePreview() {
        this.markDirty(this.hasLoaded);
        String category = this.provider.getCategory4UIDisplayName(this.typeChoicer.getText());
        this.setCategory(category);
        ULocale locale = this.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        boolean invalidPreviewText = false;
        Date sampleDateTime = this.defaultDate;
        if (this.getPreviewText() != null && !this.getPreviewText().equals(this.defaultDateTime)) {
            try {
                sampleDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, locale).parse(this.getPreviewText());
            }
            catch (Exception exception) {
                invalidPreviewText = true;
            }
        }
        if (this.provider.DATETIEM_FORMAT_TYPE_CUSTOM.equals(category)) {
            String fmtStr;
            String pattern = this.formatCode.getText();
            if (invalidPreviewText) {
                fmtStr = PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW;
            } else {
                try {
                    fmtStr = new DateFormatter(pattern, locale).format(sampleDateTime);
                }
                catch (Exception exception) {
                    fmtStr = PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW;
                }
            }
            this.cusPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else {
            String pattern = null;
            if (!this.provider.DATETIEM_FORMAT_TYPE_UNFORMATTED.equals(category)) {
                pattern = FormatDateTimePattern.getPatternForCategory((String)category);
            }
            String fmtStr = new DateFormatter(pattern, locale).format(sampleDateTime);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        }
    }

    private void initiatePageLayout(String categoryStr, String patternStr, String localeStr) {
        if (this.locale != null) {
            this.localeChoicer.setText(localeStr);
        } else {
            this.localeChoicer.select(0);
        }
        if (categoryStr == null) {
            this.typeChoicer.select(0);
        } else {
            if (categoryStr.equals(this.provider.DATETIEM_FORMAT_TYPE_CUSTOM)) {
                this.formatCode.setText(patternStr == null ? "" : patternStr);
            }
            this.typeChoicer.select(this.provider.getIndexOfCategory(categoryStr));
        }
    }

    private void reLayoutSubPages() {
        Control control;
        String category = this.provider.getCategory4UIDisplayName(this.typeChoicer.getText());
        ((StackLayout)this.infoComp.getLayout()).topControl = control = (Control)this.categoryPageMaps.get(category);
        this.infoComp.layout();
        if (this.formatCodeComp != null) {
            ((StackLayout)this.formatCodeComp.getLayout()).topControl = category.equals(this.provider.NUMBER_FORMAT_TYPE_CUSTOM) ? this.getHorizonCustomFormatCodePage(this.formatCodeComp) : this.getHorizonGeneralFormatCodePage(this.formatCodeComp);
            this.formatCodeComp.layout();
        }
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.generalPreviewLabel = this.createGeneralPreviewPart(this.generalPage);
        }
        return this.generalPage;
    }

    private Composite getCustomPage(Composite parent) {
        if (this.customPage == null) {
            this.customPage = new Composite(parent, 0);
            this.customPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCustomSettingsPart(this.customPage);
            if (this.pageAlignment == 0) {
                Composite container = new Composite(this.customPage, 0);
                container.setLayoutData((Object)new GridData(768));
                container.setLayout((Layout)new GridLayout(2, false));
                FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_CODE);
                this.formatCode = !this.isFormStyle() ? new Text(container, 2052) : FormWidgetFactory.getInstance().createText(container, "", 4);
                this.formatCode.setLayoutData((Object)new GridData(768));
                this.formatCode.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (FormatDateTimeDescriptor.this.hasLoaded) {
                            FormatDateTimeDescriptor.this.updatePreview();
                        }
                    }
                });
                this.formatCode.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        FormatDateTimeDescriptor.this.notifyFormatChange();
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            }
            this.createCustomPreviewPart(this.customPage);
        }
        return this.customPage;
    }

    private Composite getHorizonGeneralFormatCodePage(Composite parent) {
        if (this.generalFormatCodePage == null) {
            this.generalFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.generalFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.generalFormatCodePage, 258, this.isFormStyle());
            l.setLayoutData((Object)new GridData(768));
        }
        return this.generalFormatCodePage;
    }

    private Composite getHorizonCustomFormatCodePage(Composite parent) {
        if (this.customFormatCodePage == null) {
            this.customFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.customFormatCodePage.setLayout((Layout)layout);
            Label l = FormWidgetFactory.getInstance().createLabel(this.customFormatCodePage, 258, this.isFormStyle());
            l.setLayoutData((Object)new GridData(768));
            Composite container = new Composite(this.customFormatCodePage, 0);
            container.setLayoutData((Object)new GridData(768));
            container.setLayout((Layout)new GridLayout(2, false));
            FormWidgetFactory.getInstance().createLabel(container, this.isFormStyle()).setText(LABEL_FORMAT_CODE);
            this.formatCode = !this.isFormStyle() ? new Text(container, 2052) : FormWidgetFactory.getInstance().createText(container, "", 4);
            this.formatCode.setLayoutData((Object)new GridData(768));
            this.formatCode.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (FormatDateTimeDescriptor.this.hasLoaded) {
                        FormatDateTimeDescriptor.this.updatePreview();
                    }
                }
            });
            this.formatCode.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    FormatDateTimeDescriptor.this.notifyFormatChange();
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.customFormatCodePage;
    }

    private Label createGeneralPreviewPart(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Label previewLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x1000300, this.isFormStyle());
        previewLabel.setLayoutData((Object)new GridData(1808));
        return previewLabel;
    }

    private void createCustomSettingsPart(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_CUSTOM_SETTINGS);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        label.setText(LABEL_CUSTOM_SETTINGS_LABEL);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createTable((Composite)group);
    }

    private void createCustomPreviewPart(Composite parent) {
        Group group = !this.isFormStyle() ? new Group(parent, 0) : FormWidgetFactory.getInstance().createGroup(parent, "");
        group.setText(LABEL_PREVIEW_GROUP);
        if (this.pageAlignment == 1) {
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
        } else {
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
        }
        FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle()).setText(LABEL_PREVIEW_DATETIME);
        this.previewTextBox = !this.isFormStyle() ? new Text((Composite)group, 2052) : FormWidgetFactory.getInstance().createText((Composite)group, "", 4);
        this.previewTextBox.setText(this.defaultDateTime == null ? "" : this.defaultDateTime);
        GridData data = new GridData(768);
        if (this.pageAlignment == 1) {
            data.horizontalIndent = 10;
        }
        this.previewTextBox.setLayoutData((Object)data);
        this.previewTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatDateTimeDescriptor.this.setDefaultPreviewText(FormatDateTimeDescriptor.this.previewTextBox.getText());
                if (FormatDateTimeDescriptor.this.hasLoaded) {
                    FormatDateTimeDescriptor.this.updatePreview();
                }
                if (StringUtil.isBlank((String)FormatDateTimeDescriptor.this.previewTextBox.getText())) {
                    FormatDateTimeDescriptor.this.guideLabel.setText("");
                } else {
                    FormatDateTimeDescriptor.this.guideLabel.setText(ENTER_DATE_TIME_GUIDE_TEXT);
                }
            }
        });
        if (this.pageAlignment == 0) {
            FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        }
        this.guideLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        this.guideLabel.setText("");
        Font font = JFaceResources.getDialogFont();
        FontData fData = font.getFontData()[0];
        fData.setHeight(fData.getHeight() - 1);
        this.guideLabel.setFont(FontManager.getFont((FontData)fData));
        data = new GridData(768);
        data.horizontalIndent = 10;
        this.guideLabel.setLayoutData((Object)data);
        Label label = FormWidgetFactory.getInstance().createLabel((Composite)group, this.isFormStyle());
        label.setText(LABEL_PREVIEW_LABEL);
        label.setLayoutData((Object)new GridData());
        this.cusPreviewLabel = FormWidgetFactory.getInstance().createLabel((Composite)group, 0x11000100, this.isFormStyle());
        this.cusPreviewLabel.setText("");
        data = new GridData(1808);
        data.horizontalSpan = 1;
        this.cusPreviewLabel.setLayoutData((Object)data);
    }

    private void createTable(Composite parent) {
        this.table = !this.isFormStyle() ? new Table(parent, 100352) : FormWidgetFactory.getInstance().createTable(parent, 98304);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        if (this.pageAlignment == 1) {
            data.widthHint = 240;
        }
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimeDescriptor.this.formatCode.setText(((TableItem)e.item).getText(2));
                FormatDateTimeDescriptor.this.updatePreview();
                FormatDateTimeDescriptor.this.notifyFormatChange();
            }
        });
        TableColumn tableColumValue = new TableColumn(this.table, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_NAME);
        tableColumValue.setWidth(120);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.table, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(115);
        tableColumnDisplay.setResizable(true);
        TableColumn tableColumnFormatCode = new TableColumn(this.table, 0);
        tableColumnFormatCode.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumnFormatCode.setWidth(150);
        tableColumnFormatCode.setResizable(true);
        String[][] items = this.provider.getTableItems(null);
        int i = 0;
        while (i < items.length) {
            new TableItem(this.table, 0).setText(items[i]);
            ++i;
        }
    }

    private void updateTextByLocale() {
        ULocale oldLocale = this.getLocaleByDisplayName(this.locale);
        Date sampleDateTime = this.defaultDate;
        try {
            if (this.getPreviewText() != null) {
                sampleDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, oldLocale).parse(this.getPreviewText());
            }
        }
        catch (ParseException parseException) {}
        this.setLocale(this.localeChoicer.getText());
        ULocale locale = this.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        int index = this.typeChoicer.getSelectionIndex();
        this.typeChoicer.setItems(this.provider.getFormatTypes(locale));
        if (index >= 0 && index < this.typeChoicer.getItemCount()) {
            this.typeChoicer.select(index);
        }
        String[][] items = this.provider.getTableItems(locale);
        int i = 0;
        while (i < items.length) {
            this.table.getItem(i).setText(items[i]);
            ++i;
        }
        if (this.table.getSelectionCount() == 1) {
            this.formatCode.setText(this.table.getSelection()[0].getText(2));
        }
        String sampleDateTimeString = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, locale).format(sampleDateTime);
        this.previewTextBox.setText(sampleDateTimeString);
        this.setPreviewText(sampleDateTimeString);
    }

    private GridLayout createGridLayout4Page() {
        GridLayout layout;
        if (this.pageAlignment == 1) {
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
        }
        return layout;
    }

    private GridData createGridData4Part() {
        GridData data = this.pageAlignment == 1 ? new GridData(1040) : new GridData(768);
        return data;
    }

    private void setControlsEnabeld(boolean b) {
        if (this.typeChoicer.isEnabled() != b) {
            this.typeChoicer.setEnabled(b);
        }
        if (this.localeChoicer.isEnabled() != b) {
            this.localeChoicer.setEnabled(b);
        }
        if (this.formatCode.isEnabled() != b) {
            this.formatCode.setEnabled(b);
        }
        if (this.previewTextBox.isEnabled() != b) {
            this.previewTextBox.setEnabled(b);
        }
        if (this.table.isEnabled() != b) {
            this.table.setEnabled(b);
        }
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof FormatDataTimeDescriptorProvider) {
            this.provider = (FormatDataTimeDescriptorProvider)provider;
        }
    }
}

