/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class MasterColumnsPropertyDescriptor
extends PropertyDescriptor {
    private Composite content;
    private Button oneColumnsButton;
    private Button twoColumnsButton;
    private Button threeColumnsButton;
    private Button customColumnsButton;
    private Spinner spinner;
    SelectionAdapter listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (((Button)e.widget).getSelection()) {
                MasterColumnsPropertyDescriptor.this.checkButtonSelection((Button)e.widget, true);
            }
        }
    };

    public MasterColumnsPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        this.content.setLayout((Layout)layout);
        GridData spanGd = new GridData();
        spanGd.widthHint = 40;
        spanGd.verticalSpan = 2;
        this.oneColumnsButton = FormWidgetFactory.getInstance().createButton(this.content, 16, this.isFormStyle());
        this.oneColumnsButton.setText(Messages.getString((String)"MasterColumnsPropertyDescriptor.Button.Text.OneColumn"));
        this.oneColumnsButton.addKeyListener((KeyListener)new KeyAdapter(){});
        this.oneColumnsButton.addSelectionListener((SelectionListener)this.listener);
        FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle()).setLayoutData((Object)spanGd);
        this.twoColumnsButton = FormWidgetFactory.getInstance().createButton(this.content, 16, this.isFormStyle());
        this.twoColumnsButton.setText(Messages.getString((String)"MasterColumnsPropertyDescriptor.Button.Text.TwoColumns"));
        this.twoColumnsButton.addSelectionListener((SelectionListener)this.listener);
        this.twoColumnsButton.addKeyListener((KeyListener)new KeyAdapter(){});
        FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle()).setLayoutData((Object)spanGd);
        this.threeColumnsButton = FormWidgetFactory.getInstance().createButton(this.content, 16, this.isFormStyle());
        this.threeColumnsButton.setText(Messages.getString((String)"MasterColumnsPropertyDescriptor.Button.Text.ThreeColumns"));
        this.threeColumnsButton.setLayoutData((Object)new GridData(2));
        this.threeColumnsButton.addSelectionListener((SelectionListener)this.listener);
        this.threeColumnsButton.addKeyListener((KeyListener)new KeyAdapter(){});
        FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle()).setLayoutData((Object)spanGd);
        this.customColumnsButton = FormWidgetFactory.getInstance().createButton(this.content, 16, this.isFormStyle());
        this.customColumnsButton.setText(Messages.getString((String)"MasterColumnsPropertyDescriptor.Button.Text.Custom"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.customColumnsButton.setLayoutData((Object)gd);
        this.customColumnsButton.addSelectionListener((SelectionListener)this.listener);
        this.customColumnsButton.addKeyListener((KeyListener)new KeyAdapter(){});
        Label oneColumnLabel = FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle());
        oneColumnLabel.setImage(ReportPlatformUIImages.getImage((String)"Master Page One Column"));
        Label twoColumnLabel = FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle());
        twoColumnLabel.setImage(ReportPlatformUIImages.getImage((String)"Master Page Two Column"));
        Label threeColumnLabel = FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle());
        threeColumnLabel.setImage(ReportPlatformUIImages.getImage((String)"Master Page Three Column"));
        Label customNumberLabel = FormWidgetFactory.getInstance().createLabel(this.content, this.isFormStyle());
        customNumberLabel.setLayoutData((Object)new GridData(2));
        customNumberLabel.setText(Messages.getString((String)"MasterColumnsPropertyDescriptor.Combo.Text.Column.Number"));
        this.spinner = this.isFormStyle() ? FormWidgetFactory.getInstance().createSpinner(this.content, 0) : new Spinner(this.content, 2048);
        this.spinner.setEnabled(false);
        this.spinner.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (MasterColumnsPropertyDescriptor.this.customColumnsButton.getSelection()) {
                    try {
                        MasterColumnsPropertyDescriptor.this.save(MasterColumnsPropertyDescriptor.this.spinner.getText());
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
        gd = new GridData(2);
        gd.widthHint = 60;
        this.spinner.setLayoutData((Object)gd);
        this.spinner.setMinimum(4);
        return this.content;
    }

    private void checkButtonSelection(Button button) {
        this.checkButtonSelection(button, false);
    }

    private void checkButtonSelection(Button button, boolean save) {
        try {
            if (this.oneColumnsButton == button && this.oneColumnsButton.getSelection()) {
                this.oneColumnsButton.setSelection(true);
                this.twoColumnsButton.setSelection(false);
                this.threeColumnsButton.setSelection(false);
                this.customColumnsButton.setSelection(false);
                this.spinner.setEnabled(false);
                if (save) {
                    this.save("1");
                }
            } else if (this.twoColumnsButton == button && this.twoColumnsButton.getSelection()) {
                this.twoColumnsButton.setSelection(true);
                this.oneColumnsButton.setSelection(false);
                this.threeColumnsButton.setSelection(false);
                this.customColumnsButton.setSelection(false);
                this.spinner.setEnabled(false);
                if (save) {
                    this.save("2");
                }
            } else if (this.threeColumnsButton == button && this.threeColumnsButton.getSelection()) {
                this.threeColumnsButton.setSelection(true);
                this.oneColumnsButton.setSelection(false);
                this.twoColumnsButton.setSelection(false);
                this.customColumnsButton.setSelection(false);
                this.spinner.setEnabled(false);
                if (save) {
                    this.save("3");
                }
            } else if (this.customColumnsButton == button && this.customColumnsButton.getSelection()) {
                this.customColumnsButton.setSelection(true);
                this.oneColumnsButton.setSelection(false);
                this.twoColumnsButton.setSelection(false);
                this.threeColumnsButton.setSelection(false);
                this.spinner.setEnabled(true);
                if (save) {
                    this.save(this.spinner.getText());
                }
            }
        }
        catch (SemanticException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    public Control getControl() {
        return this.content;
    }

    public void load() {
        if (this.getDescriptorProvider() != null) {
            block9: {
                Object value = this.getDescriptorProvider().load();
                if (value != null) {
                    try {
                        int columns = Integer.parseInt(value.toString());
                        if (columns == 1) {
                            this.oneColumnsButton.setSelection(true);
                            this.checkButtonSelection(this.oneColumnsButton);
                            break block9;
                        }
                        if (columns == 2) {
                            this.twoColumnsButton.setSelection(true);
                            this.checkButtonSelection(this.twoColumnsButton);
                            break block9;
                        }
                        if (columns == 3) {
                            this.threeColumnsButton.setSelection(true);
                            this.checkButtonSelection(this.threeColumnsButton);
                            break block9;
                        }
                        if (columns > 1) {
                            this.customColumnsButton.setSelection(true);
                            this.spinner.setSelection(columns);
                            this.spinner.setEnabled(true);
                            this.checkButtonSelection(this.customColumnsButton);
                            break block9;
                        }
                        this.oneColumnsButton.setSelection(true);
                        this.checkButtonSelection(this.oneColumnsButton);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.oneColumnsButton.setSelection(true);
                        this.checkButtonSelection(this.oneColumnsButton);
                    }
                } else {
                    this.oneColumnsButton.setSelection(true);
                    this.checkButtonSelection(this.oneColumnsButton);
                }
            }
            this.spinner.setEnabled(this.customColumnsButton.getSelection());
        }
    }

    public void save(Object obj) throws SemanticException {
        if (this.oneColumnsButton.getSelection()) {
            this.getDescriptorProvider().save("1");
        }
        if (this.twoColumnsButton.getSelection()) {
            this.getDescriptorProvider().save("2");
        }
        if (this.threeColumnsButton.getSelection()) {
            this.getDescriptorProvider().save("3");
        } else if (this.customColumnsButton.getSelection()) {
            if (this.spinner.getText().trim().length() == 0) {
                this.getDescriptorProvider().save(null);
            } else {
                this.getDescriptorProvider().save(this.spinner.getText().trim());
            }
        }
    }

    public void setInput(Object handle) {
        this.getDescriptorProvider().setInput(handle);
    }
}

