/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data.providers;

import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.CascadingParametersDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterGroupDialog;
import org.eclipse.birt.report.designer.ui.dialogs.VariableDialog;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class VariablesNodeProvider
extends DefaultNodeProvider {
    public Object[] getChildren(Object model) {
        if (model instanceof PropertyHandle) {
            return ((PropertyHandle)model).getListValue().toArray();
        }
        return super.getChildren(model);
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new AddVariableAction(object));
        super.createContextMenu(sourceViewer, object, menu);
    }

    public String getNodeDisplayName(Object object) {
        return Messages.getString((String)"VariablesNodeProvider.NodeName");
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        DesignElementHandle handle = super.createElement(type);
        ParameterGroupDialog dialog = null;
        if ("ParameterGroup".equals(type)) {
            dialog = new ParameterGroupDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"ParametersNodeProvider.dialogue.title.group"));
            dialog.setInput((Object)handle);
        } else if ("ScalarParameter".equals(type)) {
            dialog = new ParameterDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ParametersNodeProvider.dialogue.title.parameter"));
            ((ParameterDialog)dialog).setInput((Object)handle);
        }
        if (dialog == null) {
            return null;
        }
        if (dialog.open() == 1) {
            return null;
        }
        return (DesignElementHandle)dialog.getResult();
    }

    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendData) throws Exception {
        if ("CascadingParameterGroup".equals(type)) {
            DesignElementHandle handle = super.createElement(type);
            slotHandle.add(handle);
            CascadingParametersDialog dialog = new CascadingParametersDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ParameterNodeProvider.dial.title.newCascading"));
            dialog.setInput((Object)handle);
            return dialog.open() == 0;
        }
        return super.performInsert(model, slotHandle, type, position, extendData);
    }

    public String getIconName(Object model) {
        return "Parameters";
    }

    private class AddVariableAction
    extends AbstractElementAction {
        public AddVariableAction(Object selectedObject) {
            super(selectedObject, Messages.getString((String)"VariablesNodeProvider.NewActionName"));
        }

        protected boolean doAction() throws Exception {
            VariableDialog dialog = new VariableDialog(Messages.getString((String)"VariablesNodeProvider.NewActionName"), (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), null);
            dialog.open();
            return true;
        }
    }
}

