/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AdvancePropertyPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AlterPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BaseAttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BindingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BookMarkExpressionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BordersPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CategoryPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CellPaddingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CommentsPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FontPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FormPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.HyperLinkPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ItemMarginPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.NamedExpressionsPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.PreviewPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.SectionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.TOCExpressionPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.UserPropertiesPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.VisibilityPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.HighlightPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.extensions.IPropertyTabUI;
import org.eclipse.birt.report.designer.ui.views.attributes.ICategoryPage;
import org.eclipse.birt.report.designer.ui.views.attributes.TabPage;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesUtil {
    public static final String FONT = "Font";
    public static final String PADDING = "Padding";
    public static final String ALT = "AltText";
    public static final String BORDER = "Borders";
    public static final String MARGIN = "Margin";
    public static final String HYPERLINK = "HyperLink";
    public static final String SECTION = "Section";
    public static final String VISIBILITY = "Visibility";
    public static final String TOC = "TOC";
    public static final String BOOKMARK = "Bookmark";
    public static final String USERPROPERTIES = "UserProperties";
    public static final String NAMEDEXPRESSIONS = "NamedExpressions";
    public static final String COMMENTS = "Comments";
    public static final String ADVANCEPROPERTY = "AdvanceProperty";
    public static final String EVENTHANDLER = "EventHandler";
    private static Map<String, String> categoryMap = new HashMap<String, String>();
    private static Map<String, Class<?>> paneClassMap = new HashMap();

    static {
        AttributesUtil.addCategory(FONT, Messages.getString((String)"GridPageGenerator.List.Font"), FontPage.class);
        AttributesUtil.addCategory(PADDING, Messages.getString((String)"DataPageGenerator.List.Padding"), CellPaddingPage.class);
        AttributesUtil.addCategory(ALT, Messages.getString((String)"ImagePageGenerator.List.AltText"), AlterPage.class);
        AttributesUtil.addCategory(BORDER, Messages.getString((String)"DataPageGenerator.List.Borders"), BordersPage.class);
        AttributesUtil.addCategory(MARGIN, Messages.getString((String)"DataPageGenerator.List.Margin"), ItemMarginPage.class);
        AttributesUtil.addCategory(HYPERLINK, Messages.getString((String)"DataPageGenerator.List.HyperLink"), HyperLinkPage.class);
        AttributesUtil.addCategory(SECTION, Messages.getString((String)"DataPageGenerator.List.Section"), SectionPage.class);
        AttributesUtil.addCategory(VISIBILITY, Messages.getString((String)"DataPageGenerator.List.Visibility"), VisibilityPage.class);
        AttributesUtil.addCategory(TOC, Messages.getString((String)"DataPageGenerator.List.TOC"), TOCExpressionPage.class);
        AttributesUtil.addCategory(BOOKMARK, Messages.getString((String)"DataPageGenerator.List.Bookmark"), BookMarkExpressionPage.class);
        AttributesUtil.addCategory(USERPROPERTIES, Messages.getString((String)"ReportPageGenerator.List.UserProperties"), UserPropertiesPage.class);
        AttributesUtil.addCategory(NAMEDEXPRESSIONS, Messages.getString((String)"ReportPageGenerator.List.NamedExpressions"), NamedExpressionsPage.class);
        AttributesUtil.addCategory(COMMENTS, Messages.getString((String)"ReportPageGenerator.List.Comments"), CommentsPage.class);
        AttributesUtil.addCategory(ADVANCEPROPERTY, Messages.getString((String)"ReportPageGenerator.List.AdvancedProperty"), AdvancePropertyPage.class);
    }

    private AttributesUtil() {
    }

    public static void addCategory(String id, String displayLabelKey, Class pageClass) {
        assert (id != null);
        assert (pageClass != null);
        categoryMap.put(id, displayLabelKey);
        paneClassMap.put(id, pageClass);
    }

    public static IPropertyTabUI buildGeneralPage(Composite parent, String[] categories, String[] customKeys, String[] customCategories, PageWrapper[] customPageWrappers, Object input) {
        BaseAttributePage basicPage = new BaseAttributePage();
        LinkedHashMap<String, String> categorys = new LinkedHashMap<String, String>();
        ArrayList<Object> paneClassList = new ArrayList<Object>();
        if (categories == null) {
            if (customCategories != null && customPageWrappers != null) {
                int i = 0;
                while (i < customCategories.length) {
                    categorys.put(customKeys[i], customCategories[i]);
                    paneClassList.add(customPageWrappers[i]);
                    ++i;
                }
            }
        } else {
            int customIndex = 0;
            int i = 0;
            while (i < categories.length) {
                if (categories[i] == null) {
                    if (customCategories != null && customPageWrappers != null && customCategories.length > customIndex) {
                        categorys.put(customKeys[customIndex], customCategories[customIndex]);
                        paneClassList.add(customPageWrappers[customIndex]);
                        ++customIndex;
                    }
                } else {
                    String cat = categoryMap.get(categories[i]);
                    if (cat instanceof String) {
                        categorys.put(categories[i], cat);
                        paneClassList.add(paneClassMap.get(categories[i]));
                    }
                }
                ++i;
            }
            if (customCategories != null && customPageWrappers != null && customCategories.length > customIndex) {
                i = customIndex;
                while (i < customCategories.length) {
                    categorys.put(customKeys[customIndex], customCategories[customIndex]);
                    paneClassList.add(customPageWrappers[customIndex]);
                    ++customIndex;
                    ++i;
                }
            }
        }
        Object[] clss = paneClassList.toArray(new Object[0]);
        basicPage.setCategoryProvider(new ExtendedCategoryProvider(categorys, clss));
        basicPage.setInput(input);
        basicPage.buildUI(parent);
        return basicPage;
    }

    public static String getGeneralPageDisplayName() {
        return Messages.getString((String)"CategoryPageGenerator.TabItem.Attributes");
    }

    public static IPropertyTabUI buildBindingPage(Composite parent, Object input) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        BindingPage page = new BindingPage();
        page.setInput(input);
        page.buildUI(parent);
        return page;
    }

    public static String getBindingPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Binding");
    }

    public static IPropertyTabUI buildFilterPage(Composite parent, Object input) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        FormPage page = new FormPage(3, new FilterHandleProvider(), true, true);
        page.setInput(input);
        page.buildUI(parent);
        return page;
    }

    public static String getFilterPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Filters");
    }

    public static IPropertyTabUI buildHighlightPage(Composite parent, Object input) {
        GridLayout gl = new GridLayout();
        parent.setLayout((Layout)gl);
        PreviewPage page = new PreviewPage(true);
        page.setPreview(new HighlightPropertyDescriptor(true));
        page.setProvider(new HighlightDescriptorProvider());
        page.setInput(input);
        page.buildUI(parent);
        return page;
    }

    public static String getHighlightPageDisplayName() {
        return Messages.getString((String)"TablePageGenerator.TabItem.Highlights");
    }

    public static void setPageInput(IPropertyTabUI page, Object input) {
        page.setInput(input);
        if (page instanceof TabPage && page.getControl() != null) {
            ((TabPage)page).refresh();
        }
    }

    public static void handleError(Throwable e) {
        ExceptionHandler.handle((Throwable)e);
    }

    public static ICategoryProvider createCategoryProvider(String[] categories, String[] customKeys, String[] customLabels, Class<?>[] customPageClasses) {
        ArrayList paneClassList;
        LinkedHashMap<String, String> categorys;
        block9: {
            block8: {
                categorys = new LinkedHashMap<String, String>();
                paneClassList = new ArrayList();
                if (categories != null) break block8;
                if (customKeys == null || customLabels == null || customPageClasses == null) break block9;
                int i = 0;
                while (i < customKeys.length) {
                    categorys.put(customKeys[i], customLabels[i]);
                    paneClassList.add(customPageClasses[i]);
                    ++i;
                }
                break block9;
            }
            int currentCustomIndex = 0;
            int i = 0;
            while (i < categories.length) {
                if (categories[i] == null) {
                    if (customKeys != null && customPageClasses != null && customKeys.length > currentCustomIndex) {
                        categorys.put(customKeys[currentCustomIndex], customLabels[currentCustomIndex]);
                        paneClassList.add(customPageClasses[currentCustomIndex]);
                        ++currentCustomIndex;
                    }
                } else {
                    String cat = categoryMap.get(categories[i]);
                    if (cat instanceof String) {
                        categorys.put(categories[i], cat);
                        paneClassList.add(paneClassMap.get(categories[i]));
                    }
                }
                ++i;
            }
            if (customKeys != null && customPageClasses != null && customKeys.length > currentCustomIndex) {
                i = currentCustomIndex;
                while (i < customKeys.length) {
                    categorys.put(customKeys[i], customLabels[i]);
                    paneClassList.add(customPageClasses[i]);
                    ++i;
                }
            }
        }
        return new ExtendedCategoryProvider(categorys, paneClassList.toArray(new Object[paneClassList.size()]));
    }

    public static boolean containCategory(String categoryId) {
        return categoryMap.containsKey(categoryId);
    }

    public static ICategoryPage getCategory(String categoryId) {
        if (AttributesUtil.containCategory(categoryId)) {
            return new CategoryPage(categoryId, categoryMap.get(categoryId), paneClassMap.get(categoryId));
        }
        return null;
    }

    public static String getCategoryDisplayName(String categoryId) {
        if (AttributesUtil.containCategory(categoryId)) {
            return categoryMap.get(categoryId);
        }
        return categoryId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtendedCategoryProvider
    implements ICategoryProvider {
        private LinkedHashMap<String, String> categories;
        private Object[] paneObjects;

        ExtendedCategoryProvider(LinkedHashMap<String, String> categories, Object[] paneObjects) {
            assert (categories != null);
            assert (paneObjects != null);
            assert (categories.size() == paneObjects.length);
            this.categories = categories;
            this.paneObjects = paneObjects;
        }

        @Override
        public ICategoryPage[] getCategories() {
            ArrayList<ICategoryPage> pageList = new ArrayList<ICategoryPage>(this.categories.size());
            int i = 0;
            for (Map.Entry<String, String> entry : this.categories.entrySet()) {
                final String displayLabel = entry.getValue();
                final String categoryKey = entry.getKey();
                Object pane = this.paneObjects[i];
                if (pane instanceof Class && PageWrapper.class.isAssignableFrom((Class)pane)) {
                    try {
                        pane = ((Class)pane).getConstructor(null).newInstance(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (pane instanceof Class) {
                    pageList.add(new CategoryPage(categoryKey, displayLabel, (Class)pane));
                } else if (pane instanceof PageWrapper) {
                    final PageWrapper wrapper = (PageWrapper)pane;
                    pageList.add(new ICategoryPage(){

                        public String getDisplayLabel() {
                            return displayLabel;
                        }

                        public TabPage createPage() {
                            return wrapper.getPage();
                        }

                        public String getCategoryKey() {
                            return categoryKey;
                        }
                    });
                }
                ++i;
            }
            return pageList.toArray(new ICategoryPage[pageList.size()]);
        }
    }

    public static abstract class PageWrapper
    implements IModelEventProcessor {
        private AttributePage page;

        public TabPage getPage() {
            if (this.page == null) {
                this.page = new AttributePage(){

                    public void buildUI(Composite parent) {
                        super.buildUI(parent);
                        PageWrapper.this.buildUI(parent);
                    }

                    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
                        PageWrapper.this.addElementEvent(focus, ev);
                    }

                    public void clear() {
                        PageWrapper.this.clear();
                    }

                    public void postElementEvent() {
                        PageWrapper.this.postElementEvent();
                    }

                    public Object getAdapter(Class adapter) {
                        return PageWrapper.this.getAdapter(adapter);
                    }

                    public void refresh() {
                        PageWrapper.this.refresh();
                        super.refresh();
                    }

                    public void setInput(Object elements) {
                        super.setInput(elements);
                        PageWrapper.this.setInput(elements);
                    }

                    public void dispose() {
                        PageWrapper.this.dispose();
                        super.dispose();
                    }
                };
            }
            return this.page;
        }

        public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
        }

        public void clear() {
        }

        public void postElementEvent() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public abstract void buildUI(Composite var1);

        public void setInput(Object input) {
        }

        public void refresh() {
        }

        public void dispose() {
        }
    }
}

