/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.viewer;

import java.io.IOException;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.wikitext.core.util.css.Stylesheet;
import org.eclipse.mylyn.internal.wikitext.ui.util.ImageCache;
import org.eclipse.mylyn.internal.wikitext.ui.util.WikiTextUiResources;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.HtmlTextPresentationParser;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.ImageManager;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.BulletDrawingStrategy;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.HorizontalRuleDrawingStrategy;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.ImageDrawingStrategy;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.xml.sax.SAXException;

public class HtmlViewer
extends SourceViewer {
    private TextPresentation textPresentation;
    private boolean haveInit = false;
    private HtmlViewerConfiguration configuration;
    private final ImageCache imageCache = new ImageCache();
    private boolean displayImages = true;
    private Stylesheet stylesheet;
    private Font defaultMonospaceFont;

    public HtmlViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
        this.setEditable(false);
    }

    public HtmlViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.setEditable(false);
    }

    private void initPainter() {
        if (this.haveInit) {
            return;
        }
        this.haveInit = true;
        ColorRegistry colorRegistry = WikiTextUiResources.getColors();
        IAnnotationAccess annotationAccess = new IAnnotationAccess(){

            public Object getType(Annotation annotation) {
                return annotation.getType();
            }

            public boolean isMultiLine(Annotation annotation) {
                return true;
            }

            public boolean isTemporary(Annotation annotation) {
                return true;
            }
        };
        AnnotationPainter painter = new AnnotationPainter((ISourceViewer)this, annotationAccess);
        painter.addDrawingStrategy((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.bullet", (AnnotationPainter.IDrawingStrategy)new BulletDrawingStrategy());
        painter.addAnnotationType((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.bullet", (Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.bullet");
        painter.setAnnotationTypeColor((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.bullet", this.getTextWidget().getForeground());
        painter.addDrawingStrategy((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.hr", (AnnotationPainter.IDrawingStrategy)new HorizontalRuleDrawingStrategy());
        painter.addAnnotationType((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.hr", (Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.hr");
        painter.setAnnotationTypeColor((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.hr", colorRegistry.get("HR"));
        if (this.displayImages) {
            painter.addDrawingStrategy((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.image", (AnnotationPainter.IDrawingStrategy)new ImageDrawingStrategy(this));
            painter.addAnnotationType((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.image", (Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.image");
            painter.setAnnotationTypeColor((Object)"org.eclipse.mylyn.internal.wikitext.ui.viewer.annotation.image", this.getTextWidget().getForeground());
        }
        this.addTextPresentationListener((ITextPresentationListener)painter);
        this.addPainter((IPainter)painter);
        this.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                HtmlViewer.this.imageCache.dispose();
            }
        });
        if (this.displayImages) {
            new ImageManager(this, this.imageCache, painter);
        }
    }

    protected ParseResult parse(String htmlText) {
        this.initPainter();
        ParseResult result = new ParseResult();
        result.textPresentation = new TextPresentation();
        HtmlTextPresentationParser parser = new HtmlTextPresentationParser();
        if (this.stylesheet != null) {
            parser.setStylesheet(this.stylesheet);
        }
        if (this.displayImages) {
            parser.setImageCache(this.imageCache);
            parser.setEnableImages(this.displayImages);
        }
        parser.setPresentation(result.textPresentation);
        parser.setDefaultFont(this.getTextWidget().getFont());
        parser.setDefaultMonospaceFont(this.defaultMonospaceFont);
        result.annotationModel = new AnnotationModel();
        parser.setAnnotationModel((IAnnotationModel)result.annotationModel);
        GC gc = new GC((Drawable)this.getTextWidget());
        try {
            try {
                parser.setGC(gc);
                parser.parse(htmlText);
            }
            catch (SAXException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            gc.dispose();
        }
        result.text = parser.getText();
        return result;
    }

    public void configure(SourceViewerConfiguration configuration) {
        if (configuration instanceof HtmlViewerConfiguration) {
            this.configuration = (HtmlViewerConfiguration)configuration;
            if (this.textPresentation != null) {
                this.configuration.setTextPresentation(this.textPresentation);
            }
        }
        super.configure(configuration);
    }

    public void setHtml(String htmlText) {
        ParseResult result = this.parse(htmlText);
        this.textPresentation = result.textPresentation;
        if (this.configuration != null) {
            this.configuration.setTextPresentation(this.textPresentation);
        }
        this.setDocumentNoMarkup((IDocument)new Document(result.text), (IAnnotationModel)result.annotationModel);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        if (document != null) {
            String htmlText = document.get();
            if (htmlText.length() > 0) {
                ParseResult result = this.parse(htmlText);
                this.textPresentation = result.textPresentation;
                document.set(result.text);
                annotationModel = result.annotationModel;
            } else if (this.textPresentation != null) {
                this.textPresentation.clear();
            } else {
                this.textPresentation = new TextPresentation();
            }
            if (this.configuration != null) {
                this.configuration.setTextPresentation(this.textPresentation);
            }
        }
        this.setDocumentNoMarkup(document, annotationModel);
    }

    protected void setDocumentNoMarkup(IDocument document, IAnnotationModel annotationModel) {
        super.setDocument(document, annotationModel, -1, -1);
    }

    public TextPresentation getTextPresentation() {
        return this.textPresentation;
    }

    public void setTextPresentation(TextPresentation textPresentation) {
        this.textPresentation = textPresentation;
        if (this.configuration != null) {
            this.configuration.setTextPresentation(textPresentation);
        }
        this.changeTextPresentation(textPresentation, false);
    }

    public boolean isDisplayImages() {
        return this.displayImages;
    }

    public void setDisplayImages(boolean displayImages) {
        this.displayImages = displayImages;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public Font getDefaultMonospaceFont() {
        return this.defaultMonospaceFont;
    }

    public void setDefaultMonospaceFont(Font defaultMonospaceFont) {
        this.defaultMonospaceFont = defaultMonospaceFont;
    }

    protected static class ParseResult {
        public TextPresentation textPresentation;
        TextPresentation presentation;
        String text;
        AnnotationModel annotationModel;

        protected ParseResult() {
        }
    }
}

