/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.internal.team.ui.actions.Messages;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.resources.ui.ResourcesUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ObjectPluginAction;

public class AddToTaskContextAction
extends Action
implements IViewActionDelegate {
    private ISelection selection;

    public AddToTaskContextAction() {
        this.setText(Messages.AddToTaskContextAction_Add_to_Task_Context);
        this.setToolTipText(Messages.AddToTaskContextAction_Add_to_Task_Context);
        this.setImageDescriptor(TasksUiImages.CONTEXT_ADD);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        if (this.selection instanceof StructuredSelection) {
            this.run((StructuredSelection)this.selection);
        }
    }

    public void run(IAction action) {
        ObjectPluginAction objectAction;
        if (action instanceof ObjectPluginAction && (objectAction = (ObjectPluginAction)action).getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)objectAction.getSelection();
            this.run(selection);
        }
    }

    private void run(StructuredSelection selection) {
        if (!ContextCore.getContextManager().isContextActive()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AddToTaskContextAction_Add_to_Task_Context, (String)Messages.AddToTaskContextAction_ACTIVATE_TASK_TO_ADD_RESOURCES);
        }
        Object element = selection.getFirstElement();
        IResource[] resources = null;
        if (element instanceof ActiveChangeSet) {
            resources = ((ActiveChangeSet)element).getResources();
        } else if (element instanceof DiffChangeSet) {
            resources = ((DiffChangeSet)element).getResources();
        } else if (element instanceof LinkedTaskInfo) {
            LinkedTaskInfo linkedTaskInfo = (LinkedTaskInfo)element;
            ChangeSet changeSet = linkedTaskInfo.getChangeSet();
            resources = changeSet.getResources();
        }
        HashSet<IResource> resourcesToAdd = new HashSet<IResource>();
        if (resources != null) {
            resourcesToAdd.addAll(Arrays.asList(resources));
        } else {
            for (Object object : selection) {
                Object adapted;
                if (object instanceof IResource) {
                    resourcesToAdd.add((IResource)object);
                    continue;
                }
                if (object instanceof SynchronizeModelElement) {
                    resourcesToAdd.add(((SynchronizeModelElement)object).getResource());
                    continue;
                }
                if (!(object instanceof IAdaptable) || (adapted = ((IAdaptable)object).getAdapter(IResource.class)) == null) continue;
                resourcesToAdd.add((IResource)adapted);
            }
        }
        if (!resourcesToAdd.isEmpty()) {
            ResourcesUi.addResourceToContext(resourcesToAdd, (InteractionEvent.Kind)InteractionEvent.Kind.SELECTION);
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AddToTaskContextAction_Add_to_Task_Context, (String)Messages.AddToTaskContextAction_No_resources_to_add);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

