/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.ICopyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;

public class ResolvedInstallableUnit
implements IInstallableUnit {
    private static IInstallableUnit[] NO_IU = new IInstallableUnit[0];
    private IInstallableUnit[] fragments = NO_IU;
    protected IInstallableUnit original;

    public ResolvedInstallableUnit(IInstallableUnit resolved) {
        this.original = resolved;
    }

    public ResolvedInstallableUnit(IInstallableUnit resolved, IInstallableUnitFragment[] fragments) {
        this.original = resolved;
        this.fragments = fragments;
    }

    public IInstallableUnitFragment[] getFragments() {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        if (this.fragments != null) {
            result.addAll(Arrays.asList(this.fragments));
        }
        int i = 0;
        while (i < result.size()) {
            IInstallableUnit fragment = (IInstallableUnit)result.get(i);
            if (fragment.isResolved()) {
                result.addAll(Arrays.asList(fragment.getFragments()));
            }
            ++i;
        }
        return result.toArray(new IInstallableUnitFragment[result.size()]);
    }

    public IArtifactKey[] getArtifacts() {
        return this.original.getArtifacts();
    }

    public String getFilter() {
        return this.original.getFilter();
    }

    public String getId() {
        return this.original.getId();
    }

    public String getProperty(String key) {
        return this.original.getProperty(key);
    }

    public Map getProperties() {
        return this.original.getProperties();
    }

    public IProvidedCapability[] getProvidedCapabilities() {
        ArrayList<IProvidedCapability> result = new ArrayList<IProvidedCapability>();
        result.addAll(Arrays.asList(this.original.getProvidedCapabilities()));
        int i = 0;
        while (i < this.fragments.length) {
            result.addAll(Arrays.asList(this.fragments[i].getProvidedCapabilities()));
            ++i;
        }
        return result.toArray(new IProvidedCapability[result.size()]);
    }

    public IRequiredCapability[] getRequiredCapabilities() {
        ArrayList<IRequiredCapability> result = new ArrayList<IRequiredCapability>();
        result.addAll(Arrays.asList(this.original.getRequiredCapabilities()));
        int i = 0;
        while (i < this.fragments.length) {
            result.addAll(Arrays.asList(this.fragments[i].getRequiredCapabilities()));
            ++i;
        }
        return result.toArray(new IRequiredCapability[result.size()]);
    }

    public IRequiredCapability[] getMetaRequiredCapabilities() {
        ArrayList<IRequiredCapability> result = new ArrayList<IRequiredCapability>();
        result.addAll(Arrays.asList(this.original.getMetaRequiredCapabilities()));
        int i = 0;
        while (i < this.fragments.length) {
            result.addAll(Arrays.asList(this.fragments[i].getMetaRequiredCapabilities()));
            ++i;
        }
        return result.toArray(new IRequiredCapability[result.size()]);
    }

    public ITouchpointData[] getTouchpointData() {
        ArrayList<ITouchpointData> result = new ArrayList<ITouchpointData>();
        result.addAll(Arrays.asList(this.original.getTouchpointData()));
        int i = 0;
        while (i < this.fragments.length) {
            ITouchpointData[] data = this.fragments[i].getTouchpointData();
            int j = 0;
            while (j < data.length) {
                result.add(data[j]);
                ++j;
            }
            ++i;
        }
        return result.toArray(new ITouchpointData[result.size()]);
    }

    public ITouchpointType getTouchpointType() {
        return this.original.getTouchpointType();
    }

    public Version getVersion() {
        return this.original.getVersion();
    }

    public boolean isFragment() {
        return this.original.isFragment();
    }

    public boolean isSingleton() {
        return this.original.isSingleton();
    }

    public boolean equals(Object obj) {
        boolean result = this.original.equals(obj);
        if (result) {
            return true;
        }
        if (obj instanceof ResolvedInstallableUnit) {
            return this.original.equals(((ResolvedInstallableUnit)obj).original);
        }
        return false;
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public String toString() {
        return "[R]" + this.original.toString();
    }

    public IInstallableUnit getOriginal() {
        return this.original;
    }

    public int compareTo(Object toCompareTo) {
        if (!(toCompareTo instanceof IInstallableUnit)) {
            return -1;
        }
        IInstallableUnit other = (IInstallableUnit)toCompareTo;
        if (this.getId().compareTo(other.getId()) == 0) {
            return this.getVersion().compareTo((Object)other.getVersion());
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean isResolved() {
        return true;
    }

    public IInstallableUnit unresolved() {
        return this.original.unresolved();
    }

    public IUpdateDescriptor getUpdateDescriptor() {
        return this.original.getUpdateDescriptor();
    }

    public ILicense getLicense() {
        return this.original.getLicense();
    }

    public ICopyright getCopyright() {
        return this.original.getCopyright();
    }

    public boolean satisfies(IRequiredCapability candidate) {
        IProvidedCapability[] provides = this.getProvidedCapabilities();
        int i = 0;
        while (i < provides.length) {
            if (provides[i].satisfies(candidate)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

