/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.ITrueTypeWriter;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.TrueTypeFont;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.Util;
import org.eclipse.birt.report.engine.emitter.postscript.util.FileUtil;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.w3c.dom.css.CSSValue;

public class PostscriptWriter {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES = "Times";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    protected static final int DEFAULT_PAGE_HEIGHT = 792;
    protected static final int DEFAULT_PAGE_WIDTH = 612;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected PrintStream out = System.out;
    protected Color clr = Color.white;
    protected Font font = new Font(1, 12.0f, 0);
    protected static Logger log = Logger.getLogger(PostscriptWriter.class.getName());
    private int pageIndex = 1;
    private float pageHeight = 792.0f;
    private static Set<String> intrinsicFonts = new HashSet<String>();
    private int imageIndex = 0;
    private Map<String, String> cachedImageSource;
    private Map<File, ITrueTypeWriter> trueTypeFontWriters = new HashMap<File, ITrueTypeWriter>();

    static {
        intrinsicFonts.add(COURIER);
        intrinsicFonts.add(COURIER_BOLD);
        intrinsicFonts.add(COURIER_OBLIQUE);
        intrinsicFonts.add(COURIER_BOLDOBLIQUE);
        intrinsicFonts.add(HELVETICA);
        intrinsicFonts.add(HELVETICA_BOLD);
        intrinsicFonts.add(HELVETICA_OBLIQUE);
        intrinsicFonts.add(HELVETICA_BOLDOBLIQUE);
        intrinsicFonts.add(SYMBOL);
        intrinsicFonts.add(TIMES);
        intrinsicFonts.add(TIMES_ROMAN);
        intrinsicFonts.add(TIMES_BOLD);
        intrinsicFonts.add(TIMES_ITALIC);
        intrinsicFonts.add(TIMES_BOLDITALIC);
        intrinsicFonts.add(ZAPFDINGBATS);
    }

    public static boolean isIntrinsicFont(String fontName) {
        return intrinsicFonts.contains(fontName);
    }

    public PostscriptWriter(OutputStream o, String title) {
        this.out = new PrintStream(o);
        this.cachedImageSource = new HashMap<String, String>();
        this.emitProlog(title);
    }

    public void clipRect(float x, float y, float width, float height) {
        y = this.transformY(y);
        this.out.println(String.valueOf(x) + " " + y + " " + width + " " + height + " rcl");
    }

    public void clipSave() {
        this.out.println("gsave");
    }

    public void clipRestore() {
        this.out.println("grestore");
    }

    public void drawImage(String imageId, InputStream imageStream, float x, float y, float width, float height) throws Exception {
        BufferedImage image = ImageIO.read(imageStream);
        this.drawImage(imageId, image, x, y, width, height);
    }

    public void drawImage(String imageId, Image image, float x, float y, float width, float height) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException("null image.");
        }
        y = this.transformY(y);
        if (imageId == null) {
            this.outputUncachedImage(image, x, y, width, height);
        } else {
            this.outputCachedImage(imageId, image, x, y, width, height);
        }
    }

    private void outputCachedImage(String imageId, Image image, float x, float y, float width, float height) throws IOException {
        String imageName = this.getImageName(imageId, image);
        this.out.print(String.valueOf(imageName) + " ");
        this.out.print(String.valueOf(x) + " " + y + " ");
        this.out.println(String.valueOf(width) + " " + height + " drawimage");
    }

    private void outputUncachedImage(Image image, float x, float y, float width, float height) throws IOException {
        ArrayImageSource imageSource = this.getImageSource(image);
        this.out.print(String.valueOf(x) + " " + y + " ");
        this.out.print(String.valueOf(width) + " " + height + " ");
        this.out.print(String.valueOf(imageSource.getWidth()) + " " + imageSource.getHeight());
        this.out.println(" drawstreamimage");
        this.outputImageSource(imageSource);
        this.out.println("grestore");
    }

    private ArrayImageSource getImageSource(Image image) throws IOException {
        ImageIcon imageIcon = new ImageIcon(image);
        int w = imageIcon.getIconWidth();
        int h = imageIcon.getIconHeight();
        int[] pixels = new int[w * h];
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
            pg.grabPixels();
            if ((pg.getStatus() & 0x80) != 0) {
                throw new IOException("failed to load image contents");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("image load interrupted");
        }
        ArrayImageSource imageSource = new ArrayImageSource(w, h, pixels);
        return imageSource;
    }

    private String getImageName(String imageId, Image image) throws IOException {
        String name = this.cachedImageSource.get(imageId);
        if (name == null) {
            name = "image" + this.imageIndex++;
            this.cachedImageSource.put(imageId, name);
            ArrayImageSource imageSource = this.getImageSource(image);
            this.outputNamedImageSource(name, imageSource);
        }
        return name;
    }

    private void outputNamedImageSource(String name, ArrayImageSource imageSource) {
        this.out.println("startDefImage");
        this.outputImageSource(imageSource);
        this.out.println("/" + name + " " + imageSource.getWidth() + " " + imageSource.getHeight() + " endDefImage");
    }

    private void outputImageSource(ArrayImageSource imageSource) {
        int originalWidth = imageSource.getWidth();
        int originalHeight = imageSource.getHeight();
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DeflaterOutputStream deflateOut = new DeflaterOutputStream((OutputStream)byteOut, new Deflater(-1));
            int i = 0;
            while (i < originalHeight) {
                int j = 0;
                while (j < originalWidth) {
                    int pixel = imageSource.getRGB(j, i);
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    deflateOut.write(this.transferColor(alpha, red));
                    deflateOut.write(this.transferColor(alpha, green));
                    deflateOut.write(this.transferColor(alpha, blue));
                    ++j;
                }
                ++i;
            }
            deflateOut.finish();
            deflateOut.close();
            byte[] byteArray = byteOut.toByteArray();
            byteOut.close();
            this.out.print(String.valueOf(Util.toHexString(byteArray)) + ">");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int transferColor(int alpha, int color) {
        return 255 - (255 - color) * alpha / 255;
    }

    protected void drawRect(float x, float y, float width, float height) {
        this.drawRawRect(x, y, width, height);
        this.out.println("fill");
    }

    private void drawRawRect(float x, float y, float width, float height) {
        y = this.transformY(y);
        this.out.println(String.valueOf(x) + " " + y + " " + width + " " + height + " rect");
    }

    public void drawBackgroundImage(String imageURI, float x, float y, float width, float height, float imageWidth, float imageHeight, float positionX, float positionY, int repeat) throws IOException {
        if (imageURI == null || imageURI.length() == 0) {
            return;
        }
        org.eclipse.birt.report.engine.layout.emitter.Image image = EmitterUtil.parseImage(null, (int)3, (String)imageURI, null, null);
        byte[] imageData = image.getData();
        if (imageWidth == 0.0f || imageHeight == 0.0f) {
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
        }
        Position imageSize = new Position(imageWidth, imageHeight);
        Position areaPosition = new Position(x, y);
        Position areaSize = new Position(width, height);
        Position imagePosition = new Position(x + positionX, y + positionY);
        BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
        List positions = layout.getImagePositions(repeat);
        this.gSave();
        this.setColor(Color.WHITE);
        this.out.println("newpath");
        this.drawRawRect(x, y, width, height);
        this.out.println("closepath clip");
        for (Position position : positions) {
            try {
                this.drawImage(imageURI, new ByteArrayInputStream(imageData), position.getX(), position.getY(), imageSize.getX(), imageSize.getY());
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        this.gRestore();
    }

    public void drawLine(float startX, float startY, float endX, float endY, float width, Color color, int lineStyle) {
        if (color == null || 0.0f == width || lineStyle == 28) {
            return;
        }
        if (lineStyle == 23) {
            return;
        }
        int dashMode = 0;
        if (lineStyle == 22) {
            dashMode = 1;
        } else if (lineStyle == 20) {
            dashMode = 2;
        }
        startY = this.transformY(startY);
        endY = this.transformY(endY);
        this.outputColor(color);
        this.out.print(String.valueOf(width) + " " + dashMode + " ");
        this.out.print(String.valueOf(startX) + " " + startY + " ");
        this.out.print(String.valueOf(endX) + " " + endY + " ");
        this.out.println("drawline");
    }

    private void gRestore() {
        this.out.println("grestore");
    }

    private void gSave() {
        this.out.println("gsave");
    }

    public void drawString(String str, float x, float y, FontInfo fontInfo, float letterSpacing, float wordSpacing, Color color, boolean linethrough, boolean overline, boolean underline, CSSValue align) {
        y = this.transformY(y);
        String text = str;
        String drawCommand = "drawstring";
        boolean needSimulateItalic = false;
        if (fontInfo != null) {
            float fontSize = fontInfo.getFontSize();
            int fontStyle = fontInfo.getFontStyle();
            if (fontInfo.getSimulation()) {
                if (fontStyle == 1 || fontStyle == 3) {
                    float offset = (float)((double)fontSize * Math.log10(fontSize) / 100.0);
                    drawCommand = String.valueOf(offset) + " drawBoldString";
                }
                if (fontStyle == 2 || fontStyle == 3) {
                    needSimulateItalic = true;
                }
            }
            BaseFont baseFont = fontInfo.getBaseFont();
            String fontName = baseFont.getPostscriptFontName();
            text = this.applyFont(fontName, fontStyle, fontSize, text);
        }
        color = color == null ? Color.black : color;
        this.outputColor(color);
        this.out.print(String.valueOf(x) + " " + y + " ");
        this.out.print(String.valueOf(wordSpacing) + " " + letterSpacing + " ");
        this.out.println(String.valueOf(text) + " " + needSimulateItalic + " " + drawCommand);
    }

    protected void emitProlog(String title) {
        this.out.println("%!PS-Adobe-3.0");
        if (title != null) {
            this.out.println("%%Title: " + title);
        }
        this.out.println("% (C)2006 Actuate Inc.");
    }

    public void fillRect(float x, float y, float width, float height, Color color) {
        this.gSave();
        this.setColor(color);
        this.drawRect(x, y, width, height);
        this.gRestore();
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        this.out.println("%dispose");
    }

    public Color getColor() {
        return this.clr;
    }

    public Font getFont() {
        return this.font;
    }

    public void setColor(Color c) {
        this.outputColor(c);
        this.out.println(" setrgbcolor");
    }

    private void outputColor(Color c) {
        if (c == null) {
            return;
        }
        this.out.print((double)c.getRed() / 255.0);
        this.out.print(" ");
        this.out.print((double)c.getGreen() / 255.0);
        this.out.print(" ");
        this.out.print((double)c.getBlue() / 255.0);
        this.out.print(" ");
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
            String javaName = this.font.getFamilyname();
            int javaStyle = this.font.style();
            this.setFont(javaName, javaStyle);
        }
    }

    private void setFont(String psName, float size) {
        this.out.println("/" + psName + " " + size + " usefont");
    }

    private String applyFont(String fontName, int fontStyle, float fontSize, String text) {
        if (PostscriptWriter.isIntrinsicFont(fontName)) {
            return this.applyIntrinsicFont(fontName, fontStyle, fontSize, text);
        }
        try {
            String fontPath = this.getFontPath(fontName);
            if (fontPath == null) {
                return this.applyIntrinsicFont(fontName, fontStyle, fontSize, text);
            }
            ITrueTypeWriter trueTypeWriter = this.getTrueTypeFontWriter(fontPath);
            String displayName = fontName.replace(' ', '_');
            trueTypeWriter.useDisplayName(displayName);
            trueTypeWriter.ensureGlyphsAvailable(text);
            this.setFont(displayName, fontSize);
            return trueTypeWriter.toHexString(text);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "apply font: " + fontName);
            return null;
        }
    }

    private String applyIntrinsicFont(String fontName, int fontStyle, float fontSize, String text) {
        this.setFont(fontName, fontSize);
        text = PostscriptWriter.escapeSpecialCharacter(text);
        return "(" + text + ")";
    }

    private static String escapeSpecialCharacter(String source) {
        Pattern pattern = Pattern.compile("(\\\\|\\)|\\()");
        Matcher matcher = pattern.matcher(source);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "\\\\\\" + matcher.group(1));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private ITrueTypeWriter getTrueTypeFontWriter(String fontPath) throws DocumentException, IOException {
        File file = new File(fontPath);
        ITrueTypeWriter trueTypeWriter = this.trueTypeFontWriters.get(file);
        if (trueTypeWriter != null) {
            return trueTypeWriter;
        }
        TrueTypeFont ttFont = TrueTypeFont.getInstance(fontPath);
        trueTypeWriter = ttFont.getTrueTypeWriter(this.out);
        trueTypeWriter.initialize();
        this.trueTypeFontWriters.put(file, trueTypeWriter);
        return trueTypeWriter;
    }

    private String getFontPath(String fontName) {
        try {
            FontFactoryImp fontImpl = FontFactory.getFontImp();
            Properties trueTypeFonts = (Properties)this.getField(FontFactoryImp.class, "trueTypeFonts", fontImpl);
            String fontPath = trueTypeFonts.getProperty(fontName.toLowerCase());
            return fontPath;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "font path: " + fontName);
            return null;
        }
    }

    private Object getField(final Class fontFactoryClass, final String fieldName, final Object instaces) throws NoSuchFieldException, IllegalAccessException {
        try {
            Object field = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
                    Field fldTrueTypeFonts = fontFactoryClass.getDeclaredField(fieldName);
                    fldTrueTypeFonts.setAccessible(true);
                    return fldTrueTypeFonts.get(instaces);
                }
            });
            return field;
        }
        catch (PrivilegedActionException e) {
            Exception typedException = e.getException();
            if (typedException instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)typedException;
            }
            if (typedException instanceof IllegalAccessException) {
                throw (IllegalAccessException)typedException;
            }
            if (typedException instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)typedException;
            }
            return null;
        }
    }

    protected float transformY(float y) {
        return this.pageHeight - y;
    }

    public void translate(int x, int y) {
        this.out.print(x);
        this.out.print(" ");
        this.out.print(y);
        this.out.println(" translate");
    }

    public void startRenderer() throws IOException {
        this.startRenderer(null, null);
    }

    public void startRenderer(String author, String description) throws IOException {
        this.out.println("%%Creator: " + author);
        FileUtil.load("org/eclipse/birt/report/engine/emitter/postscript/header.ps", this.out);
    }

    public void fillPage(Color color) {
        if (color == null) {
            return;
        }
        this.gSave();
        this.setColor(color);
        this.out.println("clippath fill");
        this.gRestore();
    }

    public void startPage(float pageWidth, float pageHeight) {
        this.pageHeight = pageHeight;
        this.out.println("%%Page: " + this.pageIndex + " " + this.pageIndex);
        this.out.println("%%PageBoundingBox: 0 0 " + Math.round(pageWidth) + " " + Math.round(pageHeight));
        this.out.println("%%BeginPage");
        ++this.pageIndex;
    }

    public void endPage() {
        this.out.println("showpage");
        this.out.println("%%PageTrailer");
        this.out.println("%%EndPage");
    }

    public void stopRenderer() throws IOException {
        this.out.println("%%Trailer");
        this.out.println("%%Pages: " + (this.pageIndex - 1));
        this.out.println("%%EOF");
        this.out.flush();
    }

    public void close() throws IOException {
        this.stopRenderer();
        this.out.close();
    }

    public class ArrayImageSource
    extends ImageSource {
        private int[] imageSource;

        public ArrayImageSource(int width, int height, int[] imageSource) {
            super(width, height);
            this.imageSource = imageSource;
        }

        public int getRGB(int x, int y) {
            return this.imageSource[y * this.width + x];
        }

        public int[] getData() {
            return this.imageSource;
        }
    }

    public abstract class ImageSource {
        protected int height;
        protected int width;

        public ImageSource(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public abstract int getRGB(int var1, int var2);
    }
}

