/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.model;

import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;

public class FilterConfig {
    private Type type;
    private boolean isShowSystemTable;
    private String schemaName;
    private String namePattern;
    private int maxSchemaCount;
    private int maxTableCountPerSchema;

    public FilterConfig(String schemaName, Type type, String namePattern, boolean isShowSystemTable, int maxSchemaCount, int maxTableCountPerSchema) {
        assert (type != null && maxSchemaCount > 0 && maxTableCountPerSchema > 0);
        this.schemaName = schemaName;
        this.type = type;
        this.isShowSystemTable = isShowSystemTable;
        this.namePattern = FilterConfig.generatePattern(namePattern);
        this.maxSchemaCount = maxSchemaCount;
        this.maxTableCountPerSchema = maxTableCountPerSchema;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isShowSystemTable() {
        return this.isShowSystemTable;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getMaxSchemaCount() {
        return this.maxSchemaCount;
    }

    public int getMaxTableCountPerSchema() {
        return this.maxTableCountPerSchema;
    }

    public String[] getTableTypesForJDBC() {
        switch (this.type) {
            case PROCEDURE: {
                return null;
            }
            case TABLE: {
                if (this.isShowSystemTable()) {
                    return new String[]{"TABLE", "SYSTEM TABLE"};
                }
                return new String[]{"TABLE"};
            }
            case VIEW: {
                return new String[]{"VIEW"};
            }
            case ALL: {
                if (this.isShowSystemTable()) {
                    return new String[]{"TABLE", "VIEW", "SYSTEM TABLE"};
                }
                return new String[]{"TABLE", "VIEW"};
            }
        }
        assert (false);
        return null;
    }

    private static String generatePattern(String input) {
        if (input != null) {
            if (input.lastIndexOf(37) == -1) {
                input = String.valueOf(input) + "%";
            }
        } else {
            input = "%";
        }
        return input;
    }

    public static String getTypeDisplayText(Type type) {
        assert (type != null);
        switch (type) {
            case PROCEDURE: {
                return JdbcPlugin.getResourceString("tablepage.text.procedure");
            }
            case TABLE: {
                return JdbcPlugin.getResourceString("tablepage.text.tabletype");
            }
            case VIEW: {
                return JdbcPlugin.getResourceString("tablepage.text.viewtype");
            }
            case ALL: {
                return JdbcPlugin.getResourceString("tablepage.text.All");
            }
        }
        assert (false);
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ALL,
        TABLE,
        VIEW,
        PROCEDURE;

    }
}

