/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.model;

import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.model.IDBNode;
import org.eclipse.birt.report.data.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnNode
implements IDBNode,
Comparable<TableColumnNode> {
    private static String COLUMN_ICON = String.valueOf(TableColumnNode.class.getName()) + ".ColumnIcon";
    private String schemaName;
    private String tableName;
    private String columnName;
    private String typeName;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(COLUMN_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/column.gif"));
    }

    public TableColumnNode(String schemaName, String tableName, String columnName, String typeName) {
        assert (columnName != null && tableName != null);
        this.columnName = columnName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.typeName = typeName;
    }

    @Override
    public String getDisplayName() {
        return String.valueOf(this.columnName) + " (" + this.typeName + ")";
    }

    @Override
    public Image getImage() {
        return JFaceResources.getImage((String)COLUMN_ICON);
    }

    @Override
    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString, boolean includeSchema) {
        StringBuffer sb = new StringBuffer();
        String quoteFlag = "";
        if (useIdentifierQuoteString) {
            quoteFlag = JdbcMetaDataProvider.getInstance().getIdentifierQuoteString();
        }
        if (includeSchema && this.schemaName != null) {
            sb.append(Utility.quoteString(this.schemaName, quoteFlag)).append(".");
        }
        sb.append(Utility.quoteString(this.tableName, quoteFlag)).append(".");
        sb.append(Utility.quoteString(this.columnName, quoteFlag));
        return sb.toString();
    }

    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString) {
        StringBuffer sb = new StringBuffer();
        String quoteFlag = "";
        if (useIdentifierQuoteString) {
            quoteFlag = JdbcMetaDataProvider.getInstance().getIdentifierQuoteString();
        }
        if (this.schemaName != null) {
            sb.append(Utility.quoteString(this.schemaName, quoteFlag)).append(".");
        }
        sb.append(Utility.quoteString(this.tableName, quoteFlag)).append(".");
        sb.append(Utility.quoteString(this.columnName, quoteFlag));
        return sb.toString();
    }

    @Override
    public int compareTo(TableColumnNode o) {
        return this.columnName.compareTo(o.columnName);
    }
}

