/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.preference.IPreferenceChangeListener;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.core.preference.PreferenceChangeEvent;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ScriptObjectNode;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.ReportMediator;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.LibraryProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.ReportMultiBookPage;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.IResourceEditPart;
import org.eclipse.birt.report.designer.internal.ui.extension.EditorContributorManager;
import org.eclipse.birt.report.designer.internal.ui.extension.FormPageDef;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ILibraryProvider;
import org.eclipse.birt.report.designer.internal.ui.views.LibrarySaveChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewTreeViewerPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeListener;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributeViewPage;
import org.eclipse.birt.report.designer.ui.widget.ITreeViewerBackup;
import org.eclipse.birt.report.designer.ui.widget.TreeViewerBackup;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.IVersionInfo;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MultiPageReportEditor
extends AbstractMultiPageEditor
implements IPartListener,
IReportEditor,
IColleague,
IReportResourceChangeListener {
    public static final String LayoutMasterPage_ID = "org.eclipse.birt.report.designer.ui.editors.masterpage";
    public static final String LayoutEditor_ID = "org.eclipse.birt.report.designer.ui.editors.layout";
    public static final String XMLSourcePage_ID = "org.eclipse.birt.report.designer.ui.editors.xmlsource";
    public static final String ScriptForm_ID = "org.eclipse.birt.report.designer.ui.editors.script";
    public static int PROP_SAVE = 1000;
    private ReportMultiBookPage fPalettePage;
    private ReportMultiBookPage outlinePage;
    private ReportMultiBookPage dataPage;
    private boolean fIsHandlingActivation;
    private long fModificationStamp = -1L;
    protected IReportProvider reportProvider;
    private FormEditorSelectionProvider provider = new FormEditorSelectionProvider((FormEditor)this);
    private boolean isChanging = false;
    private ReportMultiBookPage attributePage;
    private ITreeViewerBackup outlineBackup;
    private ITreeViewerBackup dataBackup;
    private boolean needReload = false;
    private boolean needReset = false;
    private IWorkbenchPart fActivePart;
    private boolean isClose = false;
    private IPreferences prefs;
    IPreferenceChangeListener preferenceChangeListener = new IPreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent event) {
            if (event.getKey().equals("special to default") || "org.eclipse.birt.report.designer.ui.preferences.resourcestore".equals(event.getKey())) {
                SessionHandleAdapter.getInstance().getSessionHandle();
                SessionHandle.setBirtResourcePath((String)ReportPlugin.getDefault().getResourcePreference());
                UIUtil.processSessionResourceFolder((IEditorInput)MultiPageReportEditor.this.getEditorInput(), (IProject)UIUtil.getProjectFromInput((IEditorInput)MultiPageReportEditor.this.getEditorInput()), (ModuleHandle)MultiPageReportEditor.this.getModel());
                MultiPageReportEditor.this.refreshGraphicalEditor();
            }
        }
    };
    private IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
            if (window != MultiPageReportEditor.this.getEditorSite().getWorkbenchWindow()) {
                return;
            }
            if (MultiPageReportEditor.this.fActivePart != MultiPageReportEditor.this) {
                return;
            }
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MultiPageReportEditor.this.confirmSava();
                }
            });
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    };

    private void confirmSava() {
        if (this.fIsHandlingActivation) {
            return;
        }
        if (!this.isExistModelFile() && !this.isClose) {
            this.fIsHandlingActivation = true;
            MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"MultiPageReportEditor.ConfirmTitle"), null, Messages.getString((String)"MultiPageReportEditor.SaveConfirmMessage"), 3, new String[]{Messages.getString((String)"MultiPageReportEditor.SaveButton"), Messages.getString((String)"MultiPageReportEditor.CloseButton")}, 0);
            try {
                if (dialog.open() == 0) {
                    this.doSave(null);
                    this.isClose = false;
                } else {
                    Display display = this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            MultiPageReportEditor.this.closeEditor(false);
                        }
                    });
                    this.isClose = true;
                }
            }
            finally {
                this.fIsHandlingActivation = false;
                this.needReset = false;
                this.needReload = false;
            }
        }
    }

    public MultiPageReportEditor() {
        this.outlineBackup = new TreeViewerBackup();
        this.dataBackup = new TreeViewerBackup();
        IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
        if (synchronizer != null) {
            synchronizer.addListener(6, (IReportResourceChangeListener)this);
        }
        PlatformUI.getWorkbench().addWindowListener(this.windowListener);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.setSelectionProvider((ISelectionProvider)this.provider);
        IReportProvider provider = this.getProvider();
        if (provider != null && provider.getInputPath(input) != null) {
            this.setPartName(provider.getInputPath(input).lastSegment());
            this.firePropertyChange(260);
        } else {
            this.setPartName(input.getName());
            this.firePropertyChange(260);
        }
        ReportMediator.addGlobalColleague((IColleague)this);
        IProject project = UIUtil.getProjectFromInput((IEditorInput)input);
        this.prefs = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportPlugin.getDefault(), project);
        this.prefs.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    protected IReportProvider getProvider() {
        if (this.reportProvider == null) {
            this.reportProvider = new FileReportProvider();
        }
        return this.reportProvider;
    }

    protected void addPages() {
        List formPageList = EditorContributorManager.getInstance().getEditorContributor((String)this.getEditorSite().getId()).formPageList;
        boolean error = false;
        String fileName = this.getProvider().getInputPath(this.getEditorInput()).toOSString();
        List message = ModuleUtil.checkVersion((String)fileName);
        if (message.size() > 0) {
            IVersionInfo info = (IVersionInfo)message.get(0);
            if (!MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.CheckVersion.Dialog.Title"), (String)info.getLocalizedMessage())) {
                for (FormPageDef pagedef : formPageList) {
                    if (!XMLSourcePage_ID.equals(pagedef.id)) continue;
                    try {
                        this.addPage(pagedef.createPage(), pagedef.displayName);
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }
        for (FormPageDef pagedef : formPageList) {
            try {
                this.addPage(pagedef.createPage(), pagedef.displayName);
            }
            catch (Exception exception) {
                error = true;
            }
        }
        if (error) {
            this.setActivePage(XMLSourcePage_ID);
        }
    }

    public int addPage(IReportEditorPage page, String title) throws PartInitException {
        int index = super.addPage((IFormPage)page);
        if (title != null) {
            this.setPageText(index, title);
        }
        try {
            page.initialize((FormEditor)this);
            page.init(this.createSite((IEditorPart)page), this.getEditorInput());
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage());
        }
        return index;
    }

    public void removePage(String id) {
        IFormPage page = this.findPage(id);
        if (page != null) {
            this.removePage(page.getIndex());
        }
    }

    public void removeAllPages() {
        int i = this.pages.toArray().length - 1;
        while (i >= 0) {
            if (this.pages.get(i) != null) {
                this.removePage(((IFormPage)this.pages.get(i)).getId());
            }
            --i;
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (ModuleUtil.compareReportVersion((String)ModuleUtil.getReportVersion(), (String)this.getModel().getVersion()) > 0 && !MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Message"))) {
            return;
        }
        this.getCurrentPageInstance().doSave(monitor);
        this.fireDesignFileChangeEvent();
    }

    private void fireDesignFileChangeEvent() {
        UIUtil.doFinishSava((ModuleHandle)this.getModel());
    }

    public void doSaveAs() {
        this.getActivePageInstance().doSaveAs();
        this.setInput(this.getActivePageInstance().getEditorInput());
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            this.setPartName(provider.getInputPath(this.getEditorInput()).lastSegment());
            this.firePropertyChange(260);
            this.getProvider().getReportModuleHandle(this.getEditorInput()).setFileName(this.getProvider().getInputPath(this.getEditorInput()).toOSString());
        }
        this.updateRelatedViews();
        this.fireDesignFileChangeEvent();
    }

    public boolean isSaveAsAllowed() {
        return this.getActivePageInstance().isSaveAsAllowed();
    }

    public Object getAdapter(Class type) {
        if (type == IReportProvider.class) {
            if (this.reportProvider == null) {
                this.reportProvider = new FileReportProvider();
            }
            return this.reportProvider;
        }
        if (type == ILibraryProvider.class) {
            return new LibraryProvider();
        }
        if (type == PalettePage.class) {
            Object adapter = this.getPalettePage();
            this.updatePaletteView(this.getActivePageInstance());
            return adapter;
        }
        if (type == IContentOutlinePage.class) {
            Object adapter = this.getOutlinePage();
            this.updateOutLineView(this.getActivePageInstance());
            return adapter;
        }
        if (type == DataViewPage.class) {
            Object adapter = this.getDataPage();
            this.updateDateView(this.getActivePageInstance());
            return adapter;
        }
        if (type == AttributeViewPage.class) {
            Object adapter = this.getAttributePage();
            this.updateAttributeView(this.getActivePageInstance());
            return adapter;
        }
        if (this.getActivePageInstance() != null) {
            return this.getActivePageInstance().getAdapter(type);
        }
        return super.getAdapter(type);
    }

    private void updateAttributeView(IFormPage activePageInstance) {
        if (this.attributePage == null) {
            return;
        }
        Object adapter = activePageInstance.getAdapter(AttributeViewPage.class);
        this.attributePage.setActivePage((IPageBookViewPage)adapter);
    }

    private void updateDateView(IFormPage activePageInstance) {
        if (this.dataPage == null) {
            return;
        }
        Object adapter = activePageInstance.getAdapter(DataViewPage.class);
        if (adapter instanceof DataViewTreeViewerPage) {
            ((DataViewTreeViewerPage)adapter).setBackupState(this.dataBackup);
        }
        this.dataPage.setActivePage((IPageBookViewPage)adapter);
    }

    private void updateOutLineView(IFormPage activePageInstance) {
        if (this.outlinePage == null) {
            return;
        }
        if (this.reloadOutlinePage()) {
            return;
        }
        Object designOutLinePage = activePageInstance.getAdapter(IContentOutlinePage.class);
        if (designOutLinePage instanceof DesignerOutlinePage) {
            ((DesignerOutlinePage)designOutLinePage).setBackupState(this.outlineBackup);
        }
        this.outlinePage.setActivePage((IPageBookViewPage)designOutLinePage);
    }

    public void outlineSwitch() {
        if (!this.getActivePageInstance().getId().equals(XMLSourcePage_ID) || this.outlinePage == null) {
            return;
        }
        if (this.outlinePage.getCurrentPage() instanceof DesignerOutlinePage) {
            this.outlinePage.setActivePage((IPageBookViewPage)this.getActivePageInstance().getAdapter(ContentOutlinePage.class));
        } else {
            this.outlinePage.setActivePage((IPageBookViewPage)this.getActivePageInstance().getAdapter(IContentOutlinePage.class));
        }
        this.outlinePage.getSite().getActionBars().updateActionBars();
    }

    public boolean reloadOutlinePage() {
        if (!this.getActivePageInstance().getId().equals(XMLSourcePage_ID) || this.outlinePage == null || !this.getCurrentPageInstance().getId().equals(XMLSourcePage_ID)) {
            return false;
        }
        if (this.outlinePage.getCurrentPage() instanceof DesignerOutlinePage || this.outlinePage.getCurrentPage() == null) {
            this.outlinePage.setActivePage((IPageBookViewPage)this.getActivePageInstance().getAdapter(IContentOutlinePage.class));
        } else {
            this.outlinePage.setActivePage((IPageBookViewPage)this.getActivePageInstance().getAdapter(ContentOutlinePage.class));
        }
        if (this.outlinePage.getSite() != null) {
            this.outlinePage.getSite().getActionBars().updateActionBars();
        }
        return true;
    }

    private Object getDataPage() {
        if (this.dataPage == null || this.dataPage.isDisposed()) {
            this.dataPage = new ReportMultiBookPage();
        }
        return this.dataPage;
    }

    private Object getAttributePage() {
        if (this.attributePage == null || this.attributePage.isDisposed()) {
            this.attributePage = new ReportMultiBookPage();
        }
        return this.attributePage;
    }

    public Object getOutlinePage() {
        if (this.outlinePage == null || this.outlinePage.isDisposed()) {
            this.outlinePage = new ReportMultiBookPage();
        }
        return this.outlinePage;
    }

    private Object getPalettePage() {
        if (this.fPalettePage == null || this.fPalettePage.isDisposed()) {
            this.fPalettePage = new ReportMultiBookPage();
        }
        return this.fPalettePage;
    }

    private void updatePaletteView(IFormPage activePageInstance) {
        if (this.fPalettePage == null) {
            return;
        }
        Object palette = activePageInstance.getAdapter(PalettePage.class);
        this.fPalettePage.setActivePage((IPageBookViewPage)palette);
    }

    public void pageChange(String id) {
        IFormPage page = this.findPage(id);
        if (page != null) {
            this.pageChange(page.getIndex());
        }
    }

    protected void pageChange(int newPageIndex) {
        int oldPageIndex = this.getCurrentPage();
        if (oldPageIndex == newPageIndex) {
            this.isChanging = false;
            this.bingdingKey(oldPageIndex);
            return;
        }
        if (oldPageIndex != -1) {
            Object oldPage = this.pages.get(oldPageIndex);
            Object newPage = this.pages.get(newPageIndex);
            if (oldPage instanceof IFormPage && !((IFormPage)oldPage).canLeaveThePage()) {
                this.setActivePage(oldPageIndex);
                return;
            }
            this.isChanging = true;
            super.pageChange(newPageIndex);
            if (!this.prePageChanges(oldPage, newPage)) {
                super.setActivePage(oldPageIndex);
                this.updateRelatedViews();
                return;
            }
            if (this.isChanging) {
                this.bingdingKey(newPageIndex);
            }
            this.isChanging = false;
        } else {
            super.pageChange(newPageIndex);
        }
        this.updateRelatedViews();
    }

    public void setFocus() {
        super.setFocus();
        if (this.pages == null || this.getCurrentPage() < 0 || this.getCurrentPage() > this.pages.size() - 1) {
            return;
        }
        this.bingdingKey(this.getCurrentPage());
    }

    private void bingdingKey(int newPageIndex) {
        IKeyBindingService service = this.getSite().getKeyBindingService();
        IEditorPart editor = (IEditorPart)this.pages.get(newPageIndex);
        if (editor != null && editor.getEditorSite() != null) {
            editor.setFocus();
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                if (editor != null) {
                    nestableService.activateKeyBindingService((IWorkbenchSite)editor.getEditorSite());
                } else {
                    nestableService.activateKeyBindingService(null);
                }
            }
        }
    }

    protected void updateRelatedViews() {
        this.updatePaletteView(this.getCurrentPageInstance());
        this.updateOutLineView(this.getCurrentPageInstance());
        this.updateDateView(this.getCurrentPageInstance());
    }

    protected boolean prePageChanges(Object oldPage, Object newPage) {
        boolean isNewPageValid = true;
        if (oldPage instanceof IReportEditorPage && newPage instanceof IReportEditorPage) {
            isNewPageValid = ((IReportEditorPage)newPage).onBroughtToTop((IReportEditorPage)oldPage);
        }
        return isNewPageValid;
    }

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        this.markPageStale();
    }

    private void markPageStale() {
        IFormPage currentPage = this.getActivePageInstance();
        if (!(currentPage instanceof IReportEditorPage)) {
            return;
        }
    }

    public ModuleHandle getModel() {
        if (this.reportProvider != null) {
            return this.reportProvider.getReportModuleHandle(this.getEditorInput());
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        this.fActivePart = part;
        if (part != this) {
            PageBookView view;
            if (part instanceof PageBookView && (view = (PageBookView)part).getCurrentPage() instanceof DesignerOutlinePage) {
                ISelectionProvider provider = (ISelectionProvider)view.getCurrentPage();
                ReportRequest request = new ReportRequest((Object)view.getCurrentPage());
                List list = new ArrayList();
                if (provider.getSelection() instanceof IStructuredSelection) {
                    list = ((IStructuredSelection)provider.getSelection()).toList();
                }
                request.setSelectionObject(list);
                request.setType((Object)"selection");
                SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
                SessionHandleAdapter.getInstance().getMediator().pushState();
            }
            if (this.getActivePageInstance() instanceof GraphicalEditorWithFlyoutPalette && ((GraphicalEditorWithFlyoutPalette)this.getActivePageInstance()).getGraphicalViewer().getEditDomain().getPaletteViewer() != null) {
                GraphicalEditorWithFlyoutPalette editor = (GraphicalEditorWithFlyoutPalette)this.getActivePageInstance();
                GraphicalViewer view2 = editor.getGraphicalViewer();
                view2.getEditDomain().loadDefaultTool();
            }
            return;
        }
        if (part == this) {
            this.confirmSava();
            final ModuleHandle oldHandle = this.getModel();
            if (this.needReset) {
                if (MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.ResetMessage"))) {
                    this.getProvider().getReportModuleHandle(this.getEditorInput(), true);
                } else {
                    this.needReset = false;
                }
                this.needReload = false;
            }
            if (this.needReload) {
                if (MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.Title"), (String)Messages.getString((String)"MultiPageReportEditor.ConfirmVersion.Dialog.ReloadMessage"))) {
                    UIUtil.reloadModuleHandleLibraries((ModuleHandle)this.getModel());
                } else {
                    this.needReload = false;
                }
            }
            if (this.getEditorInput().exists()) {
                this.handleActivation();
                SessionHandleAdapter.getInstance().setReportDesignHandle(this.getModel());
                String str = SessionHandleAdapter.getInstance().getSessionHandle().getResourceFolder();
                UIUtil.processSessionResourceFolder((IEditorInput)this.getEditorInput(), (IProject)UIUtil.getProjectFromInput((IEditorInput)this.getEditorInput()), (ModuleHandle)this.getModel());
                if (!str.equals(SessionHandleAdapter.getInstance().getSessionHandle().getResourceFolder()) && this.getActivePageInstance() instanceof GraphicalEditorWithFlyoutPalette) {
                    ((GraphicalEditorWithFlyoutPalette)this.getActivePageInstance()).getGraphicalViewer().getRootEditPart();
                    this.refreshGraphicalEditor();
                }
            }
            if (this.getActivePageInstance() instanceof IReportEditorPage) {
                boolean isDispatch = false;
                if (this.getActivePageInstance() instanceof GraphicalEditorWithFlyoutPalette) {
                    isDispatch = true;
                } else if (this.needReload || this.needReset) {
                    isDispatch = true;
                }
                final boolean tempDispatch = isDispatch;
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (!tempDispatch) {
                            return;
                        }
                        IReportEditorPage curPage = (IReportEditorPage)MultiPageReportEditor.this.getActivePageInstance();
                        if (MultiPageReportEditor.this.needReload || MultiPageReportEditor.this.needReset) {
                            curPage.markPageStale(4);
                        }
                        if (MultiPageReportEditor.this.getActivePageInstance() != null) {
                            curPage.onBroughtToTop((IReportEditorPage)MultiPageReportEditor.this.getActivePageInstance());
                        }
                        if (MultiPageReportEditor.this.needReload || MultiPageReportEditor.this.needReset) {
                            MultiPageReportEditor.this.updateRelatedViews();
                            curPage.markPageStale(0);
                        }
                        if (MultiPageReportEditor.this.needReset) {
                            SessionHandleAdapter.getInstance().resetReportDesign((Object)oldHandle, (Object)MultiPageReportEditor.this.getModel());
                            oldHandle.close();
                        }
                        MultiPageReportEditor.this.needReload = false;
                        MultiPageReportEditor.this.needReset = false;
                    }
                });
            }
        }
    }

    private void refreshResourceEditPart(EditPart parent) {
        if (parent instanceof IResourceEditPart) {
            ((IResourceEditPart)parent).refreshResource();
        }
        List list = parent.getChildren();
        int i = 0;
        while (i < list.size()) {
            EditPart part = (EditPart)list.get(i);
            this.refreshResourceEditPart(part);
            ++i;
        }
    }

    private boolean isExistModelFile() {
        if (this.getModel() == null) {
            return true;
        }
        File file = new File(this.getModel().getFileName());
        return file.exists() && file.isFile();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this && this.getModel() != null) {
            SessionHandleAdapter.getInstance().clear(this.getModel());
            if (this.getModel() != null) {
                GlobalActionFactory.removeStackActions((CommandStack)this.getModel().getCommandStack());
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.fActivePart = null;
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void handleActivation() {
    }

    protected void sanityCheckState(IEditorInput input) {
        long stamp;
        if (this.fModificationStamp == -1L) {
            this.fModificationStamp = this.getModificationStamp(input);
        }
        if ((stamp = this.getModificationStamp(input)) != this.fModificationStamp) {
            this.fModificationStamp = stamp;
            this.handleEditorInputChanged();
        }
    }

    protected void handleEditorInputChanged() {
        IEditorInput input;
        String title = Messages.getString((String)"ReportEditor.error.activated.outofsync.title");
        String msg = Messages.getString((String)"ReportEditor.error.activated.outofsync.message");
        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)title, (String)msg) && (input = this.getEditorInput()) == null) {
            this.closeEditor(this.isSaveOnCloseNeeded());
        }
    }

    public void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    protected long getModificationStamp(Object element) {
        IReportProvider provider;
        if (element instanceof IEditorInput && (provider = this.getProvider()) != null) {
            return this.computeModificationStamp(provider.getInputPath((IEditorInput)element));
        }
        return 0L;
    }

    protected long computeModificationStamp(IPath path) {
        return path.toFile().lastModified();
    }

    public void dispose() {
        IReportResourceSynchronizer synchronizer;
        this.outlineBackup.dispose();
        this.dataBackup.dispose();
        ArrayList list = new ArrayList(this.pages);
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof IReportEditorPage) {
                ((IReportEditorPage)obj).dispose();
                this.pages.remove(obj);
            }
            ++i;
        }
        if (this.fPalettePage != null) {
            this.fPalettePage.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
        }
        if (this.dataPage != null) {
            this.dataPage.dispose();
        }
        this.getSite().setSelectionProvider(null);
        ReportMediator.removeGlobalColleague((IColleague)this);
        if (this.getModel() != null) {
            this.getModel().close();
        }
        if ((synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService()) != null) {
            synchronizer.removeListener(6, (IReportResourceChangeListener)this);
        }
        PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
        if (this.prefs != null) {
            this.prefs.removePreferenceChangeListener(this.preferenceChangeListener);
        }
        super.dispose();
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report multi page finalized");
        }
        super.finalize();
    }

    public IEditorPart getEditorPart() {
        return this;
    }

    public void performRequest(ReportRequest request) {
        if ("open editor".equals(request.getType()) && request.getSelectionModelList().size() == 1) {
            if (request.getSelectionModelList().get(0) instanceof MasterPageHandle) {
                this.handleOpenMasterPage(request);
                return;
            }
            if (request.getSelectionModelList().get(0) instanceof ScriptObjectNode) {
                this.handleOpenScriptPage(request);
                return;
            }
        }
    }

    protected void handleOpenScriptPage(final ReportRequest request) {
        if (this.getContainer().isVisible()) {
            this.setActivePage(ScriptForm_ID);
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ReportRequest r = new ReportRequest();
                    r.setType((Object)"selection");
                    r.setSelectionObject(request.getSelectionModelList());
                    SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
                }
            });
        }
    }

    protected void handleOpenMasterPage(final ReportRequest request) {
        if (this.getContainer().isVisible()) {
            this.setActivePage(LayoutMasterPage_ID);
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ReportRequest r = new ReportRequest();
                    r.setType((Object)"load masterpage");
                    r.setSelectionObject(request.getSelectionModelList());
                    SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
                }
            });
        }
    }

    public IFormPage getCurrentPageInstance() {
        Object page;
        int index = this.getCurrentPage();
        if (index != -1 && (page = this.pages.get(index)) instanceof IFormPage) {
            return (IFormPage)page;
        }
        return null;
    }

    private void refreshGraphicalEditor() {
        int i = 0;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && this.isGraphicalEditor(page) && ((GraphicalEditorWithFlyoutPalette)page).getGraphicalViewer() != null) {
                RootEditPart root = ((GraphicalEditorWithFlyoutPalette)page).getGraphicalViewer().getRootEditPart();
                this.refreshResourceEditPart((EditPart)root);
            }
            ++i;
        }
    }

    private boolean isGraphicalEditor(Object obj) {
        return obj instanceof GraphicalEditorWithFlyoutPalette;
    }

    protected void setActivePage(int pageIndex) {
        super.setActivePage(pageIndex);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                MultiPageReportEditor.this.setFocus();
            }
        });
    }

    public void resourceChanged(IReportResourceChangeEvent event) {
        if (event.getType() == 2) {
            if (event.getSource().equals(this.getModel())) {
                return;
            }
            LibrarySaveChangeEvent libEvent = (LibrarySaveChangeEvent)event;
            if (this.getModel().getFileName().equals(libEvent.getFileName())) {
                this.needReset = true;
            } else if (ModuleUtil.isInclude((ModuleHandle)this.getModel(), (String)libEvent.getFileName())) {
                this.needReload = true;
            }
        } else if (event.getType() == 4) {
            this.refreshGraphicalEditor();
        }
    }

    private static class FormEditorSelectionProvider
    extends MultiPageSelectionProvider {
        private ISelection globalSelection;

        public FormEditorSelectionProvider(FormEditor formEditor) {
            super((MultiPageEditorPart)formEditor);
        }

        public ISelection getSelection() {
            ISelectionProvider selectionProvider;
            IFormPage activeEditor = ((FormEditor)this.getMultiPageEditor()).getActivePageInstance();
            if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
                return selectionProvider.getSelection();
            }
            return this.globalSelection;
        }

        public void setSelection(ISelection selection) {
            IFormPage activeEditor = ((FormEditor)this.getMultiPageEditor()).getActivePageInstance();
            if (activeEditor != null) {
                ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.setSelection(selection);
                }
            } else {
                this.globalSelection = selection;
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.globalSelection));
            }
        }
    }
}

