/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileUtil {
    public static List<File> unzipFiles(File zippedfile, String destPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        ZipFile zipFile = new ZipFile(zippedfile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<File> outputFiles = new ArrayList<File>();
        File destinationFile = new File(destPath);
        if (!destinationFile.exists()) {
            destinationFile.mkdirs();
        }
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File outputFile = new File(destinationFile, entry.getName());
            if (entry.isDirectory() && !outputFile.exists()) {
                outputFile.mkdirs();
                continue;
            }
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            InputStream inputStream = zipFile.getInputStream(entry);
            FileOutputStream outStream = new FileOutputStream(outputFile);
            ZipFileUtil.copyByteStream(inputStream, outStream);
            outputFiles.add(outputFile);
            if (monitor == null) continue;
            monitor.worked(1);
        }
        return outputFiles;
    }

    public static List<File> extactEntries(File zippedFile, List<ZipEntry> entries, String destPath) throws FileNotFoundException, IOException {
        ZipFile zipFile = new ZipFile(zippedFile);
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (ZipEntry entry : entries) {
            if (entry.isDirectory()) {
                new File(entry.getName()).mkdir();
                continue;
            }
            InputStream inputStream = zipFile.getInputStream(entry);
            File outputFile = new File(String.valueOf(destPath) + File.separator + entry.getName());
            FileOutputStream outStream = new FileOutputStream(outputFile);
            ZipFileUtil.copyByteStream(inputStream, outStream);
            outputFiles.add(outputFile);
        }
        return outputFiles;
    }

    public static void copyByteStream(InputStream in, OutputStream out) throws IOException {
        if (in != null && out != null) {
            int readCount;
            BufferedInputStream inBuffered = new BufferedInputStream(in);
            int bufferSize = 1000;
            byte[] buffer = new byte[bufferSize];
            BufferedOutputStream fout = new BufferedOutputStream(out);
            while ((readCount = inBuffered.read(buffer)) != -1) {
                if (readCount < bufferSize) {
                    fout.write(buffer, 0, readCount);
                    continue;
                }
                fout.write(buffer);
            }
            fout.flush();
            fout.close();
            in.close();
        }
    }

    public static void createZipFile(File zipFile, List<File> files) throws FileNotFoundException, IOException {
        ZipFileUtil.createZipFile(zipFile, files, null, null);
    }

    public static void createZipFile(File zipFile, List<File> files, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        ZipFileUtil.createZipFile(zipFile, files, null, monitor);
    }

    public static void createZipFile(File zipFile, List<File> files, String rootPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (zipFile.exists()) {
            zipFile.delete();
        }
        if (rootPath == null) {
            rootPath = "";
        } else if (!rootPath.endsWith("\\") || !rootPath.endsWith("/")) {
            rootPath = String.valueOf(rootPath) + "/";
        }
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
        try {
            for (File file : files) {
                try {
                    ZipFileUtil.addZipEntry(zipOut, rootPath, file);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.core", "Could not add " + file.getName() + " to zip", (Throwable)e));
                }
            }
        }
        finally {
            zipOut.close();
        }
    }

    private static void addZipEntry(ZipOutputStream zipOut, String rootPath, File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    ZipFileUtil.addZipEntry(zipOut, rootPath, child);
                    ++n2;
                }
            } else {
                int len;
                String path = "";
                if (!rootPath.equals("")) {
                    rootPath = rootPath.replaceAll("\\\\", "/");
                    path = file.getAbsolutePath().replaceAll("\\\\", "/");
                    path = path.substring(rootPath.length());
                } else {
                    path = file.getName();
                }
                zipOut.putNextEntry(new ZipEntry(path));
                byte[] buf = new byte[1024];
                FileInputStream in = new FileInputStream(file);
                while ((len = in.read(buf)) > 0) {
                    zipOut.write(buf, 0, len);
                }
                zipOut.closeEntry();
                in.close();
            }
        }
    }
}

