/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.CancelManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.ICancellable;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.NamingRelation;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class DataEngineSession {
    private static Integer count = new Integer(0);
    private Map context;
    private Scriptable scope;
    private DataSetCacheManager dataSetCacheManager;
    private DataEngineImpl engine;
    private String tempDir;
    private QueryResultIDUtil queryResultIDUtil;
    private NamingRelation namingRelation;
    private CancelManager cancelManager;
    private StopSign stopSign;
    private Timer currentTimer;
    private static ThreadLocal<ClassLoader> classLoaderHolder = new ThreadLocal();
    private static Logger logger = Logger.getLogger(DataEngineSession.class.getName());

    public DataEngineSession(DataEngineImpl engine) {
        Object[] params = new Object[]{engine};
        logger.entering(DataEngineSession.class.getName(), "DataEngineSession", params);
        this.context = new HashMap();
        this.engine = engine;
        this.scope = engine.getContext().getJavaScriptScope();
        this.stopSign = new StopSign();
        if (this.scope == null) {
            this.scope = new ImporterTopLevel(engine.getContext().getScriptContext().getContext());
        }
        new CoreJavaScriptInitializer().initialize(engine.getContext().getScriptContext().getContext(), this.scope);
        this.tempDir = String.valueOf(engine.getContext().getTmpdir()) + "DataEngine_" + engine.hashCode() + "_" + this.getCount() + File.separator;
        this.dataSetCacheManager = new DataSetCacheManager(this);
        this.cancelManager = new CancelManager();
        this.currentTimer = new Timer();
        this.currentTimer.schedule((TimerTask)this.cancelManager, 1000L, 1000L);
        classLoaderHolder.set(engine.getContext().getClassLoader());
        engine.addShutdownListener(new IShutdownListener(){

            public void dataEngineShutdown() {
                classLoaderHolder.set(null);
                DataEngineSession.this.houseKeepCancelManager();
            }
        });
        engine.addShutdownListener(new ReportDocumentShutdownListener(this));
        this.cancelManager.register(new StopSignCancellable(this.stopSign));
        this.queryResultIDUtil = new QueryResultIDUtil();
        logger.exiting(DataEngineSession.class.getName(), "DataEngineSession");
    }

    public void finalize() {
        this.houseKeepCancelManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount() {
        Integer n = count;
        synchronized (n) {
            count = (count + 1) % 100000;
            return count;
        }
    }

    public DataEngine getEngine() {
        return this.engine;
    }

    public Object get(String key) {
        if (key != null) {
            return this.context.get(key);
        }
        return null;
    }

    public void set(String key, Object value) {
        this.context.put(key, value);
    }

    public StopSign getStopSign() {
        return this.stopSign;
    }

    public Scriptable getSharedScope() {
        return this.scope;
    }

    public DataSetCacheManager getDataSetCacheManager() {
        return this.dataSetCacheManager;
    }

    public static ClassLoader getCurrentClassLoader() {
        return classLoaderHolder.get();
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public DataEngineContext getEngineContext() {
        return this.engine.getContext();
    }

    public QueryResultIDUtil getQueryResultIDUtil() {
        return this.queryResultIDUtil;
    }

    public NamingRelation getNamingRelation() {
        return this.namingRelation;
    }

    public void setNamingRelation(NamingRelation namingRelation) {
        this.namingRelation = namingRelation;
    }

    public CancelManager getCancelManager() {
        return this.cancelManager;
    }

    private void houseKeepCancelManager() {
        if (this.cancelManager != null) {
            this.cancelManager.cancel();
            this.cancelManager = null;
            this.currentTimer.cancel();
        }
    }

    class ReportDocumentShutdownListener
    implements IShutdownListener {
        private DataEngineSession session;

        ReportDocumentShutdownListener(DataEngineSession session) {
            this.session = session;
        }

        public void dataEngineShutdown() {
            if (this.session.getNamingRelation() == null) {
                return;
            }
            int mode = this.session.getEngineContext().getMode();
            if (mode == 1 || mode == 4) {
                try {
                    this.saveNamingRelation(this.session.getNamingRelation());
                }
                catch (DataException e1) {
                    e1.printStackTrace();
                }
            }
        }

        private void saveNamingRelation(NamingRelation relation) throws DataException {
            Map bookmarkMap = relation.getBookmarkMap();
            Map elementIdMap = relation.getElementIdMap();
            RAOutputStream out = this.session.getEngineContext().getOutputStream(null, null, 101);
            try {
                try {
                    DataOutputStream dos = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
                    IOUtil.writeMap((DataOutputStream)dos, (Map)bookmarkMap);
                    IOUtil.writeMap((DataOutputStream)dos, (Map)elementIdMap);
                    dos.flush();
                }
                catch (IOException e) {
                    throw new DataException("", e);
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "", e);
                    }
                }
            }
        }
    }

    private class StopSignCancellable
    implements ICancellable {
        private StopSign stopSign;

        StopSignCancellable(StopSign stopSign) {
            assert (stopSign != null);
            this.stopSign = stopSign;
        }

        public void cancel() {
            this.stopSign.stop();
        }

        public DataException collectException() {
            return null;
        }

        public boolean doCancel() {
            return this.stopSign.isStopped();
        }
    }
}

