/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetResultSet
implements IDataSetPopulator {
    private int rowIndex;
    private int rowCount;
    private RAInputStream inputStream;
    private BufferedInputStream bis;
    private DataInputStream dis;
    private IResultClass rsMetaData;
    private int colCount;
    private IResultObject currentObject;
    private RAInputStream dataSetRowLensStream;
    private DataInputStream disRowLensStream;
    private long initPos;

    public DataSetResultSet(RAInputStream inputStream, RAInputStream lensStream, IResultClass rsMetaData, int version) throws DataException {
        assert (inputStream != null);
        assert (rsMetaData != null);
        this.inputStream = inputStream;
        this.rowIndex = -1;
        this.dataSetRowLensStream = lensStream;
        if (lensStream != null) {
            this.disRowLensStream = new DataInputStream((InputStream)this.dataSetRowLensStream);
        }
        try {
            this.initPos = this.inputStream.getOffset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.rsMetaData = this.populateResultClass(rsMetaData);
        this.colCount = rsMetaData.getFieldCount();
        this.initLoad();
    }

    private IResultClass populateResultClass(IResultClass meta) throws DataException {
        if (meta.getFieldCount() == 0 || meta.getFieldIndex("_$$_dte_inner_row_id_$$_") != -1) {
            return meta;
        }
        ArrayList<ResultFieldMetadata> list = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            list.add(meta.getFieldMetaData(i));
            ++i;
        }
        ResultFieldMetadata rfm = new ResultFieldMetadata(0, "_$$_dte_inner_row_id_$$_", null, Integer.class, null, true);
        list.add(rfm);
        return new ResultClass(list);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public IResultObject next() throws DataException {
        if (this.rowIndex < this.rowCount - 1 || this.rowCount == -1) {
            try {
                ++this.rowIndex;
                this.currentObject = ResultSetUtil.readResultObject(this.dis, this.rsMetaData, this.colCount);
                this.currentObject.setCustomFieldValue("_$$_dte_inner_row_id_$$_", (Object)this.getCurrentIndex());
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
            }
        } else {
            this.currentObject = null;
        }
        return this.currentObject;
    }

    public IResultObject getResultObject() {
        return this.currentObject;
    }

    public int getCurrentIndex() {
        return this.rowIndex;
    }

    public void skipTo(int index) throws DataException, IOException {
        if (this.rowIndex == index) {
            return;
        }
        if ((this.rowIndex < this.rowCount || this.rowCount == -1) && this.dataSetRowLensStream != null) {
            this.dataSetRowLensStream.seek((long)(index * 8));
            long position = IOUtil.readLong((DataInputStream)this.disRowLensStream);
            this.rowIndex = index;
            this.inputStream.seek(position + this.initPos);
            this.dis = new DataInputStream((InputStream)this.inputStream);
            this.currentObject = ResultSetUtil.readResultObject(this.dis, this.rsMetaData, this.colCount);
            this.currentObject.setCustomFieldValue("_$$_dte_inner_row_id_$$_", (Object)this.getCurrentIndex());
            return;
        }
    }

    private void initLoad() throws DataException {
        if (this.dis == null) {
            this.bis = new BufferedInputStream((InputStream)this.inputStream);
            try {
                this.dis = new DataInputStream(this.bis);
                this.rowCount = IOUtil.readInt((InputStream)this.dis);
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "result data");
            }
        }
    }

    public IResultClass getResultClass() {
        return this.rsMetaData;
    }

    public void close() {
        try {
            if (this.dis != null) {
                this.dis.close();
                this.bis.close();
            }
        }
        catch (IOException iOException) {}
    }
}

