/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;

public class MeasureNameManager {
    private CalculatedMember[] membersFromQuery;
    private List<CalculatedMember> allMembers = new ArrayList<CalculatedMember>();

    MeasureNameManager(CalculatedMember[] members) {
        this.membersFromQuery = members;
        this.allMembers.addAll(Arrays.asList(this.membersFromQuery));
    }

    public String getAggrName(int index) throws DataException {
        if (index >= this.allMembers.size() || index < 0) {
            throw new DataException("data.olap.measureNameNotFound");
        }
        return this.allMembers.get(index).getCubeAggrDefn().getName();
    }

    public int getAggregationResultID(String name) throws DataException {
        int rsID = -1;
        for (CalculatedMember member : this.allMembers) {
            if (!member.getCubeAggrDefn().getName().equals(name)) continue;
            rsID = member.getRsID();
            break;
        }
        if (rsID == -1) {
            throw new DataException("data.olap.CannotGetMeasureValue", new Object[]{name});
        }
        return rsID;
    }

    public int getAggregationIndex(String name) throws DataException {
        int rsID = this.getAggregationResultID(name);
        int index = 0;
        if (rsID >= 0) {
            for (CalculatedMember member : this.allMembers) {
                if (member.getCubeAggrDefn().getName().equals(name)) break;
                if (member.getRsID() != rsID || member.getCubeAggrDefn().getName().equals(name)) continue;
                ++index;
            }
        }
        return index;
    }

    public CalculatedMember getCalculatedMember(String name) throws DataException {
        for (CalculatedMember member : this.allMembers) {
            if (!member.getCubeAggrDefn().getName().equals(name)) continue;
            return member;
        }
        throw new DataException("data.olap.CannotGetMeasureValue", new Object[]{name});
    }

    public CalculatedMember[] getCalculatedMembers() {
        return this.allMembers.toArray(new CalculatedMember[0]);
    }

    public int getBasedRsIndex() {
        int rsID = -1;
        for (CalculatedMember member : this.allMembers) {
            if (member.getRsID() <= rsID) continue;
            rsID = member.getRsID();
        }
        return rsID;
    }

    public void addCalculatedMembersFromCubeOperation(CalculatedMember[] newMembers) {
        if (newMembers != null) {
            this.allMembers.addAll(Arrays.asList(newMembers));
        }
    }

    public CalculatedMember[] getCalculatedMembersFromQuery() {
        return this.membersFromQuery;
    }
}

