/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.driver.CubeResultSet;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationsExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryValidator;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.sort.DimensionSortEvalHelper;
import org.mozilla.javascript.Scriptable;

public class QueryExecutor {
    private CubeQueryExecutorHelper cubeQueryExecutorHelper;

    public IResultSet execute(BirtCubeView view, StopSign stopSign) throws IOException, BirtException {
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        AggregationDefinition[] aggrDefns = this.prepareCube(executor.getCubeQueryDefinition(), view.getMeasureNameManger().getCalculatedMembersFromQuery());
        if (aggrDefns == null || aggrDefns.length == 0) {
            return null;
        }
        String cubeName = executor.getCubeQueryDefinition().getName();
        if (cubeName == null || cubeName.trim().length() == 0) {
            throw new DataException("data.olap.query.noCubeBinding");
        }
        IDocumentManager documentManager = this.getDocumentManager(executor);
        ICube cube = this.loadCube(documentManager, executor);
        CubeQueryValidator.validateCubeQueryDefinition(executor.getCubeQueryDefinition(), view, cube, view.getMeasureNameManger().getCalculatedMembersFromQuery());
        this.cubeQueryExecutorHelper = new CubeQueryExecutorHelper(cube, executor.getComputedMeasureHelper());
        this.cubeQueryExecutorHelper.addJSFilter(executor.getDimensionFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addAggrMeasureFilter(executor.getMeasureFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addMeasureFilter(executor.getFacttableBasedFilterHelpers());
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 2);
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 1);
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 3);
        IAggregationResultSet[] rs = null;
        this.cubeQueryExecutorHelper.setBreakHierarchy(executor.getCubeQueryDefinition().getFilterOption() == 0);
        switch (executor.getContext().getMode()) {
            case 1: {
                rs = this.populateRs(view, aggrDefns, this.cubeQueryExecutorHelper, stopSign, true);
                break;
            }
            case 3: {
                rs = this.populateRs(view, aggrDefns, this.cubeQueryExecutorHelper, stopSign, false);
                break;
            }
            case 2: {
                assert (executor.getCubeQueryDefinition().getQueryResultsID() != null);
                rs = AggregationResultSetSaveUtil.load(executor.getCubeQueryDefinition().getQueryResultsID(), executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion());
                break;
            }
            default: {
                rs = this.cubeQueryExecutorHelper.execute(aggrDefns, stopSign);
                CubeOperationsExecutor coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), view.getPreparedCubeOperations(), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
                rs = coe.execute(rs, stopSign);
                String id = executor.getCubeQueryDefinition().getQueryResultsID();
                if (id == null) {
                    id = executor.getSession().getQueryResultIDUtil().nextID();
                }
                AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
            }
        }
        cube.close();
        return new CubeResultSet(rs, view, this.cubeQueryExecutorHelper);
    }

    private IAggregationResultSet[] populateRs(BirtCubeView view, AggregationDefinition[] aggrDefns, CubeQueryExecutorHelper cubeQueryExcutorHelper2, StopSign stopSign, boolean saveToRD) throws IOException, BirtException {
        IAggregationResultSet[] rs;
        String id = null;
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        if (executor.getCubeQueryDefinition().getQueryResultsID() == null) {
            rs = this.cubeQueryExecutorHelper.execute(aggrDefns, executor.getSession().getStopSign());
            CubeOperationsExecutor coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), view.getPreparedCubeOperations(), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
            rs = coe.execute(rs, stopSign);
            if (executor.getCubeQueryDefinition().cacheQueryResults()) {
                id = executor.getSession().getQueryResultIDUtil().nextID();
                File tmpDir = new File(executor.getSession().getTempDir());
                if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
                    FileSecurity.fileMakeDirs(tmpDir);
                }
                ArchiveWriter writer = new ArchiveWriter((IArchiveFile)new ArchiveFile(String.valueOf(executor.getSession().getTempDir()) + "Cache", "rw+"));
                AggregationResultSetSaveUtil.save(id, rs, (IDocArchiveWriter)writer);
                writer.finish();
            }
            if (saveToRD) {
                if (id != null) {
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                } else {
                    id = executor.getSession().getQueryResultIDUtil().nextID();
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                }
            }
        } else {
            id = executor.getCubeQueryDefinition().getQueryResultsID();
            rs = AggregationResultSetSaveUtil.load(id, (IDocArchiveReader)new FileArchiveReader(String.valueOf(executor.getSession().getTempDir()) + "Cache"), VersionManager.getLatestVersion());
        }
        executor.setQueryResultsId(id);
        return rs;
    }

    public IResultSet executeSubQuery(IResultSet parentResultSet, BirtCubeView view, int startingColumnLevelIndex, int startingRowLevelIndex) throws IOException {
        return new CubeResultSet(parentResultSet, view, this.cubeQueryExecutorHelper, startingColumnLevelIndex, startingRowLevelIndex);
    }

    private void populateAggregationSort(CubeQueryExecutor executor, CubeQueryExecutorHelper cubeQueryExcutorHelper, int type) throws DataException {
        List columnSort;
        switch (type) {
            case 2: {
                columnSort = executor.getColumnEdgeSort();
                break;
            }
            case 1: {
                columnSort = executor.getRowEdgeSort();
                break;
            }
            case 3: {
                List columnSort2 = executor.getPageEdgeSort();
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < columnSort.size()) {
            block19: {
                ITargetSort targetSort;
                block18: {
                    DimLevel[] aggrOnLevels;
                    String bindingName;
                    ICubeSortDefinition cubeSort;
                    block21: {
                        List aggrOns;
                        block20: {
                            String expr;
                            ICubeQueryDefinition queryDefn;
                            block17: {
                                cubeSort = (ICubeSortDefinition)columnSort.get(i);
                                queryDefn = executor.getCubeQueryDefinition();
                                expr = cubeSort.getExpression().getText();
                                targetSort = null;
                                if (cubeSort.getAxisQualifierLevels().length != 0 || !OlapExpressionUtil.isComplexDimensionExpr(expr) && !OlapExpressionUtil.isReferenceToAttribute(cubeSort.getExpression(), queryDefn.getBindings())) break block17;
                                Scriptable scope = executor.getSession().getSharedScope();
                                targetSort = new DimensionSortEvalHelper(executor.getOuterResults(), scope, queryDefn, cubeSort, executor.getSession().getEngineContext().getScriptContext());
                                break block18;
                            }
                            bindingName = OlapExpressionUtil.getBindingName(expr);
                            if (bindingName == null) break block19;
                            List bindings = queryDefn.getBindings();
                            aggrOns = null;
                            IBinding binding = null;
                            int j = 0;
                            while (j < bindings.size()) {
                                binding = (IBinding)bindings.get(j);
                                if (binding.getBindingName().equals(bindingName)) {
                                    aggrOns = binding.getAggregatOns();
                                    break;
                                }
                                ++j;
                            }
                            aggrOnLevels = null;
                            if (aggrOns != null && aggrOns.size() != 0) break block20;
                            if (binding == null) break block19;
                            String measureName = OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "measure");
                            if (measureName != null) {
                                List measureAggrOns = CubeQueryDefinitionUtil.populateMeasureAggrOns(queryDefn);
                                aggrOnLevels = new DimLevel[measureAggrOns.size()];
                                int k = 0;
                                while (k < measureAggrOns.size()) {
                                    aggrOnLevels[k] = (DimLevel)measureAggrOns.get(k);
                                    ++k;
                                }
                            }
                            break block21;
                        }
                        aggrOnLevels = new DimLevel[aggrOns.size()];
                        int j = 0;
                        while (j < aggrOnLevels.length) {
                            aggrOnLevels[j] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j).toString());
                            ++j;
                        }
                    }
                    DimLevel[] axisLevels = new DimLevel[cubeSort.getAxisQualifierLevels().length];
                    int k = 0;
                    while (k < axisLevels.length) {
                        axisLevels[k] = new DimLevel(cubeSort.getAxisQualifierLevels()[k]);
                        ++k;
                    }
                    targetSort = new AggrSortDefinition(aggrOnLevels, bindingName, axisLevels, cubeSort.getAxisQualifierValues(), new DimLevel(cubeSort.getTargetLevel()), cubeSort.getSortDirection());
                }
                switch (type) {
                    case 2: {
                        cubeQueryExcutorHelper.addColumnSort(targetSort);
                        break;
                    }
                    case 1: {
                        cubeQueryExcutorHelper.addRowSort(targetSort);
                        break;
                    }
                    case 3: {
                        cubeQueryExcutorHelper.addPageSort(targetSort);
                    }
                }
            }
            ++i;
        }
    }

    private ICube loadCube(IDocumentManager documentManager, CubeQueryExecutor executor) throws DataException, IOException {
        ICube cube = null;
        cube = CubeQueryExecutorHelper.loadCube(executor.getCubeQueryDefinition().getName(), documentManager, executor.getSession().getStopSign());
        return cube;
    }

    private IDocumentManager getDocumentManager(CubeQueryExecutor executor) throws DataException, IOException {
        if (executor.getContext().getMode() == 3 || executor.getContext().getMode() == 1) {
            return DocManagerMap.getDocManagerMap().get(String.valueOf(executor.getSession().getEngine().hashCode()), String.valueOf(executor.getSession().getTempDir()) + executor.getCubeQueryDefinition().getName());
        }
        return DocumentManagerFactory.createRADocumentManager(executor.getContext().getDocReader());
    }

    private AggregationDefinition[] prepareCube(ICubeQueryDefinition query, CalculatedMember[] calculatedMember) throws DataException {
        int i;
        int index;
        int[] sortType;
        DimLevel[] levelsForFilter;
        IEdgeDefinition columnEdgeDefn = query.getEdge(2);
        ILevelDefinition[] levelsOnColumn = CubeQueryDefinitionUtil.getLevelsOnEdge(columnEdgeDefn);
        IEdgeDefinition rowEdgeDefn = query.getEdge(1);
        ILevelDefinition[] levelsOnRow = CubeQueryDefinitionUtil.getLevelsOnEdge(rowEdgeDefn);
        IEdgeDefinition pageEdgeDefn = query.getEdge(3);
        ILevelDefinition[] levelsOnPage = CubeQueryDefinitionUtil.getLevelsOnEdge(pageEdgeDefn);
        ArrayList<AggregationDefinition> aggregations = new ArrayList<AggregationDefinition>();
        if (columnEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnColumn.length + levelsOnPage.length];
            sortType = new int[levelsOnColumn.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnColumn.length) {
                levelsForFilter[index] = new DimLevel(levelsOnColumn[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (rowEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnRow.length + levelsOnPage.length];
            sortType = new int[levelsOnRow.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnRow.length) {
                levelsForFilter[index] = new DimLevel(levelsOnRow[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (pageEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnPage.length];
            sortType = new int[levelsOnPage.length];
            int i2 = 0;
            while (i2 < levelsOnPage.length) {
                levelsForFilter[i2] = new DimLevel(levelsOnPage[i2]);
                sortType[i2] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i2], query);
                ++i2;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        AggregationDefinition[] fromCalculatedMembers = CubeQueryDefinitionUtil.createAggregationDefinitons(calculatedMember, query, null, null);
        aggregations.addAll(Arrays.asList(fromCalculatedMembers));
        return aggregations.toArray(new AggregationDefinition[0]);
    }
}

