/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.filter;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.util.DataJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.DimensionJSEvalHelper;
import org.eclipse.birt.data.engine.olap.util.IJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.filter.IAggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class AggrMeasureFilterEvalHelper
extends DimensionJSEvalHelper
implements IAggrMeasureFilterEvalHelper {
    public AggrMeasureFilterEvalHelper(IBaseQueryResults outResults, Scriptable scope, ICubeQueryDefinition queryDefn, IFilterDefinition cubeFilter, ScriptContext cx) throws DataException {
        assert (cubeFilter != null);
        super.init(outResults, scope, queryDefn, cx, cubeFilter.getExpression());
    }

    public boolean evaluateFilter(IResultRow resultRow) throws DataException {
        super.setData(resultRow);
        try {
            Object result = ScriptEvalUtil.evalExpr(this.expr, this.cx, this.scope, ScriptExpression.defaultID, 0);
            return DataTypeUtil.toBoolean((Object)result);
        }
        catch (IJSObjectPopulator.InMatchDimensionIndicator inMatchDimensionIndicator) {
            return true;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    protected void registerJSObjectPopulators() throws DataException {
        super.registerJSObjectPopulators();
        this.register(new DataJSObjectPopulator(this.outResults, this.scope, this.queryDefn.getBindings(), true, this.cx));
    }

    public IBaseExpression getExpression() {
        return this.expr;
    }
}

