/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.script.NEvaluator;
import org.mozilla.javascript.Scriptable;

public class ScriptEvalUtil {
    private static Logger logger = Logger.getLogger(ScriptEvalUtil.class.getName());
    private static Pattern s_JSReExprPattern;

    private ScriptEvalUtil() {
    }

    public static ExprTextAndValue newExprInfo(String exprText, Object value) {
        return ExprTextAndValue.newInstance(exprText, value);
    }

    public static Object evalConditionalExpr(Object obj, int operator, Object Op1, Object Op2) throws DataException {
        return ScriptEvalUtil.evalConditionalExpr(obj, operator, new Object[]{Op1, Op2});
    }

    public static Object evalConditionalExpr(Object obj, int operator, Object[] ops) throws DataException {
        ExprTextAndValue[] opTextAndValue = new ExprTextAndValue[ops.length];
        int i = 0;
        while (i < ops.length) {
            opTextAndValue[i] = ScriptEvalUtil.createExprTextAndValueInstance(ops[i]);
            ++i;
        }
        Object resultObject = obj;
        Object[] resultOp = new Object[ops.length];
        int i2 = 0;
        while (i2 < ops.length) {
            resultOp[i2] = opTextAndValue[i2].value;
            ++i2;
        }
        Object[] obArray = MiscUtil.isComparable(obj, operator, opTextAndValue);
        if (obArray != null) {
            resultObject = obArray[0];
            int i3 = 1;
            while (i3 < obArray.length) {
                resultOp[i3 - 1] = obArray[i3];
                ++i3;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            String logStr = "";
            int i4 = 0;
            while (i4 < ops.length) {
                logStr = String.valueOf(logStr) + (resultOp[i4] == null ? null : ", resultOp" + i4 + "=" + LogUtil.toString(resultOp[i4]));
                ++i4;
            }
            logger.entering(ScriptEvalUtil.class.getName(), "evalConditionalExpr", "evalConditionalExpr() resultObject=" + LogUtil.toString(resultObject) + ", operator=" + operator + logStr);
        }
        boolean result = false;
        switch (operator) {
            case 1: {
                result = ScriptEvalUtil.compare(resultObject, resultOp[0]) == 0;
                break;
            }
            case 2: {
                result = ScriptEvalUtil.compare(resultObject, resultOp[0]) != 0;
                break;
            }
            case 3: {
                result = ScriptEvalUtil.compare(resultObject, resultOp[0]) < 0;
                break;
            }
            case 4: {
                result = ScriptEvalUtil.compare(resultObject, resultOp[0]) <= 0;
                break;
            }
            case 5: {
                result = ScriptEvalUtil.compare(resultObject, resultOp[0]) >= 0;
                break;
            }
            case 6: {
                result = ScriptEvalUtil.compare(resultObject, resultOp[0]) > 0;
                break;
            }
            case 7: {
                result = ScriptEvalUtil.between(resultObject, resultOp[0], resultOp[1]);
                break;
            }
            case 8: {
                result = !ScriptEvalUtil.between(resultObject, resultOp[0], resultOp[1]);
                break;
            }
            case 9: {
                result = resultObject == null;
                break;
            }
            case 10: {
                result = resultObject != null;
                break;
            }
            case 11: {
                result = ScriptEvalUtil.isTrueOrFalse(resultObject, Boolean.TRUE);
                break;
            }
            case 12: {
                result = ScriptEvalUtil.isTrueOrFalse(resultObject, Boolean.FALSE);
                break;
            }
            case 13: {
                result = ScriptEvalUtil.like(resultObject, resultOp[0]);
                break;
            }
            case 20: {
                result = !ScriptEvalUtil.like(resultObject, resultOp[0]);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                throw new DataException("data.engine.UnsupportedCondOp", "Top/Bottom(N) outside of row filters");
            }
            case 19: {
                result = ScriptEvalUtil.match(resultObject, resultOp[0]);
                break;
            }
            case 21: {
                result = !ScriptEvalUtil.match(resultObject, resultOp[0]);
                break;
            }
            case 22: {
                result = ScriptEvalUtil.in(resultObject, resultOp);
                break;
            }
            case 23: {
                result = !ScriptEvalUtil.in(resultObject, resultOp);
                break;
            }
            default: {
                throw new DataException("data.engine.UnsupportedCondOp", new Integer(operator));
            }
        }
        logger.exiting(ScriptEvalUtil.class.getName(), "evalConditionalExpr", new Boolean(result));
        return new Boolean(result);
    }

    private static ExprTextAndValue createExprTextAndValueInstance(Object o) {
        ExprTextAndValue op = !(o instanceof ExprTextAndValue) ? ExprTextAndValue.newInstance("", o) : (ExprTextAndValue)o;
        return op;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int compare(Object obj1, Object obj2, Comparator strComp) throws DataException {
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            return 0;
        }
        try {
            if (MiscUtil.isSameType(obj1, obj2)) {
                if (obj1 instanceof String) {
                    return ScriptEvalUtil.compareAsString(obj1, obj2, strComp);
                }
                if (obj1 instanceof Boolean) {
                    if (obj1.equals(obj2)) {
                        return 0;
                    }
                    Boolean bool = (Boolean)obj1;
                    if (bool.equals(Boolean.TRUE)) {
                        return 1;
                    }
                    return -1;
                }
                if (obj1 instanceof Comparable) {
                    return ((Comparable)obj1).compareTo(obj2);
                }
                return ScriptEvalUtil.compareAsString(obj1, obj2, strComp);
            }
            if (MiscUtil.isBigDecimal(obj1) || MiscUtil.isBigDecimal(obj2)) {
                BigDecimal a = DataTypeUtil.toBigDecimal((Object)obj1);
                BigDecimal b = DataTypeUtil.toBigDecimal((Object)obj2);
                return a.compareTo(b);
            }
            if (MiscUtil.isNumericOrString(obj1) && MiscUtil.isNumericOrString(obj2)) {
                try {
                    return DataTypeUtil.toDouble((Object)obj1).compareTo(DataTypeUtil.toDouble((Object)obj2));
                }
                catch (Exception exception) {
                    return ScriptEvalUtil.compareAsString(obj1, obj2, strComp);
                }
            }
            if (MiscUtil.isDateOrString(obj1) && MiscUtil.isDateOrString(obj2)) {
                try {
                    return DataTypeUtil.toDate((Object)obj1).compareTo(DataTypeUtil.toDate((Object)obj2));
                }
                catch (Exception exception) {
                    return ScriptEvalUtil.compareAsString(obj1, obj2, strComp);
                }
            }
            if (MiscUtil.isBooleanOrString(obj1) && MiscUtil.isBooleanOrString(obj2)) {
                try {
                    boolean b1 = DataTypeUtil.toBoolean((Object)obj1);
                    boolean b2 = DataTypeUtil.toBoolean((Object)obj2);
                    if (b1 == b2) {
                        return 0;
                    }
                    if (!b1 && b2) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception exception) {
                    return ScriptEvalUtil.compareAsString(obj1, obj2, strComp);
                }
            }
            throw new DataException("data.engine.BadDataTypeCondExpr");
        }
        catch (BirtException e) {
            throw new DataException("data.engine.DataConversionError", e);
        }
    }

    private static int compareAsString(Object obj1, Object obj2, Comparator comp) throws BirtException {
        return comp == null ? DataTypeUtil.toString((Object)obj1).compareTo(DataTypeUtil.toString((Object)obj2)) : comp.compare(DataTypeUtil.toString((Object)obj1), DataTypeUtil.toString((Object)obj2));
    }

    public static int compare(Object obj1, Object obj2) throws DataException {
        return ScriptEvalUtil.compare(obj1, obj2, null);
    }

    private static boolean between(Object resultObject, Object resultOp1, Object resultOp2) throws DataException {
        Object max;
        Object min;
        if (ScriptEvalUtil.compare(resultOp1, resultOp2) <= 0) {
            min = resultOp1;
            max = resultOp2;
        } else {
            min = resultOp2;
            max = resultOp1;
        }
        return ScriptEvalUtil.compare(resultObject, min) >= 0 && ScriptEvalUtil.compare(resultObject, max) <= 0;
    }

    private static boolean isTrueOrFalse(Object obj, Boolean bln) {
        if (obj == null) {
            return false;
        }
        try {
            return DataTypeUtil.toBoolean((Object)obj).equals(bln);
        }
        catch (BirtException birtException) {
            return false;
        }
    }

    private static Matcher getJSReExprPatternMatcher(String patternStr) {
        if (s_JSReExprPattern == null) {
            s_JSReExprPattern = Pattern.compile("^/(.*)/([a-zA-Z]*)$");
        }
        return s_JSReExprPattern.matcher(patternStr);
    }

    private static boolean match(Object source, Object pattern) throws DataException {
        String sourceStr = source == null ? "" : source.toString();
        String patternStr = pattern == null ? "" : pattern.toString();
        Matcher jsReExprMatcher = ScriptEvalUtil.getJSReExprPatternMatcher(patternStr);
        int flags = 0;
        if (jsReExprMatcher.matches()) {
            String flagStr = patternStr.substring(jsReExprMatcher.start(2), jsReExprMatcher.end(2));
            int i = 0;
            while (i < flagStr.length()) {
                switch (flagStr.charAt(i)) {
                    case 'm': {
                        flags |= 8;
                        break;
                    }
                    case 'i': {
                        flags |= 2;
                        break;
                    }
                    case 'g': {
                        break;
                    }
                    default: {
                        throw new DataException("data.engine.MatchError", patternStr);
                    }
                }
                ++i;
            }
            patternStr = patternStr.substring(jsReExprMatcher.start(1), jsReExprMatcher.end(1));
        }
        try {
            Matcher m = Pattern.compile(patternStr, flags).matcher(sourceStr);
            return m.find();
        }
        catch (PatternSyntaxException e) {
            throw new DataException("data.engine.MatchError", (Throwable)e, patternStr);
        }
    }

    private static boolean like(Object source, Object pattern) throws DataException {
        String sourceStr = source == null ? "" : source.toString();
        String patternStr = pattern == null ? "" : pattern.toString();
        int patternLen = patternStr.length();
        StringBuffer buffer = new StringBuffer(patternLen * 2);
        int i = 0;
        while (i < patternLen) {
            char c = patternStr.charAt(i);
            if (c == '\\') {
                if (++i < patternLen) {
                    c = patternStr.charAt(i);
                    if (c == '%' || c == '_') {
                        buffer.append(c);
                    } else if (c == '\\') {
                        buffer.append("\\\\");
                    }
                } else {
                    buffer.append("\\\\");
                }
            } else if (c == '%') {
                buffer.append(".*");
            } else if (c == '_') {
                buffer.append(".");
            } else {
                if ("([{^$|)?*+.".indexOf(c) >= 0) {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            ++i;
        }
        try {
            String newPatternStr = buffer.toString();
            Pattern p = Pattern.compile(newPatternStr);
            Matcher m = p.matcher(sourceStr.toString());
            return m.matches();
        }
        catch (PatternSyntaxException e) {
            throw new DataException("data.engine.MatchError", (Throwable)e, pattern);
        }
    }

    private static boolean in(Object target, Object[] resultObj) throws DataException {
        if (resultObj == null) {
            return false;
        }
        int i = 0;
        while (i < resultObj.length) {
            if (ScriptEvalUtil.compare(target, resultObj[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Object evalExpr(IBaseExpression expr, ScriptContext cx, Scriptable scope, String source, int lineNo) throws DataException {
        Object result;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ScriptEvalUtil.class.getName(), "evalExpr", "evalExpr() expr=" + LogUtil.toString(expr) + ", source=" + source + ", lineNo=" + lineNo);
        }
        if (expr == null) {
            result = null;
        } else if (expr instanceof IConditionalExpression) {
            Object handle = expr.getHandle();
            if (handle instanceof NEvaluator) {
                result = ((NEvaluator)handle).evaluate(cx, scope);
            } else {
                ConditionalExpression conditionalExpr = (ConditionalExpression)expr;
                Object expression = ScriptEvalUtil.evalExpr(conditionalExpr.getExpression(), cx, scope, source, lineNo);
                if (conditionalExpr.getOperand1() instanceof IExpressionCollection) {
                    IExpressionCollection combinedExpr = (IExpressionCollection)((IConditionalExpression)expr).getOperand1();
                    Object[] exprs = combinedExpr.getExpressions().toArray();
                    Object[] opValues = new Object[exprs.length];
                    int i = 0;
                    while (i < opValues.length) {
                        opValues[i] = ScriptEvalUtil.evalExpr((IBaseExpression)exprs[i], cx, scope, source, lineNo);
                        ++i;
                    }
                    result = ScriptEvalUtil.evalConditionalExpr(expression, conditionalExpr.getOperator(), MiscUtil.flatternMultipleValues(opValues));
                } else {
                    Object Op1 = ScriptEvalUtil.evalExpr(MiscUtil.constructValidScriptExpression((IScriptExpression)conditionalExpr.getOperand1()), cx, scope, source, lineNo);
                    Object Op2 = ScriptEvalUtil.evalExpr(MiscUtil.constructValidScriptExpression((IScriptExpression)conditionalExpr.getOperand2()), cx, scope, source, lineNo);
                    result = ScriptEvalUtil.evalConditionalExpr(expression, conditionalExpr.getOperator(), new Object[]{Op1, Op2});
                }
            }
        } else {
            IScriptExpression jsExpr = (IScriptExpression)expr;
            result = jsExpr.getText() != null && jsExpr.getHandle() != null ? ((CompiledExpression)jsExpr.getHandle()).evaluate(cx, scope) : ScriptEvalUtil.evaluateJSAsExpr(cx, scope, jsExpr.getText(), source, lineNo);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ScriptEvalUtil.class.getName(), "evalExpr", result);
        }
        return result;
    }

    public static Object evaluateJSAsExpr(ScriptContext cx, Scriptable scope, String scriptText, String source, int lineNo) throws DataException {
        Object result;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ScriptEvalUtil.class.getName(), "evaluateJSExpr", "evaluateJSExpr() scriptText=" + scriptText + ", source=" + source + ", lineNo=" + lineNo);
        }
        try {
            result = cx.eval(scriptText, scope);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        return result;
    }

    public static class ExprTextAndValue {
        String exprText;
        Object value;

        public static ExprTextAndValue newInstance(String exprText, Object value) {
            return new ExprTextAndValue(exprText, value);
        }

        public ExprTextAndValue(String exprText, Object value) {
            this.exprText = exprText;
            this.value = value;
        }
    }

    private static class MiscUtil {
        private MiscUtil() {
        }

        private static boolean isSameType(Object resultExpr, Object resultOp1) {
            return resultExpr.getClass().equals(resultOp1.getClass());
        }

        private static boolean isNumericOrString(Object result) {
            return result instanceof Number || result instanceof String;
        }

        private static boolean isBigDecimal(Object result) {
            return result instanceof BigDecimal;
        }

        private static boolean isDateOrString(Object result) {
            return result instanceof java.util.Date || result instanceof String;
        }

        private static boolean isBooleanOrString(Object result) {
            return result instanceof Boolean || result instanceof String;
        }

        private static Object[] isComparable(Object obj, int operator, ExprTextAndValue[] operands) {
            if (MiscUtil.needFormat(obj, operator, operands)) {
                return MiscUtil.formatToComparable(obj, operands);
            }
            return null;
        }

        private static boolean needFormat(Object obj, int operator, ExprTextAndValue[] ops) {
            if (operator < 1 || operator > 8 && operator < 22 || obj == null || ops.length == 0 || ops[0].value == null) {
                return false;
            }
            return operator != 7 && operator != 8 || ops.length >= 2;
        }

        private static Object[] formatToComparable(Object obj, ExprTextAndValue[] operands) {
            Object[] obArray = new Object[operands.length + 1];
            obArray[0] = obj;
            int i = 0;
            while (i < operands.length) {
                obArray[i + 1] = operands[i].value;
                ++i;
            }
            boolean isSameType = true;
            if (MiscUtil.isSameType(obj, obArray[1])) {
                int i2 = 1;
                while (i2 < operands.length) {
                    if (obArray[i2 + 1] != null && !MiscUtil.isSameType(obj, obArray[i2 + 1])) {
                        isSameType = false;
                        break;
                    }
                    ++i2;
                }
            } else {
                isSameType = false;
            }
            if (isSameType) {
                return obArray;
            }
            if (obj instanceof Boolean) {
                MiscUtil.populateObArray(obArray[1], obArray);
            } else {
                MiscUtil.populateObArray(obj, obArray);
            }
            return obArray;
        }

        private static Object[] populateObArray(Object obj, Object[] obArray) {
            try {
                if (obj instanceof Number && !(obj instanceof BigDecimal)) {
                    int i = 0;
                    while (i < obArray.length) {
                        obArray[i] = DataTypeUtil.toDouble((Object)obArray[i]);
                        ++i;
                    }
                } else if (obj instanceof Date) {
                    int i = 0;
                    while (i < obArray.length) {
                        obArray[i] = DataTypeUtil.toSqlDate((Object)obArray[i]);
                        ++i;
                    }
                } else if (obj instanceof Time) {
                    int i = 0;
                    while (i < obArray.length) {
                        obArray[i] = DataTypeUtil.toSqlTime((Object)obArray[i]);
                        ++i;
                    }
                } else if (obj instanceof java.util.Date) {
                    int i = 0;
                    while (i < obArray.length) {
                        obArray[i] = DataTypeUtil.toDate((Object)obArray[i]);
                        ++i;
                    }
                }
            }
            catch (BirtException birtException) {
                try {
                    MiscUtil.makeObjectArrayStringArray(obArray);
                }
                catch (BirtException birtException2) {}
            }
            return obArray;
        }

        private static void makeObjectArrayStringArray(Object[] obArray) throws BirtException {
            int i = 0;
            while (i < obArray.length) {
                if (obArray[i] != null) {
                    obArray[i] = DataTypeUtil.toString((Object)obArray[i]);
                }
                ++i;
            }
        }

        private static IScriptExpression constructValidScriptExpression(IScriptExpression ise) {
            return ise != null && ise.getText().trim().length() > 0 ? ise : new ScriptExpression("null");
        }

        private static Object[] flatternMultipleValues(Object[] values) {
            if (values == null || values.length == 0) {
                return new Object[0];
            }
            ArrayList<Object> flattern = new ArrayList<Object>();
            int i = 0;
            while (i < values.length) {
                if (values[i] instanceof Object[]) {
                    Object[] flatternObj = (Object[])values[i];
                    flattern.addAll(Arrays.asList(MiscUtil.flatternMultipleValues(flatternObj)));
                } else {
                    flattern.add(values[i]);
                }
                ++i;
            }
            return flattern.toArray();
        }
    }
}

