/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt;

import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.ppt.device.PPTPage;
import org.eclipse.birt.report.engine.emitter.ppt.device.PPTPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PPTRender
extends PageDeviceRender {
    private OutputStream pptOutput = null;
    public static final String REPORT_FILE = "Report.ppt";

    public PPTRender(IEmitterServices services) throws EngineException {
        this.initialize(services);
    }

    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) throws Exception {
        try {
            return new PPTPageDevice(this.pptOutput, title, author, description);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String getOutputFormat() {
        return "ppt";
    }

    public void initialize(IEmitterServices services) throws EngineException {
        this.services = services;
        IReportRunnable reportRunnable = services.getReportRunnable();
        if (reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.pptOutput = EmitterUtil.getOuputStream((IEmitterServices)services, (String)REPORT_FILE);
    }

    public void visitImage(IImageArea imageArea) {
        PPTPage pptPage = (PPTPage)this.pageGraphic;
        pptPage.setLink(this.getHyperlink((IArea)imageArea));
        super.visitImage(imageArea);
        pptPage.setLink(null);
    }

    public void visitText(ITextArea textArea) {
        PPTPage pptPage = (PPTPage)this.pageGraphic;
        pptPage.setLink(this.getHyperlink((IArea)textArea));
        super.visitText(textArea);
        pptPage.setLink(null);
    }

    private String getHyperlink(IArea area) {
        IHyperlinkAction hyperlinkAction = area.getAction();
        if (hyperlinkAction != null) {
            try {
                if (hyperlinkAction.getType() != 2) {
                    String link = hyperlinkAction.getHyperlink();
                    Object handler = this.services.getOption("actionHandler");
                    if (handler != null && handler instanceof IHTMLActionHandler) {
                        IHTMLActionHandler actionHandler = (IHTMLActionHandler)handler;
                        String systemId = this.reportRunnable == null ? null : this.reportRunnable.getReportName();
                        Action action = new Action(systemId, hyperlinkAction);
                        link = actionHandler.getURL((IAction)action, this.context);
                    }
                    return link;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getLogicalOrderText(), x, y, width, height, textStyle);
    }
}

