/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.report.model.core.CachedBundles;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleHelper {
    private Module module = null;
    private String baseName = null;

    private BundleHelper(Module module, String baseName) {
        this.module = module;
        this.baseName = baseName;
    }

    public static BundleHelper getHelper(Module module, String baseName) {
        assert (module != null);
        return new BundleHelper(module, baseName);
    }

    public Collection getMessageKeys(ULocale locale) {
        CachedBundles moduleBundle = this.module.getResourceBundle();
        if (moduleBundle == null) {
            moduleBundle = new CachedBundles();
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        List<String> bundleNames = this.getMessageFilenames(locale);
        int i = 0;
        while (i < bundleNames.size()) {
            String tmpName = bundleNames.get(i);
            if (!moduleBundle.isCached(tmpName)) {
                moduleBundle.addCachedBundle(tmpName, this.findBundle(tmpName));
            }
            keys.addAll(moduleBundle.getMessageKeys(tmpName));
            ++i;
        }
        return keys;
    }

    public String getMessage(String resourceKey, ULocale locale) {
        CachedBundles moduleBundle = this.module.getResourceBundle();
        if (moduleBundle == null) {
            moduleBundle = new CachedBundles();
        }
        List<String> bundleNames = this.getMessageFilenames(locale);
        int i = 0;
        while (i < bundleNames.size()) {
            String translation;
            String tmpName = bundleNames.get(i);
            if (!moduleBundle.isCached(tmpName)) {
                moduleBundle.addCachedBundle(tmpName, this.findBundle(tmpName));
            }
            if ((translation = moduleBundle.getMessage(tmpName, resourceKey)) != null) {
                return translation;
            }
            ++i;
        }
        return null;
    }

    public List<String> getMessageFilenames(ULocale locale) {
        StringBuffer temp;
        if (locale == null) {
            locale = ThreadResources.getLocale();
        }
        ArrayList<String> bundleNames = new ArrayList<String>();
        if (this.baseName == null) {
            return bundleNames;
        }
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (languageLength > 0 && countryLength > 0) {
            temp = new StringBuffer(this.baseName);
            temp.append("_");
            temp.append(language);
            temp.append("_");
            temp.append(country);
            StringBuffer variantTmp = new StringBuffer(temp.toString());
            if (variantLength > 0) {
                variantTmp.append("_");
                variantTmp.append(variant);
                variantTmp.append(".properties");
                bundleNames.add(variantTmp.toString());
            }
            temp.append(".properties");
            bundleNames.add(temp.toString());
        }
        if (languageLength > 0) {
            temp = new StringBuffer(this.baseName);
            temp.append("_");
            temp.append(language);
            temp.append(".properties");
            bundleNames.add(temp.toString());
        }
        bundleNames.add(String.valueOf(this.baseName) + ".properties");
        return bundleNames;
    }

    private URL findBundle(String fileName) {
        assert (fileName != null);
        return this.module.findResource(fileName, 0);
    }
}

