/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportItemPropSearchStrategy
extends PropertySearchStrategy {
    private static final ReportItemPropSearchStrategy instance = new ReportItemPropSearchStrategy();
    protected static final Set<String> listingElementDataBindingProps;
    protected static final Set<Integer> listingElementDataBindingPropsNameHash;
    protected static final Set<String> extendedItemDataBindingProps;
    protected static final Set<Integer> extendedItemDataBindingPropsNameHash;
    protected static final Set<String> reportItemDataBindingProps;
    protected static final Set<Integer> reportItemDataBindingPropsNameHash;

    static {
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.add("paramBindings");
        tmpSet.add("boundDataColumns");
        tmpSet.add("dataSet");
        tmpSet.add("cube");
        tmpSet.add("filter");
        tmpSet.add("sort");
        listingElementDataBindingProps = Collections.unmodifiableSet(tmpSet);
        HashSet<Integer> tmpIntegerSet = new HashSet<Integer>();
        tmpIntegerSet.add(new Integer("paramBindings".hashCode()));
        tmpIntegerSet.add(new Integer("boundDataColumns".hashCode()));
        tmpIntegerSet.add(new Integer("dataSet".hashCode()));
        tmpIntegerSet.add(new Integer("cube".hashCode()));
        tmpIntegerSet.add(new Integer("filter".hashCode()));
        tmpIntegerSet.add(new Integer("sort".hashCode()));
        listingElementDataBindingPropsNameHash = Collections.unmodifiableSet(tmpIntegerSet);
        tmpSet = new HashSet();
        tmpSet.add("paramBindings");
        tmpSet.add("boundDataColumns");
        tmpSet.add("dataSet");
        tmpSet.add("cube");
        tmpSet.add("filter");
        extendedItemDataBindingProps = Collections.unmodifiableSet(tmpSet);
        tmpIntegerSet = new HashSet();
        tmpIntegerSet.add(new Integer("paramBindings".hashCode()));
        tmpIntegerSet.add(new Integer("boundDataColumns".hashCode()));
        tmpIntegerSet.add(new Integer("dataSet".hashCode()));
        tmpIntegerSet.add(new Integer("cube".hashCode()));
        tmpIntegerSet.add(new Integer("filter".hashCode()));
        extendedItemDataBindingPropsNameHash = Collections.unmodifiableSet(tmpIntegerSet);
        tmpSet = new HashSet();
        tmpSet.add("paramBindings");
        tmpSet.add("boundDataColumns");
        tmpSet.add("dataSet");
        tmpSet.add("cube");
        reportItemDataBindingProps = Collections.unmodifiableSet(tmpSet);
        tmpIntegerSet = new HashSet();
        tmpIntegerSet.add(new Integer("paramBindings".hashCode()));
        tmpIntegerSet.add(new Integer("boundDataColumns".hashCode()));
        tmpIntegerSet.add(new Integer("dataSet".hashCode()));
        tmpIntegerSet.add(new Integer("cube".hashCode()));
        reportItemDataBindingPropsNameHash = Collections.unmodifiableSet(tmpIntegerSet);
    }

    protected ReportItemPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    @Override
    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (!ReportItemPropSearchStrategy.isDataBindingProperty(element, prop.getName())) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        ElementRefValue refValue = (ElementRefValue)element.getLocalProperty(module, "dataBindingRef");
        if (refValue == null || !refValue.isResolved()) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        return refValue.getElement().getProperty(module, prop);
    }

    public static Set<String> getDataBindingProperties(DesignElement tmpElement) {
        if (tmpElement instanceof ListingElement) {
            return listingElementDataBindingProps;
        }
        if (tmpElement instanceof ExtendedItem) {
            return extendedItemDataBindingProps;
        }
        if (tmpElement instanceof ReportItem) {
            return reportItemDataBindingProps;
        }
        return Collections.emptySet();
    }

    private static Set<Integer> getDataBindingPropertiesNameHash(DesignElement tmpElement) {
        if (tmpElement instanceof ListingElement) {
            return listingElementDataBindingPropsNameHash;
        }
        if (tmpElement instanceof ExtendedItem) {
            return extendedItemDataBindingPropsNameHash;
        }
        if (tmpElement instanceof ReportItem) {
            return reportItemDataBindingPropsNameHash;
        }
        return Collections.emptySet();
    }

    public static boolean isDataBindingProperty(DesignElement element, String propName) {
        if (!(element instanceof ReportItem) || StringUtil.isBlank(propName)) {
            return false;
        }
        return ReportItemPropSearchStrategy.getDataBindingPropertiesNameHash(element).contains(new Integer(propName.hashCode()));
    }
}

