/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableRestrictions {
    public static final String SUB_ELEMENT_VARIABLE_RESTRICTION = "variableRestriction";
    public static final String ATTR_VARIABLE_TYPE = "variableType";
    public static final String ATTR_VARIABLE_TYPE_RESULT_COLUMN = "ResultSetColumn";
    public static final String ATTR_VARIABLE_TYPE_INSTANCE_OF = "InstanceOf";
    public static final String ATTR_VARIABLE_TYPE_QUERY_EXPR = "QueryExpression";
    public static final String SUB_ELEMENT_VARIABLE_RESTRICTION_ODA_DATA_TYPE = "variableOdaDataTypeRestriction";
    public static final String ATTR_RESULT_COLUMN_DATA_TYPE = "odaScalarDataType";
    public static final String SUB_ELEMENT_VARIABLE_RESTRICTION_INSTANCE = "variableClassRestriction";
    public static final String ATTR_RESULT_INSTANCE_TYPE = "class";
    private List<ExpressionVariable.VariableType> m_restrictedVariableTypes;
    private Map<ExpressionVariable.VariableType, List> m_restrictedDataTypesByVarType = new HashMap<ExpressionVariable.VariableType, List>(3);

    VariableRestrictions(IConfigurationElement exprElement) {
        this.m_restrictedVariableTypes = VariableRestrictions.processRestrictedVariableTypes(exprElement, this.m_restrictedDataTypesByVarType);
    }

    private static List<ExpressionVariable.VariableType> processRestrictedVariableTypes(IConfigurationElement exprElement, Map<ExpressionVariable.VariableType, List> restrictedDataTypesByVarType) {
        IConfigurationElement[] varRestrictionElements = exprElement.getChildren(SUB_ELEMENT_VARIABLE_RESTRICTION);
        int arraySize = varRestrictionElements.length;
        if (arraySize == 0) {
            arraySize = 1;
        }
        ArrayList<ExpressionVariable.VariableType> restrictedVariableTypes = new ArrayList<ExpressionVariable.VariableType>(arraySize);
        int i = 0;
        while (i < varRestrictionElements.length) {
            block9: {
                ExpressionVariable.VariableType aRestrictedVarType;
                block6: {
                    String value;
                    block8: {
                        block7: {
                            aRestrictedVarType = ExpressionVariable.VariableType.RESULT_SET_COLUMN;
                            value = varRestrictionElements[i].getAttribute(ATTR_VARIABLE_TYPE);
                            if (value == null || value.length() <= 0) break block6;
                            if (!value.equalsIgnoreCase(ATTR_VARIABLE_TYPE_RESULT_COLUMN)) break block7;
                            aRestrictedVarType = ExpressionVariable.VariableType.RESULT_SET_COLUMN;
                            break block6;
                        }
                        if (!value.equalsIgnoreCase(ATTR_VARIABLE_TYPE_QUERY_EXPR)) break block8;
                        aRestrictedVarType = ExpressionVariable.VariableType.QUERY_EXPRESSION;
                        break block6;
                    }
                    if (!value.equalsIgnoreCase(ATTR_VARIABLE_TYPE_INSTANCE_OF)) break block9;
                    aRestrictedVarType = ExpressionVariable.VariableType.INSTANCE_OF;
                }
                restrictedVariableTypes.add(aRestrictedVarType);
                VariableRestrictions.processRestrictedDataTypes(restrictedDataTypesByVarType, aRestrictedVarType, varRestrictionElements[i]);
            }
            ++i;
        }
        if (restrictedVariableTypes.isEmpty()) {
            restrictedVariableTypes.add(ExpressionVariable.VariableType.RESULT_SET_COLUMN);
        }
        return restrictedVariableTypes;
    }

    private static void processRestrictedDataTypes(Map<ExpressionVariable.VariableType, List> restrictedDataTypesByVarType, ExpressionVariable.VariableType type, IConfigurationElement varRestrictionElement) {
        block6: {
            IConfigurationElement[] dataTypeElements;
            block5: {
                if (type != ExpressionVariable.VariableType.RESULT_SET_COLUMN && type != ExpressionVariable.VariableType.QUERY_EXPRESSION) break block5;
                IConfigurationElement[] dataTypeElements2 = varRestrictionElement.getChildren(SUB_ELEMENT_VARIABLE_RESTRICTION_ODA_DATA_TYPE);
                if (dataTypeElements2.length <= 0) break block6;
                ArrayList<Integer> restrictedDataTypes = new ArrayList<Integer>(dataTypeElements2.length);
                restrictedDataTypesByVarType.put(type, restrictedDataTypes);
                int i = 0;
                while (i < dataTypeElements2.length) {
                    String odaDataTypeLiteral = dataTypeElements2[i].getAttribute(ATTR_RESULT_COLUMN_DATA_TYPE);
                    int odaDataTypeCode = DataTypeMapping.toOdaDataTypeCode(odaDataTypeLiteral);
                    if (odaDataTypeCode != 0) {
                        restrictedDataTypes.add(new Integer(odaDataTypeCode));
                    }
                    ++i;
                }
                break block6;
            }
            if (type == ExpressionVariable.VariableType.INSTANCE_OF && (dataTypeElements = varRestrictionElement.getChildren(SUB_ELEMENT_VARIABLE_RESTRICTION_INSTANCE)).length > 0) {
                ArrayList<String> restrictedClassTypes = new ArrayList<String>(dataTypeElements.length);
                restrictedDataTypesByVarType.put(type, restrictedClassTypes);
                int i = 0;
                while (i < dataTypeElements.length) {
                    String className = dataTypeElements[i].getAttribute(ATTR_RESULT_INSTANCE_TYPE);
                    if (className != null && className.length() != 0) {
                        restrictedClassTypes.add(className);
                    }
                    ++i;
                }
            }
        }
    }

    public boolean supportsVariableType(ExpressionVariable.VariableType type) {
        return this.m_restrictedVariableTypes.contains((Object)type);
    }

    public ExpressionVariable.VariableType[] getRestrictedVariableTypes() {
        return this.m_restrictedVariableTypes.toArray(new ExpressionVariable.VariableType[this.m_restrictedVariableTypes.size()]);
    }

    public boolean hasDataTypeRestrictions(ExpressionVariable.VariableType type) {
        return this.getRestrictedDataTypeList(type).size() > 0;
    }

    public boolean supportsOdaDataType(ExpressionVariable.VariableType type, int odaDataType) {
        if (type == ExpressionVariable.VariableType.INSTANCE_OF) {
            return false;
        }
        if (!this.supportsVariableType(type)) {
            return false;
        }
        if (!this.hasDataTypeRestrictions(type)) {
            return true;
        }
        Iterator iter = this.getRestrictedDataTypeList(type).iterator();
        while (iter.hasNext()) {
            if ((Integer)iter.next() != odaDataType) continue;
            return true;
        }
        return false;
    }

    public boolean supportsClassType(ExpressionVariable.VariableType type, String className) {
        if (type != ExpressionVariable.VariableType.INSTANCE_OF) {
            return false;
        }
        if (!this.supportsVariableType(type)) {
            return false;
        }
        if (!this.hasDataTypeRestrictions(type)) {
            return true;
        }
        Iterator iter = this.getRestrictedDataTypeList(type).iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equalsIgnoreCase(className)) continue;
            return true;
        }
        return false;
    }

    public int[] getResultColumnRestrictedOdaDataTypes() {
        List restrictedDataTypeList = this.getRestrictedDataTypeList(ExpressionVariable.VariableType.RESULT_SET_COLUMN);
        return VariableRestrictions.convertListToArrayInt(restrictedDataTypeList);
    }

    public int[] getQueryExpressionRestrictedOdaDataTypes() {
        List restrictedDataTypeList = this.getRestrictedDataTypeList(ExpressionVariable.VariableType.QUERY_EXPRESSION);
        return VariableRestrictions.convertListToArrayInt(restrictedDataTypeList);
    }

    private static int[] convertListToArrayInt(List<Integer> restrictedDataTypeList) {
        int[] restrictedTypeCodes = new int[restrictedDataTypeList.size()];
        int i = 0;
        while (i < restrictedDataTypeList.size()) {
            restrictedTypeCodes[i] = restrictedDataTypeList.get(i);
            ++i;
        }
        return restrictedTypeCodes;
    }

    public String[] getInstanceRestrictedTypes() {
        List restrictedDataTypeList = this.getRestrictedDataTypeList(ExpressionVariable.VariableType.INSTANCE_OF);
        return restrictedDataTypeList.toArray(new String[restrictedDataTypeList.size()]);
    }

    private List getRestrictedDataTypeList(ExpressionVariable.VariableType type) {
        ArrayList restrictedDataTypes;
        if (this.m_restrictedDataTypesByVarType == null) {
            this.m_restrictedDataTypesByVarType = new HashMap<ExpressionVariable.VariableType, List>();
        }
        if ((restrictedDataTypes = this.m_restrictedDataTypesByVarType.get((Object)type)) == null) {
            restrictedDataTypes = type == ExpressionVariable.VariableType.RESULT_SET_COLUMN ? new ArrayList() : (type == ExpressionVariable.VariableType.QUERY_EXPRESSION ? new ArrayList() : new ArrayList());
            this.m_restrictedDataTypesByVarType.put(type, restrictedDataTypes);
        }
        return restrictedDataTypes;
    }
}

