/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class ManifestUtil {
    public static IConfigurationElement getNamedElement(IExtension extension, String elementName) throws OdaException {
        return ManifestUtil.getNamedElement(extension, elementName, null);
    }

    public static IConfigurationElement getNamedElement(IExtension extension, String elementName, String requiredAttributeName) throws OdaException {
        IConfigurationElement[] configElements = ManifestUtil.getNamedElements(extension, elementName, requiredAttributeName);
        if (configElements.length == 0) {
            throw new OdaException(Messages.bind((String)Messages.manifest_MISSING_ELEMENT_IN_EXTENSION_MANIFEST, (Object)extension.getUniqueIdentifier(), (Object)elementName));
        }
        return configElements[0];
    }

    public static IConfigurationElement[] getNamedElements(IExtension extension, String elementName) throws OdaException {
        return ManifestUtil.getNamedElements(extension, elementName, null);
    }

    public static IConfigurationElement[] getNamedElements(IExtension extension, String elementName, String requiredAttributeName) throws OdaException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        ArrayList<IConfigurationElement> matchedElements = new ArrayList<IConfigurationElement>();
        int i = 0;
        int n = configElements.length;
        while (i < n) {
            IConfigurationElement configElement = configElements[i];
            if (configElement.getName().equalsIgnoreCase(elementName)) {
                String attrValue;
                if (requiredAttributeName != null && ((attrValue = configElement.getAttribute(requiredAttributeName)) == null || attrValue.length() == 0)) {
                    throw new OdaException(Messages.bind((String)Messages.manifest_NO_ATTRIBUTE_ID_DEFINED, (Object)requiredAttributeName, (Object)elementName));
                }
                matchedElements.add(configElement);
            }
            ++i;
        }
        return matchedElements.toArray(new IConfigurationElement[matchedElements.size()]);
    }

    public static Property[] getVisiblePropertiesDefn(Property[] driverDefinedProps, Properties propertiesVisibility) {
        if (driverDefinedProps.length == 0) {
            return driverDefinedProps;
        }
        ArrayList<Property> visibleProps = new ArrayList<Property>();
        int i = 0;
        int size = driverDefinedProps.length;
        while (i < size) {
            Property aProp = driverDefinedProps[i];
            if (aProp.isVisible(propertiesVisibility)) {
                visibleProps.add(aProp);
            }
            ++i;
        }
        return visibleProps.toArray(new Property[visibleProps.size()]);
    }

    public static Property[] getHiddenPropertiesDefn(Property[] driverDefinedProps, Properties propertiesVisibility) {
        if (driverDefinedProps.length == 0) {
            return driverDefinedProps;
        }
        ArrayList<Property> hiddenProps = new ArrayList<Property>();
        int i = 0;
        int size = driverDefinedProps.length;
        while (i < size) {
            Property aProp = driverDefinedProps[i];
            if (!aProp.isVisible(propertiesVisibility)) {
                hiddenProps.add(aProp);
            }
            ++i;
        }
        return hiddenProps.toArray(new Property[hiddenProps.size()]);
    }
}

