/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;

public class ValidationContext {
    private static final String NAMESPACE = ValidationContext.class.getName();
    public static final String DATA_PROPERTY_QUERY_TEXT = String.valueOf(NAMESPACE) + ".QueryTextProp";
    public static final String DATA_PROPERTY_CONN_PROFILE = String.valueOf(NAMESPACE) + ".ConnProfileProp";
    private ExtensionContributor m_contributor;
    private IValidator m_validator;
    private Map<String, Object> m_customData;

    public ValidationContext(ExtensionContributor contributor) {
        this.m_contributor = contributor;
    }

    public ValidationContext(IValidator validator) {
        this.m_validator = validator;
    }

    public ExtensionContributor getContributor() {
        return this.m_contributor;
    }

    public IValidator getValidator() {
        if (this.m_validator != null) {
            return this.m_validator;
        }
        if (this.m_contributor != null) {
            try {
                this.m_validator = this.m_contributor.getValidator();
                return this.m_validator;
            }
            catch (OdaException odaException) {}
        }
        return null;
    }

    public void setValidator(IValidator validator) {
        this.m_validator = validator;
    }

    public Object getData(String key) {
        if (this.m_customData == null) {
            return null;
        }
        return this.m_customData.get(key);
    }

    public void setData(String key, Object value) {
        if (this.m_customData == null) {
            this.m_customData = new HashMap<String, Object>();
        }
        this.m_customData.put(key, value);
    }
}

