/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;

public class DataTypeMapping {
    private static Hashtable sm_odaTypeCodes;
    private int m_nativeTypeCode;
    private String m_nativeType;
    private String m_odaScalarType;
    private String[] m_alternativeDataTypes;
    private int[] m_alternativeDataTypeCodes;

    DataTypeMapping(IConfigurationElement dataTypeMapping, String dataSetTypeName) throws OdaException {
        this.m_nativeType = dataTypeMapping.getAttribute("nativeDataType");
        if (this.m_nativeType == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_NATIVE_TYPE_NAME_DEFINED, (Object)dataSetTypeName));
        }
        String nativeDataTypeCode = dataTypeMapping.getAttribute("nativeDataTypeCode");
        if (nativeDataTypeCode == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_NATIVE_TYPE_CODE_DEFINED, (Object)this.m_nativeType, (Object)dataSetTypeName));
        }
        try {
            this.m_nativeTypeCode = Integer.parseInt(nativeDataTypeCode);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OdaException(Messages.bind((String)Messages.manifest_INVALID_NATIVE_TYPE_CODE_VALUE, (Object[])new Object[]{this.m_nativeType, nativeDataTypeCode, dataSetTypeName}));
        }
        this.m_odaScalarType = dataTypeMapping.getAttribute("odaScalarDataType");
        this.sanityCheckOdaScalarType(this.m_odaScalarType, false);
        IConfigurationElement[] alternativeDataTypes = dataTypeMapping.getChildren("alternativeOdaDataType");
        int length = alternativeDataTypes.length;
        this.m_alternativeDataTypes = new String[length];
        int i = 0;
        while (i < length) {
            this.m_alternativeDataTypes[i] = alternativeDataTypes[i].getAttribute("odaScalarDataType");
            this.sanityCheckOdaScalarType(this.m_alternativeDataTypes[i], true);
            ++i;
        }
    }

    protected DataTypeMapping(int nativeTypeCode, String nativeType, String odaScalarType, String[] alternativeDataTypes) {
        this.m_nativeTypeCode = nativeTypeCode;
        this.m_nativeType = nativeType;
        this.m_odaScalarType = odaScalarType;
        this.m_alternativeDataTypes = alternativeDataTypes;
    }

    private void sanityCheckOdaScalarType(String odaScalarType, boolean isForAlternatives) throws OdaException {
        if (odaScalarType == null) {
            throw new OdaException(isForAlternatives ? Messages.bind((String)Messages.manifest_NO_ODA_SCALAR_DATA_TYPE_DEFINED_2, (Object)this.m_nativeType) : Messages.bind((String)Messages.manifest_NO_ODA_SCALAR_DATA_TYPE_DEFINED_1, (Object)this.m_nativeType));
        }
        if (!DataTypeMapping.getOdaTypeCodes().containsKey(DataTypeMapping.toOdaTypeKey(odaScalarType))) {
            throw new OdaException(Messages.bind((String)Messages.manifest_INVALID_ODA_SCALAR_DATA_TYPE_VALUE, (Object)odaScalarType, (Object)this.m_nativeType));
        }
    }

    public String getNativeType() {
        return this.m_nativeType;
    }

    public int getNativeTypeCode() {
        return this.m_nativeTypeCode;
    }

    public String getOdaScalarDataType() {
        return this.m_odaScalarType;
    }

    public int getOdaScalarDataTypeCode() {
        return DataTypeMapping.toOdaDataTypeCode(this.m_odaScalarType);
    }

    public String[] getAlternativeOdaDataTypes() {
        return this.m_alternativeDataTypes;
    }

    public int[] getAlternativeOdaDataTypeCodes() {
        if (this.m_alternativeDataTypeCodes == null) {
            int numCodes = this.m_alternativeDataTypes.length;
            this.m_alternativeDataTypeCodes = new int[numCodes];
            int i = 0;
            while (i < numCodes) {
                this.m_alternativeDataTypeCodes[i] = DataTypeMapping.toOdaDataTypeCode(this.m_alternativeDataTypes[i]);
                ++i;
            }
        }
        return this.m_alternativeDataTypeCodes;
    }

    public boolean canConvertToOdaType(int odaDataTypeCode) {
        if (odaDataTypeCode == this.getOdaScalarDataTypeCode()) {
            return true;
        }
        int[] alternateOdaTypes = this.getAlternativeOdaDataTypeCodes();
        int i = 0;
        while (i < alternateOdaTypes.length) {
            if (odaDataTypeCode == alternateOdaTypes[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int toOdaDataTypeCode(String odaDataTypeLiteral) {
        if (odaDataTypeLiteral == null || odaDataTypeLiteral.length() == 0) {
            return 0;
        }
        Object typeCode = DataTypeMapping.getOdaTypeCodes().get(DataTypeMapping.toOdaTypeKey(odaDataTypeLiteral));
        if (typeCode != null) {
            return (Integer)typeCode;
        }
        return 0;
    }

    private static Hashtable getOdaTypeCodes() {
        if (sm_odaTypeCodes == null) {
            sm_odaTypeCodes = new Hashtable(10);
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("String"), new Integer(1));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Integer"), new Integer(4));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Double"), new Integer(8));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Decimal"), new Integer(3));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Date"), new Integer(91));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Time"), new Integer(92));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Timestamp"), new Integer(93));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Blob"), new Integer(2004));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Clob"), new Integer(2005));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("Boolean"), new Integer(16));
            sm_odaTypeCodes.put(DataTypeMapping.toOdaTypeKey("JavaObject"), new Integer(2000));
        }
        return sm_odaTypeCodes;
    }

    private static String toOdaTypeKey(String odaDataTypeLiteral) {
        assert (odaDataTypeLiteral != null);
        return odaDataTypeLiteral.toLowerCase(Locale.US);
    }
}

