/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.engine.adapter.ITotalExprBindings;
import org.eclipse.birt.report.engine.adapter.ParseIndicator;
import org.eclipse.birt.report.engine.adapter.TotalExprBinding;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.ir.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionUtil {
    private static final String TOTAL_PREFIX = "TOTAL_COLUMN_";
    private int totalColumnSuffix = 0;

    public ITotalExprBindings prepareTotalExpressions(List<Expression> exprs, IDataQueryDefinition queryDefn) throws EngineException {
        return this.prepareTotalExpressions(exprs, null, queryDefn);
    }

    public ITotalExprBindings prepareTotalExpressions(List<Expression> exprs, String groupName, IDataQueryDefinition queryDefn) throws EngineException {
        TotalExprBinding result = new TotalExprBinding();
        ArrayList l = new ArrayList();
        boolean isCube = false;
        if (queryDefn instanceof IBaseCubeQueryDefinition) {
            isCube = true;
        }
        int i = 0;
        while (i < exprs.size()) {
            Expression expr = exprs.get(i);
            result.addColumnBindings(l);
            if (expr == null) {
                result.addNewExpression(null);
            } else {
                switch (expr.getType()) {
                    case 0: {
                        result.addNewExpression(expr);
                        break;
                    }
                    case 1: {
                        String newExpr = this.prepareTotalExpression(expr.getScriptText(), l, groupName, isCube);
                        result.addColumnBindings(l);
                        expr.setScriptText(newExpr);
                        result.addNewExpression(expr);
                        break;
                    }
                    case 2: {
                        this.addConditionalExprBindings(result, (Expression.Conditional)expr, l, groupName, isCube);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid expression type:" + expr.getType());
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static IConditionalExpression transformConditionalExpression(IConditionalExpression ce) {
        String prefix = null;
        switch (ce.getOperator()) {
            case 14: {
                prefix = "Total.isTopN";
                break;
            }
            case 16: {
                prefix = "Total.isTopNPercent";
                break;
            }
            case 15: {
                prefix = "Total.isBottomN";
                break;
            }
            case 17: {
                prefix = "Total.isBottomNPercent";
            }
        }
        if (prefix != null) {
            ce = new ConditionalExpression(String.valueOf(prefix) + "(" + ce.getExpression().getText() + "," + ((IScriptExpression)ce.getOperand1()).getText() + ")", 11);
        }
        return ce;
    }

    private void addConditionalExprBindings(TotalExprBinding result, Expression.Conditional key, List bindings, String groupName, boolean isCube) throws EngineException {
        try {
            IConditionalExpression ce = key.getConditionalExpression();
            if (!this.hasAggregationInFilter((IBaseExpression)ce)) {
                result.addNewExpression(key);
                return;
            }
            if (groupName != null) {
                ce.setGroupName(groupName);
            }
            String bindingName = TOTAL_PREFIX + this.totalColumnSuffix;
            ++this.totalColumnSuffix;
            Binding columnBinding = new Binding(bindingName, (IBaseExpression)ce);
            if (groupName != null) {
                columnBinding.addAggregateOn(groupName);
            }
            ArrayList<Binding> allColumnBindings = new ArrayList<Binding>();
            allColumnBindings.add(columnBinding);
            result.addColumnBindings(allColumnBindings);
            if (!isCube) {
                String script = org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)bindingName);
                result.addNewExpression(Expression.newScript(script));
            } else {
                String script = org.eclipse.birt.core.data.ExpressionUtil.createJSDataExpression((String)bindingName);
                result.addNewExpression(Expression.newScript(script));
            }
        }
        catch (DataException e) {
            throw new EngineException((BirtException)e);
        }
    }

    private boolean hasAggregationInFilter(IBaseExpression expr) {
        if (expr == null) {
            return false;
        }
        if (expr instanceof IScriptExpression) {
            return org.eclipse.birt.core.data.ExpressionUtil.hasAggregation((String)((ScriptExpression)expr).getText());
        }
        if (expr instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)expr;
            if (this.hasAggregationInFilter((IBaseExpression)ce.getExpression())) {
                return true;
            }
            if (this.hasAggregationInFilter(ce.getOperand1())) {
                return true;
            }
            if (this.hasAggregationInFilter(ce.getOperand2())) {
                return true;
            }
        }
        return false;
    }

    private String prepareTotalExpression(String oldExpression, List columnBindings, String groupName, boolean isCube) throws EngineException {
        block11: {
            if (oldExpression != null) break block11;
            return null;
        }
        try {
            char[] chars = oldExpression.toCharArray();
            if (chars.length < 8) {
                return oldExpression;
            }
            ParseIndicator indicator = new ParseIndicator(0, 0, false, false, true, true);
            int i = 0;
            while (i < chars.length) {
                if ((i = (indicator = ExpressionUtil.getParseIndicator(chars, i, indicator.omitNextQuote(), indicator.getCandidateKey1(), indicator.getCandidateKey2())).getNewIndex()) >= indicator.getRetrieveSize() + 6 && indicator.isCandidateKey() && chars[i - indicator.getRetrieveSize() - 6] == 'T' && chars[i - indicator.getRetrieveSize() - 5] == 'o' && chars[i - indicator.getRetrieveSize() - 4] == 't' && chars[i - indicator.getRetrieveSize() - 3] == 'a' && chars[i - indicator.getRetrieveSize() - 2] == 'l' && chars[i - indicator.getRetrieveSize() - 1] == '.' && (i - indicator.getRetrieveSize() - 7 <= 0 || ExpressionUtil.isValidProceeding(chars[i - indicator.getRetrieveSize() - 7]))) {
                    String firstPart = oldExpression.substring(0, i - indicator.getRetrieveSize() - 6);
                    int startIndex = i - indicator.getRetrieveSize() - 6;
                    i = ExpressionUtil.advanceToNextValidEncloser(chars, i);
                    String secondPart = "";
                    String name = "";
                    String expr = "";
                    if (i < chars.length) {
                        int endIndex = i + 1;
                        expr = oldExpression.substring(startIndex, endIndex);
                        secondPart = this.prepareTotalExpression(oldExpression.substring(i + 1 - indicator.getRetrieveSize()), columnBindings, groupName, isCube);
                    } else {
                        expr = oldExpression.substring(startIndex);
                    }
                    boolean shouldAddToList = true;
                    int j = 0;
                    while (j < columnBindings.size()) {
                        IBaseExpression expression = ((IBinding)columnBindings.get(j)).getExpression();
                        if (expression instanceof IScriptExpression && oldExpression.equals(((IScriptExpression)expression).getText())) {
                            shouldAddToList = false;
                            name = ((IBinding)columnBindings.get(j)).getBindingName();
                            break;
                        }
                        ++j;
                    }
                    if (shouldAddToList) {
                        name = TOTAL_PREFIX + this.totalColumnSuffix;
                        ++this.totalColumnSuffix;
                        ScriptExpression se = new ScriptExpression(expr);
                        se.setGroupName(groupName);
                        Binding columnBinding = new Binding(name, (IBaseExpression)se);
                        columnBindings.add(columnBinding);
                    }
                    String newExpression = null;
                    newExpression = !isCube ? String.valueOf(firstPart) + org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)name) + secondPart : String.valueOf(firstPart) + org.eclipse.birt.core.data.ExpressionUtil.createJSDataExpression((String)name) + secondPart;
                    return newExpression;
                }
                ++i;
            }
            return oldExpression;
        }
        catch (DataException e) {
            throw new EngineException((BirtException)e);
        }
    }

    private static int advanceToNextValidEncloser(char[] chars, int i) {
        boolean isTotalConstants = true;
        int numberOfOpenBracket = 0;
        while (i < chars.length) {
            ParseIndicator pid = ExpressionUtil.getParseIndicator(chars, i, false, true, true);
            i = pid.getNewIndex();
            if (pid.isCandidateKey() && chars[i] == '(') {
                isTotalConstants = false;
                ++numberOfOpenBracket;
            }
            if (isTotalConstants) {
                if (ExpressionUtil.isValidProceeding(chars[i])) break;
                ++i;
                continue;
            }
            if (chars[i] != ')') {
                ++i;
                continue;
            }
            if (chars[i] == ')') {
                --numberOfOpenBracket;
            }
            if (numberOfOpenBracket == 0) break;
            ++i;
        }
        if (isTotalConstants) {
            --i;
        }
        return i;
    }

    private static ParseIndicator getParseIndicator(char[] chars, int i, boolean omitNextQuote, boolean candidateKey1, boolean candidateKey2) {
        int retrieveSize = 0;
        if (chars[i] == '/') {
            if (i > 0 && chars[i - 1] == '/') {
                ++retrieveSize;
                while (i < chars.length - 2) {
                    ++retrieveSize;
                    if (chars[++i] == '\n') break;
                }
                ++retrieveSize;
                ++i;
            }
        } else if (chars[i] == '*' && i > 0 && chars[i - 1] == '/') {
            ++i;
            retrieveSize += 2;
            while (i < chars.length - 2) {
                ++retrieveSize;
                if (chars[++i - 1] == '*' && chars[i] == '/') break;
            }
            ++retrieveSize;
            ++i;
        }
        if (!omitNextQuote && chars[i] == '\"') {
            boolean bl = candidateKey1 = !candidateKey1;
            if (candidateKey1) {
                candidateKey2 = true;
            }
        }
        if (!omitNextQuote && chars[i] == '\'') {
            boolean bl = candidateKey2 = !candidateKey2;
            if (candidateKey2) {
                candidateKey1 = true;
            }
        }
        omitNextQuote = chars[i] == '\\';
        return new ParseIndicator(retrieveSize, i, candidateKey1, omitNextQuote, candidateKey1, candidateKey2);
    }

    private static boolean isValidProceeding(char operator) {
        return !(operator >= 'A' && operator <= 'Z' || operator >= 'a' && operator <= 'z') && operator != '_';
    }

    public IConditionalExpression createConditionalExpression(Expression testExpression, String operator, Expression value1, Expression value2) {
        String tempV1 = null;
        String tempV2 = null;
        if (value1 != null) {
            tempV1 = value1.getScriptText();
        }
        if (value2 != null) {
            tempV2 = value2.getScriptText();
        }
        ConditionalExpression expression = new ConditionalExpression(testExpression.getScriptText(), DataAdapterUtil.adaptModelFilterOperator((String)operator), tempV1, tempV2);
        return ExpressionUtil.transformConditionalExpression((IConditionalExpression)expression);
    }

    public IConditionalExpression createConditionExpression(Expression testExpression, String operator, List<Expression> valueList) {
        ArrayList<String> values = new ArrayList<String>(valueList.size());
        for (Expression expr : valueList) {
            values.add(expr.getScriptText());
        }
        ConditionalExpression expression = new ConditionalExpression(testExpression.getScriptText(), DataAdapterUtil.adaptModelFilterOperator((String)operator), values);
        return ExpressionUtil.transformConditionalExpression((IConditionalExpression)expression);
    }
}

