/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.QueryTask;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.engine.IDataExtension;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtil {
    public static List<IBaseResultSet> getResultSet(ReportContent report, InstanceID instanceID) {
        Report design = report.getDesign();
        ExecutionContext context = report.getExecutionContext();
        try {
            ArrayList<QueryTask> plan = QueryUtil.createPlan(design, instanceID);
            return QueryUtil.executePlan(context, plan);
        }
        catch (EngineException ex) {
            context.addException(ex);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ArrayList<QueryTask> createPlan(Report report, InstanceID instanceId) throws EngineException {
        iid = instanceId;
        query = null;
        while (iid != null) {
            id = iid.getComponentID();
            design = (ReportItemDesign)report.getReportItemByID(id);
            dataQuery = design.getQuery();
            if (dataQuery != null) {
                handle = (ReportItemHandle)design.getHandle();
                if (!handle.allowExport()) {
                    throw new EngineException("Error.ResultsetExtractError");
                }
                if (!(dataQuery instanceof IBaseQueryDefinition)) {
                    return null;
                }
                query = (IBaseQueryDefinition)dataQuery;
                break;
            }
            iid = iid.getParentID();
        }
        dsIDs = new ArrayList<DataSetID>();
        plan = new ArrayList<QueryTask>();
        ** GOTO lbl42
        {
            block7: {
                if (iid.getDataID() == null) break block7;
                dataId = iid.getDataID();
                dsId = dataId.getDataSetID();
                found = false;
                itr = dsIDs.iterator();
                while (itr.hasNext()) {
                    if (!((DataSetID)itr.next()).equals(dsId)) continue;
                    found = true;
                    break;
                }
                if (found) break block7;
                dsIDs.add(dsId);
                task = new QueryTask(query, dsId, (int)dataId.getRowID(), iid);
                plan.add(task);
                ** GOTO lbl40
            }
            iid = iid.getParentID();
            do {
                if (iid != null) continue block1;
lbl40:
                // 2 sources

                if (iid == null) break block1;
                query = query.getParentQuery();
lbl42:
                // 2 sources

            } while (query != null);
        }
        task = new QueryTask(query, null, -1, null);
        plan.add(task);
        return plan;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List executePlan(ExecutionContext executionContext, ArrayList<QueryTask> plan) throws EngineException {
        if (plan == null || plan.size() == 0) {
            return null;
        }
        ArrayList<QueryResultSet> results = new ArrayList<QueryResultSet>();
        QueryResultSet parent = null;
        try {
            int current = plan.size() - 1;
            while (current >= 0) {
                if (parent != null) {
                    results.add(parent);
                }
                QueryTask task = plan.get(current);
                IBaseQueryDefinition query = task.query;
                if (task.parent == null) {
                    IQueryResults qryRS = QueryUtil.executeQuery(null, (QueryDefinition)query, executionContext);
                    if (qryRS == null) {
                        return null;
                    }
                    parent = new QueryResultSet(executionContext.getDataEngine(), executionContext, (IQueryDefinition)query, qryRS);
                } else {
                    if (parent == null) {
                        throw new EngineException("Error.ResultsetExtractError");
                    }
                    IResultIterator parentItr = parent.getResultIterator();
                    parentItr.moveTo(task.rowId);
                    if (query instanceof IQueryDefinition) {
                        IQueryResults qryRS = QueryUtil.executeQuery(null, (QueryDefinition)query, executionContext);
                        if (qryRS == null) {
                            return null;
                        }
                        parent = new QueryResultSet(executionContext.getDataEngine(), executionContext, parent, (IQueryDefinition)query, qryRS);
                    } else {
                        if (!(query instanceof ISubqueryDefinition)) {
                            return null;
                        }
                        String queryName = query.getName();
                        Scriptable scope = executionContext.getSharedScope();
                        IResultIterator itr2 = parentItr.getSecondaryIterator(queryName, scope);
                        parent = new QueryResultSet(parent, (ISubqueryDefinition)query, itr2);
                    }
                }
                --current;
            }
        }
        catch (EngineException ex) {
            throw ex;
        }
        catch (BirtException ex) {
            throw new EngineException(ex);
        }
        if (parent != null && !results.contains(parent)) {
            results.add(parent);
        }
        return results;
    }

    public static void processQueryExtensions(IDataQueryDefinition query, ExecutionContext executionContext) throws EngineException {
        String[] extensions = executionContext.getEngineExtensions();
        if (extensions != null) {
            EngineExtensionManager manager = executionContext.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionName = stringArray[n2];
                IDataExtension extension = manager.getDataExtension(extensionName);
                if (extension != null) {
                    extension.prepareQuery(query);
                }
                ++n2;
            }
        }
    }

    public static IQueryResults executeQuery(String rset, QueryDefinition query, ExecutionContext executionContext) throws EngineException {
        IPreparedQuery pQuery;
        Scriptable scope;
        block5: {
            Map appContext;
            DataRequestSession dataSession;
            block4: {
                try {
                    query.setQueryResultsID(rset);
                    dataSession = executionContext.getDataEngine().getDTESession();
                    scope = executionContext.getSharedScope();
                    appContext = executionContext.getAppContext();
                    QueryUtil.processQueryExtensions((IDataQueryDefinition)query, executionContext);
                    if (dataSession != null) break block4;
                    return null;
                }
                catch (BirtException ex) {
                    throw new EngineException(ex);
                }
            }
            pQuery = dataSession.prepare((IQueryDefinition)query, appContext);
            if (pQuery != null) break block5;
            return null;
        }
        return pQuery.execute(scope);
    }
}

