/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.api.script.element.IReportDesign;
import org.eclipse.birt.report.engine.script.internal.element.ReportDesign;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.mozilla.javascript.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportRunnable
implements IReportRunnable {
    protected ReportDesignHandle designHandle;
    protected String reportName;
    protected boolean prepared = false;
    protected IReportEngine engine = null;
    protected Hashtable<String, Script> cachedScripts = new Hashtable();

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public Map<String, Script> getScriptCache() {
        return this.cachedScripts;
    }

    public Script getScript(String source) {
        return this.cachedScripts.get(source);
    }

    public void putScript(String source, Script script) {
        this.cachedScripts.put(source, script);
    }

    ReportRunnable(ReportDesignHandle designHandle) {
        this.designHandle = designHandle;
    }

    public void setReportName(String name) {
        this.reportName = name;
    }

    @Override
    public String getReportName() {
        return this.reportName;
    }

    public ReportDesignHandle getReport() {
        return this.designHandle;
    }

    @Override
    public IImage getImage(String name) {
        EmbeddedImage embeddedImage = this.designHandle.findImage(name);
        if (embeddedImage != null) {
            Image image = new Image(embeddedImage.getData(this.designHandle.getModule()), name);
            image.setReportRunnable(this);
            return image;
        }
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        FactoryPropertyHandle handle = this.getDesignHandle().getFactoryPropertyHandle(propertyName);
        if (handle != null) {
            return handle.getStringValue();
        }
        return null;
    }

    @Override
    public Object getProperty(String path, String propertyName) {
        return null;
    }

    @Override
    public DesignElementHandle getDesignHandle() {
        return this.designHandle;
    }

    @Override
    public HashMap getTestConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        Iterator iter = this.designHandle.configVariablesIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                ConfigVariableHandle handle = (ConfigVariableHandle)iter.next();
                String name = handle.getName();
                String value = handle.getValue();
                configs.put(name, value);
            }
        }
        return configs;
    }

    @Override
    public IReportEngine getReportEngine() {
        return this.engine;
    }

    public void setReportEngine(IReportEngine engine) {
        this.engine = engine;
    }

    @Override
    public void setDesignHandle(ReportDesignHandle handle) {
        this.designHandle = handle;
    }

    @Override
    public IReportDesign getDesignInstance() {
        ReportDesign design = new ReportDesign(this.designHandle);
        return design;
    }

    public ReportRunnable cloneRunnable() {
        ReportDesignHandle newDesign = (ReportDesignHandle)this.designHandle.copy().getHandle(null);
        newDesign.setFileName(this.designHandle.getFileName());
        ReportRunnable newRunnable = new ReportRunnable(newDesign);
        newRunnable.setReportName(this.reportName);
        newRunnable.setReportEngine(this.engine);
        return newRunnable;
    }
}

