/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.util.logging.Level;
import org.eclipse.birt.report.engine.emitter.XMLEncodeUtil;

public class HTMLEncodeUtil
extends XMLEncodeUtil {
    static char[] HTML_TEXT_ENCODING = new char[]{'&', '<'};
    static char[] HTML_WHITE_SPACE_ENCODING = new char[]{'&', '<', ' ', '\t', '\r', '\n'};
    static final String ESCAPE_BR = "<br>";
    static final String ESCAPE_NBSP = "&#xa0;";
    static final String ESCAPE_AMP = "&amp;";
    static final String ESCAPE_LT = "&lt;";

    public static String encodeText(String text, boolean whitespace) {
        char[] chars = text.toCharArray();
        int length = chars.length;
        int index = HTMLEncodeUtil.testEscape(chars, whitespace ? HTML_WHITE_SPACE_ENCODING : HTML_TEXT_ENCODING);
        if (index >= length) {
            return text;
        }
        StringBuilder sb = new StringBuilder(length * 2);
        sb.append(chars, 0, index);
        while (index < length) {
            char c;
            if (Character.isHighSurrogate(c = chars[index++])) {
                index += HTMLEncodeUtil.decodeSurrogate(c, chars, index, sb);
                continue;
            }
            if (HTMLEncodeUtil.isValidCodePoint(c)) {
                if (c == '&') {
                    sb.append(ESCAPE_AMP);
                    continue;
                }
                if (c == '<') {
                    sb.append(ESCAPE_LT);
                    continue;
                }
                if (c == '\r' || c == '\n') {
                    if (whitespace) {
                        index += HTMLEncodeUtil.encodeLineBreak(c, chars, index, sb);
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == ' ' || c == '\t') {
                    if (whitespace) {
                        index += HTMLEncodeUtil.encodeWhitespace(c, chars, index, sb);
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            logger.log(Level.WARNING, "Invalid XML character:0x{0}", c);
        }
        return sb.toString();
    }

    public static int encodeWhitespace(char c1, char[] chars, int offset, StringBuilder sb) {
        boolean isFirstLine = offset == 1;
        int index = offset;
        while (index < chars.length) {
            char nc;
            if ((nc = chars[index++]) == ' ' || nc == '\t') {
                sb.append(ESCAPE_NBSP);
                continue;
            }
            if (nc == '\r' || nc == '\n') {
                sb.append(ESCAPE_NBSP);
                return index - offset - 1;
            }
            if (isFirstLine) {
                sb.append(ESCAPE_NBSP);
            } else {
                sb.append(' ');
            }
            return index - offset - 1;
        }
        sb.append(ESCAPE_NBSP);
        return index - offset;
    }

    static int encodeLineBreak(char c, char[] chars, int offset, StringBuilder sb) {
        char nc;
        int index = offset;
        if (c == '\r' && index < chars.length && chars[index] == '\n') {
            ++index;
        }
        sb.append(ESCAPE_BR);
        if (index >= chars.length) {
            return index - offset;
        }
        if ((nc = chars[index++]) != ' ' && nc != '\t') {
            return index - offset - 1;
        }
        sb.append(ESCAPE_NBSP);
        while (index < chars.length) {
            if ((nc = chars[index++]) == ' ' || nc == '\t') {
                if (index >= chars.length) {
                    sb.append(ESCAPE_NBSP);
                    return index - offset;
                }
                char nnc = chars[index];
                if (nnc == ' ' || nnc == '\t') {
                    sb.append(ESCAPE_NBSP);
                    continue;
                }
                if (nnc == '\r' || nnc == '\n') {
                    sb.append(ESCAPE_NBSP);
                } else {
                    sb.append(' ');
                }
                return index - offset;
            }
            return index - offset - 1;
        }
        return index - offset;
    }
}

