/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import org.eclipse.birt.report.engine.emitter.HTMLEncodeUtil;
import org.eclipse.birt.report.engine.emitter.XMLWriter;

public class HTMLWriter
extends XMLWriter {
    public HTMLWriter() {
        this.bImplicitCloseTag = false;
    }

    public void closeTag(String tagName) {
        if (tagName == null) {
            return;
        }
        super.closeTag(tagName);
    }

    public void closeNoEndTag() {
        --this.indentCount;
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
        } else assert (false);
        this.bPairedFlag = true;
    }

    public void style(String name, String value) {
        assert (name != null && name.length() > 0);
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        if (this.bIndent) {
            ++this.indentCount;
            this.printWriter.println();
            this.printWriter.print(super.indent());
            --this.indentCount;
        }
        this.printWriter.print(name);
        this.printWriter.print(" {");
        this.printWriter.print(value);
        this.printWriter.print('}');
    }

    public void writeCode(String code) {
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        if (this.bIndent) {
            this.printWriter.println();
            this.printWriter.print(super.indent());
        }
        this.printWriter.print(code);
    }

    public void outputDoctype() {
        this.printWriter.print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
    }

    public void comment(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        this.printWriter.print("<!--");
        this.printWriter.print(HTMLEncodeUtil.encodeCdata(value));
        this.printWriter.print("-->");
        this.bText = true;
    }

    public void text(String value) {
        this.text(value, true);
    }

    public void text(String value, boolean whitespace) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        String stringToPrint = HTMLEncodeUtil.encodeText(value, whitespace);
        this.printWriter.print(stringToPrint);
        this.bText = true;
    }

    protected String encodeText(String text) {
        return HTMLEncodeUtil.encodeText(text, false);
    }

    protected String encodeText(String text, boolean whitespace) {
        return HTMLEncodeUtil.encodeText(text, whitespace);
    }
}

