/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.PageBandExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.toc.TOCBuilder;

public class MasterPageExecutor
extends ReportItemExecutor {
    MasterPageDesign masterPage;
    long pageNumber;
    TOCBuilder tocBuilder;
    int nextBand;
    static final int HEADER_BAND = 0;
    static final int BODY_BAND = 1;
    static final int FOOTER_BAND = 2;

    public MasterPageExecutor(ExecutorManager manager, long pageNumber, MasterPageDesign masterPage) {
        super(manager, -1);
        this.pageNumber = pageNumber;
        this.masterPage = masterPage;
        this.nextBand = 0;
    }

    public IContent execute() {
        this.context.setPageNumber(this.pageNumber);
        this.tocBuilder = this.context.getTOCBuilder();
        this.context.setTOCBuilder(null);
        this.context.setExecutingMasterPage(true);
        IPageContent pageContent = this.report.createPageContent();
        pageContent.setPageNumber(this.pageNumber);
        this.content = pageContent;
        this.content.setGenerateBy(this.masterPage);
        this.instanceId = new InstanceID(null, this.pageNumber, this.masterPage.getID(), null);
        this.content.setInstanceID(this.instanceId);
        return this.content;
    }

    public void close() throws BirtException {
        this.context.setExecutingMasterPage(false);
        this.context.setTOCBuilder(this.tocBuilder);
        super.close();
    }

    public boolean hasNextChild() {
        return this.nextBand >= 0 && this.nextBand <= 2;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ArrayList band = null;
            switch (this.nextBand) {
                case 0: {
                    if (this.masterPage instanceof SimpleMasterPageDesign) {
                        band = ((SimpleMasterPageDesign)this.masterPage).getHeaders();
                        break;
                    }
                    band = new ArrayList();
                    break;
                }
                case 2: {
                    if (this.masterPage instanceof SimpleMasterPageDesign) {
                        band = ((SimpleMasterPageDesign)this.masterPage).getFooters();
                        break;
                    }
                    band = new ArrayList();
                    break;
                }
                case 1: {
                    band = new ArrayList();
                }
            }
            ++this.nextBand;
            PageBandExecutor bandExecutor = new PageBandExecutor(this, band);
            bandExecutor.setParent(this);
            return bandExecutor;
        }
        return null;
    }
}

