/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class ScriptUtil {
    public static SecurityController createSecurityController() {
        return new SecurityController(){

            public GeneratedClassLoader createClassLoader(final ClassLoader parentLoader, Object securityDomain) {
                final ProtectionDomain domain = (ProtectionDomain)securityDomain;
                return AccessController.doPrivileged(new PrivilegedAction<GeneratedClassLoader>(){

                    @Override
                    public GeneratedClassLoader run() {
                        return new Loader(parentLoader, domain);
                    }
                });
            }

            public Object getDynamicSecurityDomain(Object securityDomain) {
                ProtectionDomain staticDomain = (ProtectionDomain)securityDomain;
                return this.getDynamicDomain(staticDomain);
            }

            public Object execWithDomain(Context cx, Scriptable scope, Script script, Object securityDomain) {
                return script.exec(cx, scope);
            }

            private ProtectionDomain getDynamicDomain(ProtectionDomain staticDomain) {
                ContextPermissions permission = new ContextPermissions(staticDomain);
                ProtectionDomain contextDomain = new ProtectionDomain(null, permission);
                return contextDomain;
            }
        };
    }

    public static class ContextPermissions
    extends PermissionCollection {
        private AccessControlContext context = AccessController.getContext();
        private PermissionCollection statisPermissions;
        private static final long serialVersionUID = -1721494496320750721L;

        public ContextPermissions(ProtectionDomain staticDomain) {
            if (staticDomain != null) {
                this.statisPermissions = staticDomain.getPermissions();
            }
            this.setReadOnly();
        }

        public void add(Permission permission) {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        public boolean implies(Permission permission) {
            if (this.statisPermissions != null && !this.statisPermissions.implies(permission)) {
                return false;
            }
            try {
                this.context.checkPermission(permission);
                return true;
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }

        public Enumeration elements() {
            return new Enumeration(){

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }
    }

    public static class Loader
    extends ClassLoader
    implements GeneratedClassLoader {
        private ProtectionDomain domain;
        private ClassLoader parent;

        Loader(ClassLoader parent, ProtectionDomain domain) {
            this.domain = domain;
            this.parent = parent;
        }

        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> cl = this.findLoadedClass(name);
            if (cl == null) {
                cl = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
            }
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }

        public Class defineClass(String name, byte[] data) {
            return super.defineClass(name, data, 0, data.length, this.domain);
        }

        public void linkClass(Class cl) {
            this.resolveClass(cl);
        }
    }
}

