/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.MasterPageExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.toc.ITreeNode;

public abstract class AbstractReportExecutor
implements IReportExecutor {
    protected ExecutionContext context;
    protected IDataEngine dataEngine;
    protected CachedReportContentReaderV3 reader;
    protected PageHintReader hintsReader;
    protected CachedReportContentReaderV3 pageReader;
    protected Report report;
    protected ReportContent reportContent;
    protected long uniqueId;
    protected ExecutorManager manager;

    AbstractReportExecutor(ExecutionContext context) throws IOException {
        assert (context.getDesign() != null);
        assert (context.getReportDocument() != null);
        this.manager = new ExecutorManager(this);
        this.context = context;
        this.report = context.getReport();
        this.reportContent = (ReportContent)ContentFactory.createReportContent(this.report);
        this.reportContent.setExecutionContext(context);
        context.setReportContent(this.reportContent);
        IReportDocument reportDoc = context.getReportDocument();
        if (reportDoc instanceof ReportDocumentReader) {
            ReportDocumentReader docReader = (ReportDocumentReader)reportDoc;
            try {
                ITreeNode tocTree = docReader.getTOCTree();
                this.reportContent.setTOCTree(tocTree);
            }
            catch (EngineException ex) {
                context.addException(ex);
            }
        }
        long totalPage = reportDoc.getPageCount();
        context.setTotalPage(totalPage);
        this.reportContent.setTotalPage(totalPage);
        this.dataEngine = context.getDataEngine();
        this.dataEngine.prepare(this.report, context.getAppContext());
        try {
            IDocArchiveReader archive = reportDoc.getArchive();
            RAInputStream in = archive.getStream("/content/content.dat");
            this.reader = new CachedReportContentReaderV3(this.reportContent, in, context);
            in = archive.getStream("/content/page.dat");
            this.pageReader = new CachedReportContentReaderV3(this.reportContent, in, context);
            this.hintsReader = new PageHintReader(reportDoc);
            Collection<PageVariable> vars = this.hintsReader.getPageVariables();
            if (vars != null) {
                context.addPageVariables(vars);
            }
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.pageReader != null) {
            this.pageReader.close();
            this.pageReader = null;
        }
        if (this.hintsReader != null) {
            this.hintsReader.close();
            this.hintsReader = null;
        }
    }

    public IReportContent execute() {
        return this.reportContent;
    }

    protected void executeAll(IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        while (executor.hasNextChild()) {
            if (this.context.isCanceled()) break;
            IReportItemExecutor childExecutor = executor.getNextChild();
            if (childExecutor == null) continue;
            IContent content = childExecutor.execute();
            if (content != null) {
                ContentEmitterUtil.startContent(content, emitter);
            }
            this.executeAll(childExecutor, emitter);
            if (content != null) {
                ContentEmitterUtil.endContent(content, emitter);
            }
            childExecutor.close();
        }
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        return new MasterPageExecutor(this.manager, pageNumber, pageDesign);
    }

    public IPageContent createPage(long pageNumber, MasterPageDesign pageDesign) throws BirtException {
        IReportItemExecutor pageExecutor = this.createPageExecutor(pageNumber, pageDesign);
        IPageContent pageContent = (IPageContent)pageExecutor.execute();
        DOMBuilderEmitter domEmitter = new DOMBuilderEmitter(pageContent);
        this.executeAll(pageExecutor, domEmitter);
        pageExecutor.close();
        return pageContent;
    }
}

