/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.w3c.dom.css.CSSValue;

public class HTMLListingBandLM
extends HTMLBlockStackingLM {
    boolean repeatHeader;

    public HTMLListingBandLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 7;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        super.initialize(parent, content, executor, emitter);
        this.repeatHeader = false;
        this.intializeHeaderContent();
    }

    public void close() throws BirtException {
        if (this.repeatHeader) {
            assert (this.executor instanceof DOMReportItemExecutor);
            this.executor.close();
        }
        super.close();
    }

    private void intializeHeaderContent() throws BirtException {
        assert (this.content != null);
        IElement pContent = this.content.getParent();
        assert (pContent != null);
        assert (this.content instanceof IBandContent);
        int type = ((IBandContent)this.content).getBandType();
        this.repeatHeader = false;
        if (type == 1 || type == 3) {
            if (pContent instanceof IGroupContent) {
                IGroupContent groupContent = (IGroupContent)pContent;
                this.repeatHeader = groupContent.isHeaderRepeat();
            } else if (pContent instanceof IListContent) {
                IListContent list = (IListContent)pContent;
                this.repeatHeader = list.isHeaderRepeat();
            } else if (pContent instanceof ITableContent) {
                ITableContent table = (ITableContent)pContent;
                this.repeatHeader = table.isHeaderRepeat();
            }
        }
        if (this.repeatHeader) {
            Collection children = this.content.getChildren();
            if (children == null || children.isEmpty()) {
                this.execute(this.content, this.executor);
                if (!pContent.getChildren().contains(this.content)) {
                    pContent.getChildren().add(this.content);
                }
            }
            this.executor = new DOMReportItemExecutor(this.content);
            this.executor.execute();
        }
    }

    protected boolean allowPageBreak() {
        IBandContent band = (IBandContent)this.content;
        int type = band.getBandType();
        if (type == 1) {
            if (IStyle.SOFT_VALUE.equals(this.content.getStyle().getProperty(22))) {
                return true;
            }
            IElement listContent = band.getParent();
            if (listContent instanceof IListContent) {
                return !((IListContent)listContent).isHeaderRepeat();
            }
            if (listContent instanceof ITableContent) {
                return !((ITableContent)listContent).isHeaderRepeat();
            }
        } else if (type == 3) {
            if (IStyle.SOFT_VALUE.equals(this.content.getStyle().getProperty(22))) {
                return true;
            }
            IElement groupContent = band.getParent();
            if (groupContent instanceof IGroupContent) {
                return !((IGroupContent)groupContent).isHeaderRepeat();
            }
        }
        return true;
    }

    protected boolean needPageBreakBefore() {
        IStyle style;
        CSSValue pageBreak;
        if (super.needPageBreakBefore()) {
            return true;
        }
        int bandType = ((IBandContent)this.content).getBandType();
        if (bandType == 3 && IStyle.SOFT_VALUE.equals(pageBreak = (style = this.content.getStyle()).getProperty(22))) {
            style.setProperty(22, IStyle.AUTO_VALUE);
            return true;
        }
        return false;
    }
}

