/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;

public class PDFCellLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    protected PDFTableLM tableLM;
    protected int columnWidth = 0;
    private ICellContent cellContent;

    public PDFCellLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        assert (parent != null);
        this.tableLM = this.getTableLayoutManager();
        this.cellContent = (ICellContent)content;
    }

    protected void createRoot() {
        if (this.root == null) {
            CellArea cell = AreaFactory.createCellArea(this.cellContent);
            cell.setRowSpan(this.tableLM.getRowSpan(this.cellContent));
            this.root = cell;
            if (!this.isFirst) {
                IStyle areaStyle = this.root.getStyle();
                areaStyle.setProperty(11, IStyle.NUMBER_0);
                areaStyle.setProperty(2, IStyle.NUMBER_0);
            }
        }
        this.tableLM.resolveBorderConflict((CellArea)this.root, this.isFirst);
        this.root.setWidth(this.columnWidth);
    }

    protected void initialize() {
        boolean isNewArea = this.root == null;
        this.createRoot();
        if (isNewArea) {
            IStyle areaStyle = this.root.getStyle();
            this.removeMargin(areaStyle);
            this.validateBoxProperty(this.root.getStyle(), this.columnWidth, this.context.getMaxHeight());
            this.setOffsetX(this.root.getContentX());
            this.setOffsetY(this.root.getContentY());
            this.setCurrentBP(0);
            this.setCurrentIP(0);
        }
        this.maxAvaWidth = this.root.getContentWidth();
        this.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        this.maxAvaHeight = this.root.getContentHeight();
    }

    protected void closeLayout() {
        if (this.root != null) {
            this.root.setHeight(this.getCurrentBP() + this.getOffsetY() + this.getDimensionValue(this.root.getStyle().getProperty(9)));
        }
    }

    protected boolean isHidden() {
        int startColumn = this.cellContent.getColumn();
        int endColumn = startColumn + this.cellContent.getColSpan();
        this.columnWidth = this.tableLM.getCellWidth(startColumn, endColumn);
        if (this.columnWidth == 0 || !this.tableLM.isCellVisible(this.cellContent)) {
            return true;
        }
        return this.isHiddenByVisibility();
    }

    protected boolean isRootEmpty() {
        if (this.isLast) {
            return false;
        }
        if (this.parent.root != null && this.parent.root.getChildrenCount() > 0) {
            return false;
        }
        return super.isRootEmpty();
    }

    public boolean pageBreakInsideAvoid() {
        IStyle style;
        String pageBreak;
        if (this.content == null) {
            return false;
        }
        IContent row = (IContent)this.content.getParent();
        return row != null && "avoid" == (pageBreak = (style = row.getStyle()).getPageBreakInside());
    }

    public boolean isPageEmpty() {
        if (this.root != null && this.root.getChildrenCount() > 0) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isPageEmpty();
        }
        return true;
    }

    protected boolean needPageBreakAfter(String pageBreak) {
        return false;
    }

    protected boolean needPageBreakBefore(String pageBreak) {
        return false;
    }
}

