/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Locale;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.ICUWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;

public class WordRecognizerWrapper
implements IWordRecognizer {
    private String text;
    private ICUWordRecognizer wr = null;
    private Word currentWord = null;
    private int start = 0;
    private int end = 0;
    private static final String KEEP_WITH_NEXT_CHARS = "(<{[\uff08\u300a\u00ab\u201c$\uffe5";
    private static final String KEEP_WITH_LAST_CHARS = ")>}]\uff09\u300b\u00bb\u201d,.;:! \uff0c\u3002\uff1b\uff1a\uff01";
    private static final String KEEP_WITH_DEPENDS = "\"'";
    private boolean leftQuote = true;

    public WordRecognizerWrapper(String text, Locale locale) {
        this.text = text;
        this.wr = new ICUWordRecognizer(text, locale);
    }

    public Word getNextWord() {
        this.start = this.end;
        if (this.start == this.text.length()) {
            return null;
        }
        this.keepWithNext();
        this.keepWithLast();
        return new Word(this.text, this.start, this.end);
    }

    public boolean hasWord() {
        return this.end != this.text.length();
    }

    public int getLastWordEnd() {
        return this.end;
    }

    private void keepWithNext() {
        if (!this.genCurrentICUWord()) {
            return;
        }
        if (this.currentWord.getLength() == 1) {
            if (KEEP_WITH_NEXT_CHARS.indexOf(this.currentWord.getValue()) != -1) {
                this.end = this.currentWord.getEnd();
                this.keepWithNext();
            } else if (KEEP_WITH_DEPENDS.indexOf(this.currentWord.getValue()) != -1 && this.leftQuote) {
                this.end = this.currentWord.getEnd();
                this.leftQuote = false;
                this.keepWithNext();
            }
        }
        if (this.currentWord != null) {
            this.end = this.currentWord.getEnd();
        }
    }

    private void keepWithLast() {
        if (!this.genCurrentICUWord()) {
            return;
        }
        if (this.currentWord.getLength() == 1) {
            if (KEEP_WITH_LAST_CHARS.indexOf(this.currentWord.getValue()) != -1) {
                this.end = this.currentWord.getEnd();
                this.keepWithLast();
            } else if (KEEP_WITH_DEPENDS.indexOf(this.currentWord.getValue()) != -1 && !this.leftQuote) {
                this.end = this.currentWord.getEnd();
                this.leftQuote = true;
                this.keepWithLast();
            }
        }
    }

    private boolean genCurrentICUWord() {
        if (this.currentWord == null) {
            this.currentWord = this.wr.getNextWord();
            return this.currentWord != null;
        }
        if (this.end == this.currentWord.getEnd()) {
            this.currentWord = this.wr.getNextWord();
            return this.currentWord != null;
        }
        return true;
    }
}

