/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PDFLayoutEmitter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.WrappedPDFLayoutEmitter;

public class PDFLayoutEmitterProxy
extends LayoutEmitterAdapter
implements IContentEmitter {
    private LayoutEmitterAdapter layoutEmitterImpl = null;
    private IContentEmitter outputEmitter = null;
    private IReportExecutor executor;
    private LayoutEngineContext context;

    public PDFLayoutEmitterProxy(IReportExecutor executor, IContentEmitter emitter, IRenderOption renderOptions, Locale locale, long totalPage) {
        this.executor = executor;
        this.outputEmitter = emitter;
        this.context = new LayoutEngineContext();
        this.setupLayoutOptions(renderOptions);
        if (renderOptions != null) {
            String format = renderOptions.getOutputFormat();
            this.context.setFormat(format);
        }
        this.context.setLocale(locale);
        this.context.totalPage = totalPage;
        this.createLayoutEmitterImpl(this.context);
        this.context.setEmitter(this.layoutEmitterImpl);
    }

    public void initialize(IEmitterServices service) throws BirtException {
        this.layoutEmitterImpl.initialize(service);
    }

    private void createLayoutEmitterImpl(LayoutEngineContext context) {
        this.layoutEmitterImpl = context.autoPageBreak ? new WrappedPDFLayoutEmitter(this.executor, this.outputEmitter, context) : new PDFLayoutEmitter(this.executor, this.outputEmitter, context);
    }

    public String getOutputFormat() {
        return this.layoutEmitterImpl.getOutputFormat();
    }

    public void setPageHandler(ILayoutPageHandler pageHandler) {
        this.layoutEmitterImpl.setPageHandler(pageHandler);
    }

    protected void setupLayoutOptions(IRenderOption renderOptions) {
        Map options = null;
        if (renderOptions != null) {
            options = renderOptions.getOptions();
        }
        if (options != null) {
            Object dpi;
            Object hyhenation;
            Object bidiProcessing;
            Object fontSubstitution;
            Object pageOverflow;
            Object pageBreakOnly;
            Object fitToPage = options.get("pdfRenderOption.fitToPage");
            if (fitToPage != null && fitToPage instanceof Boolean && ((Boolean)fitToPage).booleanValue()) {
                this.context.setFitToPage(true);
            }
            if ((pageBreakOnly = options.get("pdfRenderOption.pagebreakPaginationOnly")) != null && pageBreakOnly instanceof Boolean && ((Boolean)pageBreakOnly).booleanValue()) {
                this.context.setPagebreakPaginationOnly(true);
            }
            if ((pageOverflow = options.get("pdfRenderOption.pageOverflow")) != null && pageOverflow instanceof Integer) {
                int pageOverflowType = (Integer)pageOverflow;
                this.context.setPageOverflow(pageOverflowType);
                if (pageOverflowType == 4) {
                    this.context.setPagebreakPaginationOnly(false);
                } else {
                    this.context.setPagebreakPaginationOnly(true);
                }
            } else if (this.context.fitToPage()) {
                this.context.setPageOverflow(2);
                this.context.setPagebreakPaginationOnly(true);
            }
            Object textWrapping = options.get("pdfRenderOption.textWrapping");
            if (textWrapping != null && textWrapping instanceof Boolean && !((Boolean)textWrapping).booleanValue()) {
                this.context.setTextWrapping(false);
            }
            if ((fontSubstitution = options.get("pdfRenderOption.fontSubstitution")) != null && fontSubstitution instanceof Boolean && !((Boolean)fontSubstitution).booleanValue()) {
                this.context.setFontSubstitution(false);
            }
            if ((bidiProcessing = options.get("pdfRenderOption.bidiProcessing")) != null && bidiProcessing instanceof Boolean && !((Boolean)bidiProcessing).booleanValue()) {
                this.context.setBidiProcessing(false);
            }
            if ((hyhenation = options.get("pdfRenderOption.hyphenation")) != null && hyhenation instanceof Boolean && ((Boolean)hyhenation).booleanValue()) {
                this.context.setEnableHyphenation(true);
            }
            if ((dpi = options.get("pdfRenderOption.dpi")) != null && dpi instanceof Integer) {
                int screenDpi = (Integer)dpi;
                this.context.setDpi(screenDpi);
            }
        }
    }

    public void start(IReportContent report) throws BirtException {
        this.layoutEmitterImpl.start(report);
    }

    public void end(IReportContent report) throws BirtException {
        this.layoutEmitterImpl.end(report);
    }

    public void startTable(ITableContent table) throws BirtException {
        this.layoutEmitterImpl.startTable(table);
    }

    public void endTable(ITableContent table) throws BirtException {
        this.layoutEmitterImpl.endTable(table);
    }

    public void startContainer(IContainerContent container) throws BirtException {
        this.layoutEmitterImpl.startContainer(container);
    }

    public void endContainer(IContainerContent container) throws BirtException {
        this.layoutEmitterImpl.endContainer(container);
    }

    public void startContent(IContent content) throws BirtException {
        this.layoutEmitterImpl.startContent(content);
    }

    public void endContent(IContent content) throws BirtException {
        this.layoutEmitterImpl.endContent(content);
    }

    public void startListBand(IListBandContent listBand) throws BirtException {
        this.layoutEmitterImpl.startListBand(listBand);
    }

    public void startListGroup(IListGroupContent listGroup) throws BirtException {
        this.layoutEmitterImpl.startListGroup(listGroup);
    }

    public void endListBand(IListBandContent listBand) throws BirtException {
        this.layoutEmitterImpl.endListBand(listBand);
    }

    public void outputPage(IPageContent page) throws BirtException {
        this.layoutEmitterImpl.outputPage(page);
    }

    public void startPage(IPageContent page) throws BirtException {
        this.layoutEmitterImpl.startPage(page);
    }

    public void endPage(IPageContent page) throws BirtException {
        this.layoutEmitterImpl.endPage(page);
    }

    public void startRow(IRowContent row) throws BirtException {
        this.layoutEmitterImpl.startRow(row);
    }

    public void endRow(IRowContent row) throws BirtException {
        this.layoutEmitterImpl.endRow(row);
    }

    public void startTableBand(ITableBandContent band) throws BirtException {
        this.layoutEmitterImpl.startTableBand(band);
    }

    public void startTableGroup(ITableGroupContent group) throws BirtException {
        this.layoutEmitterImpl.startTableGroup(group);
    }

    public void endTableBand(ITableBandContent band) throws BirtException {
        this.layoutEmitterImpl.endTableBand(band);
    }

    public void endTableGroup(ITableGroupContent group) throws BirtException {
        this.layoutEmitterImpl.endTableGroup(group);
    }

    public void startCell(ICellContent cell) throws BirtException {
        this.layoutEmitterImpl.startCell(cell);
    }

    public void endCell(ICellContent cell) throws BirtException {
        this.layoutEmitterImpl.endCell(cell);
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        this.layoutEmitterImpl.startForeign(foreign);
    }

    public ILayoutPageHandler getPageHandler() {
        return this.layoutEmitterImpl.getPageHandler();
    }
}

