/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout;

import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RepeatableArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class LayoutEngine
extends LayoutEmitterAdapter
implements IContentEmitter {
    protected IContentEmitter emitter;
    protected LayoutContext context;
    protected ContainerArea current;
    protected AreaFactory af = null;
    protected ILayoutPageHandler pageHandler;
    protected boolean isFirst = true;

    public LayoutEngine(IReportExecutor executor, IContentEmitter emitter, IRenderOption renderOptions, Locale locale, long totalPage) {
        this.emitter = emitter;
        this.context = new LayoutContext();
        this.af = new AreaFactory(this);
        this.setupLayoutOptions(renderOptions);
        if (renderOptions != null) {
            String format = renderOptions.getOutputFormat();
            this.context.setFormat(format);
        }
        this.context.setLocale(locale);
        this.context.totalPage = totalPage;
    }

    public LayoutEngine(LayoutContext context) {
        this.context = context;
        this.af = new AreaFactory(this);
    }

    public void initialize(IEmitterServices service) throws BirtException {
        this.emitter.initialize(service);
        ReportDesignHandle designHandle = (ReportDesignHandle)service.getReportRunnable().getDesignHandle();
        if (designHandle != null) {
            String reportLayoutPreference = designHandle.getLayoutPreference();
            this.context.setFixedLayout("fixed layout".equals(reportLayoutPreference));
        }
    }

    protected void setupLayoutOptions(IRenderOption renderOptions) {
        Map options = null;
        if (renderOptions != null) {
            options = renderOptions.getOptions();
        }
        if (options != null) {
            Object supportedImageFormats;
            Object dpi;
            Object hyhenation;
            Object bidiProcessing;
            Object fontSubstitution;
            Object pageOverflow;
            Object pageBreakOnly;
            Object fitToPage = options.get("pdfRenderOption.fitToPage");
            if (fitToPage != null && fitToPage instanceof Boolean && ((Boolean)fitToPage).booleanValue()) {
                this.context.setFitToPage(true);
            }
            if ((pageBreakOnly = options.get("pdfRenderOption.pagebreakPaginationOnly")) != null && pageBreakOnly instanceof Boolean && ((Boolean)pageBreakOnly).booleanValue()) {
                this.context.setPagebreakPaginationOnly(true);
            }
            if ((pageOverflow = options.get("pdfRenderOption.pageOverflow")) != null && pageOverflow instanceof Integer) {
                int pageOverflowType = (Integer)pageOverflow;
                this.context.setPageOverflow(pageOverflowType);
                if (pageOverflowType == 4) {
                    this.context.setPagebreakPaginationOnly(false);
                } else {
                    this.context.setPagebreakPaginationOnly(true);
                }
            } else if (this.context.fitToPage()) {
                this.context.setPageOverflow(2);
                this.context.setPagebreakPaginationOnly(true);
            }
            Object textWrapping = options.get("pdfRenderOption.textWrapping");
            if (textWrapping != null && textWrapping instanceof Boolean && !((Boolean)textWrapping).booleanValue()) {
                this.context.setTextWrapping(false);
            }
            if ((fontSubstitution = options.get("pdfRenderOption.fontSubstitution")) != null && fontSubstitution instanceof Boolean && !((Boolean)fontSubstitution).booleanValue()) {
                this.context.setFontSubstitution(false);
            }
            if ((bidiProcessing = options.get("pdfRenderOption.bidiProcessing")) != null && bidiProcessing instanceof Boolean && !((Boolean)bidiProcessing).booleanValue()) {
                this.context.setBidiProcessing(false);
            }
            if ((hyhenation = options.get("pdfRenderOption.hyphenation")) != null && hyhenation instanceof Boolean && ((Boolean)hyhenation).booleanValue()) {
                this.context.setEnableHyphenation(true);
            }
            if ((dpi = options.get("pdfRenderOption.dpi")) != null && dpi instanceof Integer) {
                int screenDpi = (Integer)dpi;
                this.context.setDpi(screenDpi);
            }
            if ((supportedImageFormats = options.get("supportedImageFormats")) != null && supportedImageFormats instanceof String) {
                this.context.setSupportedImageFormats((String)supportedImageFormats);
            }
        }
    }

    public String getOutputFormat() {
        return this.emitter.getOutputFormat();
    }

    public void start(IReportContent report) throws BirtException {
        this.emitter.start(report);
        this.context.setReport(report);
    }

    public void end(IReportContent report) throws BirtException {
        this.resolveTotalPage(this.emitter);
        if (this.pageHandler != null) {
            this.pageHandler.onPage(this.context.pageNumber, this.context);
        }
        this.emitter.end(report);
    }

    public void startContainer(IContainerContent container) throws BirtException {
        this._startContainer(container);
    }

    protected void setContainer(ContainerArea container) throws BirtException {
        container.initialize();
        this.current = container;
    }

    protected void closeContainer() throws BirtException {
        if (this.current != null) {
            this.current.close();
        }
        this.current = this.current.getParent();
    }

    protected void _startContainer(IContent container) throws BirtException {
        boolean isInline = PropertyUtil.isInlineElement(container);
        if (isInline) {
            if (this.current == null || !this.current.isInlineStacking()) {
                this.setContainer(this.af.createLineArea(this.current, this.context));
            }
        } else if (this.current != null && this.current.isInlineStacking()) {
            while (this.current != null && this.current.isInlineStacking()) {
                this.closeContainer();
            }
        }
        ContainerArea area = (ContainerArea)this.af.createArea(this.current, this.context, container);
        this.setContainer(area);
    }

    public void endContainer(IContainerContent container) throws BirtException {
        this._endContainer(container);
    }

    protected void _endCell(ICellContent cell) throws BirtException {
        while (!(this.current instanceof CellArea)) {
            this.current.close();
            this.current = this.current.getParent();
        }
        this.current.close();
        this.current = this.current.getParent();
    }

    protected void _endContainer(IContent container) throws BirtException {
        boolean isInline = PropertyUtil.isInlineElement(container);
        if (isInline) {
            if (this.current != null) {
                this.current.isInlineStacking();
            }
        } else if (this.current != null && this.current.isInlineStacking()) {
            while (this.current != null && this.current.isInlineStacking()) {
                this.closeContainer();
            }
        }
        this.closeContainer();
    }

    public void startContent(IContent content) throws BirtException {
        ILayout layout;
        boolean isInline = PropertyUtil.isInlineElement(content);
        if (isInline) {
            if (!this.current.isInlineStacking()) {
                this.setContainer(this.af.createLineArea(this.current, this.context));
            }
        } else if (this.current.isInlineStacking()) {
            while (this.current.isInlineStacking()) {
                this.closeContainer();
            }
        }
        if ((layout = this.af.createLayout(this.current, this.context, content)) != null) {
            layout.layout();
        }
    }

    public void endContent(IContent content) throws BirtException {
    }

    public void startListBand(IListBandContent listBand) throws BirtException {
        int bandType = listBand.getBandType();
        if ((bandType == 1 || bandType == 3) && this.current instanceof RepeatableArea) {
            ((RepeatableArea)this.current).setInHeaderBand(true);
        }
    }

    public void startListGroup(IListGroupContent listGroup) throws BirtException {
        super.startListGroup(listGroup);
    }

    public void endListBand(IListBandContent listBand) throws BirtException {
        int bandType = listBand.getBandType();
        if ((bandType == 1 || bandType == 3) && this.current instanceof RepeatableArea) {
            ((RepeatableArea)this.current).setInHeaderBand(false);
        }
    }

    public void startPage(IPageContent page) throws BirtException {
        long number;
        super.startPage(page);
        if (!this.context.autoPageBreak && (number = page.getPageNumber()) > 0L) {
            this.context.pageNumber = number;
        }
    }

    public void endPage(IPageContent page) throws BirtException {
        super.endPage(page);
    }

    protected void startTableContainer(IContainerContent container) throws BirtException {
        this.setContainer((ContainerArea)this.af.createArea(this.current, this.context, container));
    }

    protected void endTableContainer(IContainerContent container) throws BirtException {
        this.closeContainer();
    }

    public void startRow(IRowContent row) throws BirtException {
        this.startTableContainer(row);
    }

    public void endRow(IRowContent row) throws BirtException {
        this.endTableContainer(row);
    }

    public void startTableBand(ITableBandContent band) throws BirtException {
        int bandType = band.getBandType();
        if ((bandType == 1 || bandType == 3) && this.current instanceof RepeatableArea) {
            ((RepeatableArea)this.current).setInHeaderBand(true);
        }
    }

    public void startTableGroup(ITableGroupContent group) throws BirtException {
        this.startTableContainer(group);
    }

    public void endTableBand(ITableBandContent band) throws BirtException {
        int bandType = band.getBandType();
        if ((bandType == 1 || bandType == 3) && this.current instanceof RepeatableArea) {
            ((RepeatableArea)this.current).setInHeaderBand(false);
        }
    }

    public void endTableGroup(ITableGroupContent group) throws BirtException {
        this.endTableContainer(group);
    }

    public void startCell(ICellContent cell) throws BirtException {
        this.startTableContainer(cell);
    }

    public void endCell(ICellContent cell) throws BirtException {
        this._endCell(cell);
    }

    protected void visitContent(IContent content, IContentEmitter emitter) throws BirtException {
        ContentEmitterUtil.startContent(content, emitter);
        Collection children = content.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IContent child : children) {
                this.visitContent(child, emitter);
            }
        }
        ContentEmitterUtil.endContent(content, emitter);
    }

    protected void visitChildren(IContent content, IContentEmitter emitter) throws BirtException {
        Collection children = content.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IContent child : children) {
                this.visitContent(child, emitter);
            }
        }
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        if ("text/html".equals(foreign.getRawType())) {
            this._startContainer(foreign);
            HTML2Content.html2Content(foreign);
            Collection children = foreign.getChildren();
            if (children != null && !children.isEmpty()) {
                Iterator iter = children.iterator();
                IContent child = (IContent)iter.next();
                this.visitContent(child, this);
            }
            foreign.getChildren().clear();
            this._endContainer(foreign);
        } else {
            this.startContent(foreign);
        }
    }

    protected void resolveTotalPage(IContentEmitter emitter) throws BirtException {
        IContent con = this.context.getUnresolvedContent();
        if (!(con instanceof IAutoTextContent)) {
            return;
        }
        IAutoTextContent totalPageContent = (IAutoTextContent)con;
        if (totalPageContent != null) {
            int spacing;
            String align;
            boolean isRightAligned;
            DataFormatValue format = totalPageContent.getComputedStyle().getDataFormat();
            NumberFormatter nf = null;
            if (format == null) {
                nf = new NumberFormatter();
            } else {
                String pattern = format.getNumberPattern();
                String locale = format.getNumberLocale();
                nf = locale == null ? new NumberFormatter(pattern) : new NumberFormatter(pattern, new ULocale(locale));
            }
            long totalPageCount = 0L;
            totalPageCount = this.context.autoPageBreak ? this.context.pageCount : (this.context.totalPage > 0L ? this.context.totalPage : this.context.pageCount);
            totalPageContent.setText(nf.format(totalPageCount));
            AbstractArea totalPageArea = null;
            ChunkGenerator cg = new ChunkGenerator(this.context.getFontManager(), totalPageContent, true, true);
            if (cg.hasMore()) {
                Chunk c = cg.getNext();
                Dimension d = new Dimension((int)(c.getFontInfo().getWordWidth(c.getText()) * 1000.0f), (int)(c.getFontInfo().getWordHeight() * 1000.0f));
                totalPageArea = this.createTextArea(totalPageContent, c.getFontInfo(), false);
                totalPageArea.setWidth(Math.min(this.context.getMaxWidth(), d.getWidth()));
                totalPageArea.setHeight(Math.min(this.context.getMaxHeight(), d.getHeight()));
            }
            if (((isRightAligned = BidiAlignmentResolver.isRightAligned((IContent)totalPageContent, align = totalPageContent.getComputedStyle().getTextAlign(), false)) || "center".equalsIgnoreCase(align)) && (spacing = this.context.getTotalPageTemplateWidth() - totalPageArea.getWidth()) > 0) {
                if (isRightAligned) {
                    totalPageArea.setPosition(spacing + totalPageArea.getX(), totalPageArea.getY());
                } else if ("center".equalsIgnoreCase(align)) {
                    totalPageArea.setPosition(spacing / 2 + totalPageArea.getX(), totalPageArea.getY());
                }
            }
            totalPageContent.setExtension(1, totalPageArea);
            emitter.startAutoText(totalPageContent);
        }
    }

    protected TextArea createTextArea(IAutoTextContent content, FontInfo fontInfo, boolean blankLine) {
        TextStyle textStyle = TextAreaLayout.buildTextStyle(content, fontInfo);
        String text = content.getText();
        TextArea area = new TextArea(text, textStyle);
        area.setTextLength(text.length());
        area.setAction(content.getHyperlinkAction());
        return area;
    }

    boolean showPageFooter(SimpleMasterPageDesign masterPage, IPageContent page) {
        boolean showFooter = true;
        if (!masterPage.isShowFooterOnLast() && page.getPageNumber() == this.context.totalPage) {
            showFooter = false;
        }
        return showFooter;
    }

    public void outputPage(IPageContent page) throws BirtException {
        Object obj;
        MasterPageDesign mp = (MasterPageDesign)page.getGenerateBy();
        if (mp instanceof SimpleMasterPageDesign && (obj = page.getExtension(1)) != null && obj instanceof PageArea) {
            PageArea pageArea = (PageArea)obj;
            if (this.isFirst && !((SimpleMasterPageDesign)mp).isShowHeaderOnFirst()) {
                pageArea.removeHeader();
                this.isFirst = false;
            }
            if (!this.showPageFooter((SimpleMasterPageDesign)mp, page)) {
                pageArea.removeFooter();
            }
            if (((SimpleMasterPageDesign)mp).isFloatingFooter()) {
                ContainerArea footer = (ContainerArea)((Object)page.getFooter());
                IContainerArea body = pageArea.getBody();
                IContainerArea header = pageArea.getHeader();
                if (footer != null) {
                    footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
                }
            }
        }
        this.emitter.startPage(page);
        this.emitter.endPage(page);
        ++this.context.pageCount;
        if (this.pageHandler != null) {
            this.pageHandler.onPage(this.context.pageNumber, this.context);
        }
    }

    public ILayoutPageHandler getPageHandler() {
        return this.pageHandler;
    }

    public void setPageHandler(ILayoutPageHandler pageHandler) {
        this.pageHandler = pageHandler;
    }
}

