/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextLineArea;

public class BlockTextArea
extends BlockContainerArea
implements ILayout {
    public BlockTextArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
    }

    public BlockTextArea(BlockTextArea area) {
        super(area);
    }

    public void layout() throws BirtException {
        this.initialize();
        TextLineArea line = new TextLineArea(this, this.context);
        line.initialize();
        line.setTextIndent((ITextContent)this.content);
        TextAreaLayout text = new TextAreaLayout(line, this.context, this.content);
        text.initialize();
        text.layout();
        text.close();
        line.close();
        this.close();
    }

    public BlockTextArea cloneArea() {
        return new BlockTextArea(this);
    }

    protected void update() throws BirtException {
        if (this.parent != null) {
            if (this.context.isFixedLayout() && this.height > this.specifiedHeight && this.specifiedHeight > 0) {
                this.setHeight(this.specifiedHeight);
                this.setNeedClip(true);
            }
            if (!this.isInInlineStacking && this.context.isAutoPageBreak()) {
                int aHeight = this.getAllocatedHeight();
                int size = this.children.size();
                if (aHeight + this.parent.getAbsoluteBP() > this.context.getMaxBP() && size > 1) {
                    IStyle style = this.content.getComputedStyle();
                    int widow = Math.min(size, PropertyUtil.getIntValue(style.getProperty(54)));
                    int orphan = Math.min(size, PropertyUtil.getIntValue(style.getProperty(34)));
                    int i = 0;
                    while (i < size) {
                        TextLineArea line = (TextLineArea)this.children.get(i);
                        if (i > 0 && i < orphan) {
                            line.setPageBreakBefore(IStyle.AVOID_VALUE);
                        } else if (i > size - widow) {
                            line.setPageBreakBefore(IStyle.AVOID_VALUE);
                        }
                        ++i;
                    }
                }
                while (aHeight + this.parent.getAbsoluteBP() >= this.context.getMaxBP()) {
                    this.parent.autoPageBreak();
                    aHeight = this.getAllocatedHeight();
                }
            }
            this.parent.update(this);
        }
    }
}

