/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.ILabelEventHandler;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Label;
import org.eclipse.birt.report.engine.script.internal.instance.LabelInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;

public class LabelScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(LabelHandle labelHandle, ExecutionContext context) {
        try {
            Label label = new Label(labelHandle);
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelHandle, context);
            if (eh != null) {
                eh.onPrepare(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ILabelContent content, ExecutionContext context) {
        ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
        if (!LabelScriptExecutor.needOnCreate(labelDesign)) {
            return;
        }
        try {
            LabelInstance label = new LabelInstance(content, context, RunningState.CREATE);
            if (LabelScriptExecutor.handleJS(label, labelDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onCreate(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e, labelDesign.getHandle());
        }
    }

    public static void handleOnRender(ILabelContent content, ExecutionContext context) {
        ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
        if (!LabelScriptExecutor.needOnRender(labelDesign)) {
            return;
        }
        try {
            LabelInstance label = new LabelInstance(content, context, RunningState.RENDER);
            if (LabelScriptExecutor.handleJS(label, labelDesign.getOnRender(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onRender(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e, labelDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(ILabelContent content, ExecutionContext context) {
        ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
        if (!LabelScriptExecutor.needOnPageBreak(labelDesign)) {
            return;
        }
        try {
            LabelInstance label = new LabelInstance(content, context, RunningState.PAGEBREAK);
            if (LabelScriptExecutor.handleJS(label, labelDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onPageBreak(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e, labelDesign.getHandle());
        }
    }

    private static ILabelEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (ILabelEventHandler)LabelScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            LabelScriptExecutor.addClassCastException(context, e, design.getHandle(), ILabelEventHandler.class);
        }
        catch (EngineException e) {
            LabelScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }

    private static ILabelEventHandler getEventHandler(LabelHandle handle, ExecutionContext context) {
        try {
            return (ILabelEventHandler)LabelScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            LabelScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, ILabelEventHandler.class);
        }
        catch (EngineException e) {
            LabelScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }
}

