/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.IExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.RowData;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelLayoutEngine;
import org.eclipse.birt.report.engine.emitter.excel.layout.LayoutUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.PageDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;

public class ExcelEmitter
extends ContentEmitterAdapter {
    protected static Logger logger = Logger.getLogger(ExcelEmitter.class.getName());
    protected IEmitterServices service = null;
    protected OutputStream out = null;
    protected ExcelLayoutEngine engine;
    ContentEmitterVisitor contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    protected IExcelWriter writer;
    public ExcelContext context = new ExcelContext();
    private String orientation = null;
    protected String pageHeader;
    protected String pageFooter;
    private boolean outputInMasterPage = false;
    protected boolean isRTLSheet = false;
    private int sheetIndex = 1;

    public String getOutputFormat() {
        return "xls";
    }

    public void initialize(IEmitterServices service) throws EngineException {
        this.service = service;
        if (service != null) {
            this.out = EmitterUtil.getOuputStream((IEmitterServices)service, (String)("report." + this.getOutputFormat()));
        }
        this.context.setTempFileDir(service.getReportEngine().getConfig().getTempDir());
        IReportContext reportContext = service.getReportContext();
        if (reportContext != null) {
            Locale locale = reportContext.getLocale();
            if (locale != null) {
                this.context.setLocale(ULocale.forLocale((Locale)locale));
            } else {
                this.context.setLocale(ULocale.getDefault());
            }
        }
    }

    public void start(IReportContent report) {
        this.setupRenderOptions();
        String reportOrientation = report.getDesign().getReportDesign().getBidiOrientation();
        if ("rtl".equalsIgnoreCase(reportOrientation)) {
            this.isRTLSheet = true;
        }
        IStyle style = report.getRoot().getComputedStyle();
        SimpleMasterPageDesign master = (SimpleMasterPageDesign)report.getDesign().getPageSetup().getMasterPage(0);
        this.engine = new ExcelLayoutEngine(new PageDef(master, style), this.context, this);
        this.createWriter();
    }

    private void setupRenderOptions() {
        IRenderOption renderOptions = this.service.getRenderOption();
        Object textWrapping = renderOptions.getOption("excelRenderOption.wrappingText");
        if (textWrapping != null && textWrapping instanceof Boolean) {
            this.context.setWrappingText((Boolean)textWrapping);
        } else {
            this.context.setWrappingText(true);
        }
        Object officeVersion = renderOptions.getOption("excelRenderOption.officeVersion");
        if (officeVersion != null && officeVersion instanceof String) {
            if (officeVersion.equals("office2007")) {
                this.context.setOfficeVersion("office2007");
            }
        } else {
            this.context.setOfficeVersion("office2003");
        }
    }

    public void startPage(IPageContent page) throws BirtException {
        if (this.orientation == null) {
            this.orientation = this.capitalize(page.getOrientation());
        }
        if (this.needOutputInMasterPage(page.getPageHeader()) && this.needOutputInMasterPage(page.getPageFooter())) {
            this.outputInMasterPage = true;
            this.pageHeader = this.formatHeaderFooter(page.getPageHeader(), true);
            this.pageFooter = this.formatHeaderFooter(page.getPageFooter(), false);
        }
        if (!this.outputInMasterPage && page.getPageHeader() != null) {
            this.contentVisitor.visitChildren(page.getPageHeader(), null);
        }
        this.engine.setPageStyle(page.getComputedStyle());
    }

    public void endPage(IPageContent page) throws BirtException {
        if (!this.outputInMasterPage && page.getPageFooter() != null) {
            this.contentVisitor.visitChildren(page.getPageFooter(), null);
        }
    }

    public void startTable(ITableContent table) {
        ContainerSizeInfo sizeInfo = this.engine.getCurrentContainer().getSizeInfo();
        int width = sizeInfo.getWidth();
        TableInfo info = LayoutUtil.createTable(table, width);
        if (info == null) {
            return;
        }
        String caption = table.getCaption();
        if (caption != null) {
            this.engine.addCaption(caption);
        }
        this.engine.addTable(info, table.getComputedStyle());
    }

    public void startRow(IRowContent row) {
        this.engine.addRow(row.getComputedStyle());
    }

    public void endRow(IRowContent row) {
        this.engine.endRow(row.getHeight());
    }

    public void startCell(ICellContent cell) {
        IStyle style = cell.getComputedStyle();
        this.engine.addCell(cell.getColumn(), cell.getColSpan(), cell.getRowSpan(), style);
    }

    public void endCell(ICellContent cell) {
        this.engine.endCell();
    }

    public void endTable(ITableContent table) {
        this.engine.endTable();
    }

    public void startList(IListContent list) {
        ContainerSizeInfo rule = this.engine.getCurrentContainer().getSizeInfo();
        TableInfo table = LayoutUtil.createTable(list, rule.getWidth());
        this.engine.addTable(table, list.getComputedStyle());
        if (list.getChildren() == null) {
            HyperlinkDef link = this.parseHyperLink((IContent)list);
            BookmarkDef bookmark = this.getBookmark((IContent)list);
            this.engine.addData("", list.getComputedStyle(), link, bookmark);
        }
    }

    public void startListBand(IListBandContent listBand) {
        this.engine.addCell(0, 1, 0, listBand.getComputedStyle());
    }

    public void endListBand(IListBandContent listBand) {
        this.engine.endContainer();
    }

    public void endList(IListContent list) {
        this.engine.endTable();
    }

    public void startForeign(IForeignContent foreign) throws BirtException {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content((IForeignContent)foreign);
            HyperlinkDef link = this.parseHyperLink((IContent)foreign);
            this.engine.addContainer(foreign.getComputedStyle(), link);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.engine.endContainer();
        }
    }

    public void startText(ITextContent text) {
        HyperlinkDef url = this.parseHyperLink((IContent)text);
        BookmarkDef bookmark = this.getBookmark((IContent)text);
        this.engine.addData(text.getText(), text.getComputedStyle(), url, bookmark);
    }

    public void startData(IDataContent data) {
        HyperlinkDef url = this.parseHyperLink((IContent)data);
        BookmarkDef bookmark = this.getBookmark((IContent)data);
        IStyle style = data.getComputedStyle();
        DataFormatValue dataformat = style.getDataFormat();
        MapDesign map = ((StyledElementDesign)data.getGenerateBy()).getMap();
        if (map != null && map.getRuleCount() > 0 && data.getLabelText() != null) {
            this.engine.addData(data.getLabelText().trim(), style, url, bookmark);
        } else {
            String locale = null;
            int type = ExcelUtil.getType(data.getValue());
            if (type == 2) {
                if (dataformat != null) {
                    locale = dataformat.getStringLocale();
                }
                this.engine.addData(data.getText(), style, url, bookmark, locale);
            } else if (type == 1) {
                if (dataformat != null) {
                    locale = dataformat.getNumberLocale();
                }
                this.engine.addData(data.getValue(), style, url, bookmark, locale);
            } else {
                if (dataformat != null) {
                    locale = dataformat.getDateTimeLocale();
                }
                this.engine.addDateTime(data, style, url, bookmark, locale);
            }
        }
    }

    public void startImage(IImageContent image) {
        IStyle style = image.getComputedStyle();
        HyperlinkDef url = this.parseHyperLink((IContent)image);
        BookmarkDef bookmark = this.getBookmark((IContent)image);
        this.engine.addImageData(image, style, url, bookmark);
    }

    public void startLabel(ILabelContent label) {
        Object design = label.getGenerateBy();
        ILabelContent container = label;
        while (design == null) {
            container = (IContent)container.getParent();
            design = container.getGenerateBy();
        }
        HyperlinkDef url = this.parseHyperLink((IContent)label);
        BookmarkDef bookmark = this.getBookmark((IContent)label);
        if (!"\n".equalsIgnoreCase(label.getText()) || !(container instanceof IForeignContent)) {
            this.engine.addData(label.getText(), label.getComputedStyle(), url, bookmark);
        }
    }

    public void startAutoText(IAutoTextContent autoText) {
        HyperlinkDef link = this.parseHyperLink((IContent)autoText);
        BookmarkDef bookmark = this.getBookmark((IContent)autoText);
        this.engine.addData(autoText.getText(), autoText.getComputedStyle(), link, bookmark);
    }

    public void outputSheet() {
        this.engine.cacheBookmarks(this.sheetIndex);
        this.engine.complete();
        try {
            this.outputCacheData();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        ++this.sheetIndex;
    }

    public void end(IReportContent report) {
        this.engine.cacheBookmarks(this.sheetIndex);
        this.engine.complete();
        try {
            this.writer.start(report, this.engine.getStyleMap(), this.engine.getAllBookmarks());
            this.outputCacheData();
            this.writer.end();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    protected void createWriter() {
        this.writer = new ExcelWriter(this.out, this.context, this.isRTLSheet);
    }

    public void outputCacheData() throws IOException {
        this.writer.startSheet(this.engine.getCoordinates(), this.pageHeader, this.pageFooter);
        ExcelLayoutEngine.ExcelLayoutEngineIterator it = this.engine.getIterator();
        while (it.hasNext()) {
            this.outputRowData((RowData)it.next());
        }
        this.writer.endSheet(this.orientation);
    }

    private void outputRowData(RowData rowData) throws IOException {
        this.writer.startRow(rowData.getHeight());
        SheetData[] data = rowData.getRowdata();
        int i = 0;
        while (i < data.length) {
            this.writer.outputData(data[i]);
            ++i;
        }
        this.writer.endRow();
    }

    public HyperlinkDef parseHyperLink(IContent content) {
        HyperlinkDef hyperlink = null;
        IHyperlinkAction linkAction = content.getHyperlinkAction();
        if (linkAction != null) {
            String tooltip = linkAction.getTooltip();
            String bookmark = linkAction.getBookmark();
            IReportRunnable reportRunnable = this.service.getReportRunnable();
            IReportContext reportContext = this.service.getReportContext();
            IHTMLActionHandler actionHandler = (IHTMLActionHandler)this.service.getOption("actionHandler");
            switch (linkAction.getType()) {
                case 2: {
                    hyperlink = new HyperlinkDef(bookmark, 2, tooltip);
                    break;
                }
                case 1: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)reportRunnable, (IHTMLActionHandler)actionHandler, (IReportContext)reportContext);
                    hyperlink = new HyperlinkDef(url, 1, tooltip);
                    break;
                }
                case 3: {
                    String url = EmitterUtil.getHyperlinkUrl((IHyperlinkAction)linkAction, (IReportRunnable)reportRunnable, (IHTMLActionHandler)actionHandler, (IReportContext)reportContext);
                    hyperlink = new HyperlinkDef(url, 3, tooltip);
                }
            }
        }
        return hyperlink;
    }

    protected BookmarkDef getBookmark(IContent content) {
        String bookmarkName = content.getBookmark();
        if (bookmarkName == null) {
            return null;
        }
        BookmarkDef bookmark = new BookmarkDef(content.getBookmark());
        if (!ExcelUtil.isValidBookmarkName(bookmarkName)) {
            bookmark.setGeneratedName(this.engine.getGenerateBookmark(bookmarkName));
        }
        return bookmark;
    }

    public String capitalize(String orientation) {
        if (orientation.equalsIgnoreCase("landscape")) {
            return "Landscape";
        }
        if (orientation.equalsIgnoreCase("portrait")) {
            return "Portrait";
        }
        return null;
    }

    public String formatHeaderFooter(IContent headerFooter, boolean isHeader) {
        StringBuffer headfoot = new StringBuffer();
        if (headerFooter != null) {
            Collection list = headerFooter.getChildren();
            for (Object child : list) {
                if (child instanceof ITableContent) {
                    headfoot.append(this.getTableValue((ITableContent)child));
                    continue;
                }
                this.processText(headfoot, child);
            }
            return headfoot.toString();
        }
        return null;
    }

    private void processText(StringBuffer buffer, Object child) {
        if (child instanceof IAutoTextContent) {
            buffer.append(this.getAutoText((IAutoTextContent)child));
        } else if (child instanceof ITextContent) {
            buffer.append(((ITextContent)child).getText());
        } else if (child instanceof IForeignContent) {
            buffer.append(((IForeignContent)child).getRawValue());
        }
    }

    public boolean needOutputInMasterPage(IContent headerFooter) {
        if (headerFooter != null) {
            Collection list = headerFooter.getChildren();
            for (Object child : list) {
                if (child instanceof ITableContent) {
                    int columncount = ((ITableContent)child).getColumnCount();
                    int rowcount = ((ITableContent)child).getChildren().size();
                    if (columncount > 3 || rowcount > 1) {
                        logger.log(Level.WARNING, "Excel page header or footer only accept a table no more than 1 row and 3 columns.");
                        return false;
                    }
                    if (this.isEmbededTable((ITableContent)child)) {
                        logger.log(Level.WARNING, "Excel page header and footer don't support embeded grid.");
                        return false;
                    }
                }
                if (!this.isHtmlText(child)) continue;
                logger.log(Level.WARNING, "Excel page header and footer don't support html text.");
                return false;
            }
        }
        return true;
    }

    private boolean isHtmlText(Object child) {
        return child instanceof IForeignContent && "text/html".equalsIgnoreCase(((IForeignContent)child).getRawType());
    }

    public String getTableValue(ITableContent table) {
        StringBuffer tableValue = new StringBuffer();
        Collection list = table.getChildren();
        for (Object child : list) {
            tableValue.append(this.getRowValue((IRowContent)child));
        }
        return tableValue.toString();
    }

    public String getRowValue(IRowContent row) {
        StringBuffer rowValue = new StringBuffer();
        Collection list = row.getChildren();
        Iterator iter = list.iterator();
        list.size();
        int currentCellCount = 0;
        while (iter.hasNext()) {
            Object child = iter.next();
            switch (++currentCellCount) {
                case 1: {
                    rowValue.append("&L");
                    break;
                }
                case 2: {
                    rowValue.append("&C");
                    break;
                }
                case 3: {
                    rowValue.append("&R");
                    break;
                }
            }
            rowValue.append(this.getCellValue((ICellContent)child));
        }
        return rowValue.toString();
    }

    public String getCellValue(ICellContent cell) {
        StringBuffer cellValue = new StringBuffer();
        Collection list = cell.getChildren();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.processText(cellValue, iter.next());
        }
        return cellValue.toString();
    }

    private String getAutoText(IAutoTextContent autoText) {
        String result = null;
        int type = autoText.getType();
        if (type == 1) {
            result = "&P";
        } else if (type == 0) {
            result = "&N";
        }
        return result;
    }

    private boolean isEmbededTable(ITableContent table) {
        boolean isEmbeded = false;
        Collection list = table.getChildren();
        for (Object child : list) {
            Collection listCell = ((IRowContent)child).getChildren();
            for (Object cellChild : listCell) {
                Collection listCellChild = ((ICellContent)cellChild).getChildren();
                for (Object cellchild : listCellChild) {
                    if (!(cellchild instanceof ITableContent)) continue;
                    isEmbeded = true;
                }
            }
        }
        return isEmbeded;
    }

    public TimeZone getTimeZone() {
        IReportContext reportContext;
        if (this.service != null && (reportContext = this.service.getReportContext()) != null) {
            return reportContext.getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public void endContainer(IContainerContent container) {
        this.engine.removeContainerStyle();
    }

    public void startContainer(IContainerContent container) {
        this.engine.addContainerStyle(container.getComputedStyle());
    }
}

