/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleBuilder;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelLayoutEngine;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleEngine {
    public static final int DEFAULT_DATE_STYLE = 1;
    public static final int RESERVE_STYLE_ID = 20;
    private int styleID = 20;
    private Hashtable<StyleEntry, Integer> style2id = new Hashtable();
    private ExcelLayoutEngine engine;
    private Stack<StyleEntry> containerStyles = new Stack();

    public StyleEngine(ExcelLayoutEngine engine) {
        this.engine = engine;
        this.style2id.put(this.getDefaultEntry(1), new Integer(1));
    }

    public StyleEntry getDefaultEntry(int id) {
        StyleEntry entry = new StyleEntry();
        if (id == 1) {
            entry.setProperty(22, "yyyy-M-d HH:mm:ss AM/PM");
            entry.setProperty(25, Integer.toString(0));
        }
        return entry;
    }

    public StyleEntry createEntry(ContainerSizeInfo sizeInfo, IStyle style) {
        if (style == null) {
            return StyleBuilder.createEmptyStyleEntry();
        }
        StyleEntry entry = this.initStyle(style, sizeInfo);
        entry.setStart(true);
        return entry;
    }

    public StyleEntry createHorizontalStyle(ContainerSizeInfo rule) {
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry();
        if (this.engine.getContainers().size() > 0) {
            XlsContainer container = this.engine.getCurrentContainer();
            ContainerSizeInfo crule = container.getSizeInfo();
            StyleEntry cEntry = container.getStyle();
            StyleBuilder.mergeInheritableProp(cEntry, entry);
            if (rule.getStartCoordinate() == crule.getStartCoordinate()) {
                StyleBuilder.applyLeftBorder(cEntry, entry);
            }
            if (rule.getEndCoordinate() == crule.getEndCoordinate()) {
                StyleBuilder.applyRightBorder(cEntry, entry);
            }
        }
        return entry;
    }

    public StyleEntry getStyle(IStyle style, ContainerSizeInfo rule) {
        return this.initStyle(style, rule);
    }

    public int getStyleID(StyleEntry entry) {
        if (this.style2id.get(entry) != null) {
            return this.style2id.get(entry);
        }
        int styleId = this.styleID++;
        this.style2id.put(entry, new Integer(styleId));
        return styleId;
    }

    public Map<StyleEntry, Integer> getStyleIDMap() {
        return this.style2id;
    }

    private void applyHBorders(StyleEntry centry, StyleEntry entry, ContainerSizeInfo crule, ContainerSizeInfo rule) {
        if (crule == null || rule == null) {
            return;
        }
        if (crule.getStartCoordinate() == rule.getStartCoordinate()) {
            StyleBuilder.applyLeftBorder(centry, entry);
        }
        if (crule.getEndCoordinate() == rule.getEndCoordinate()) {
            StyleBuilder.applyRightBorder(centry, entry);
        }
    }

    private StyleEntry initStyle(IStyle style, ContainerSizeInfo rule) {
        StyleEntry entry = StyleBuilder.createStyleEntry(style);
        if (!this.containerStyles.isEmpty()) {
            StyleEntry centry = this.containerStyles.peek();
            StyleBuilder.mergeInheritableProp(centry, entry);
        }
        if (this.engine.getContainers().size() > 0) {
            XlsContainer container = this.engine.getCurrentContainer();
            StyleEntry cEntry = container.getStyle();
            StyleBuilder.mergeInheritableProp(cEntry, entry);
            this.applyHBorders(cEntry, entry, container.getSizeInfo(), rule);
        }
        return entry;
    }

    public void addContainderStyle(IStyle computedStyle) {
        StyleEntry entry = StyleBuilder.createStyleEntry(computedStyle);
        if (!this.containerStyles.isEmpty()) {
            StyleEntry centry = this.containerStyles.peek();
            StyleBuilder.mergeInheritableProp(centry, entry);
        }
        this.containerStyles.add(entry);
    }

    public void removeForeignContainerStyle() {
        if (!this.containerStyles.isEmpty()) {
            this.containerStyles.pop();
        }
    }

    public void applyContainerBottomStyle() {
        this.applyContainerBottomStyle(this.engine.getCurrentContainer());
    }

    public void applyContainerBottomStyle(XlsContainer container) {
        ContainerSizeInfo rule = container.getSizeInfo();
        StyleEntry entry = container.getStyle();
        int start = rule.getStartCoordinate();
        int col = this.engine.getAxis().getColumnIndexByCoordinate(start);
        int span = this.engine.getAxis().getColumnIndexByCoordinate(rule.getEndCoordinate());
        int i = col;
        while (i < span) {
            SheetData data = this.engine.getColumnLastData(i);
            if (data != null) {
                StyleBuilder.applyBottomBorder(entry, data.style);
            }
            ++i;
        }
    }
}

