/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IMetadataFilter;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLPerformanceOptimize;
import org.eclipse.birt.report.engine.emitter.html.HTMLVisionOptimize;
import org.eclipse.birt.report.engine.emitter.html.IDGenerator;
import org.eclipse.birt.report.engine.emitter.html.MetadataEmitter;
import org.eclipse.birt.report.engine.emitter.html.MetadataFilter;
import org.eclipse.birt.report.engine.emitter.html.util.DiagonalLineImage;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.css.HTMLProcessor;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

public class HTMLReportEmitter
extends ContentEmitterAdapter {
    protected boolean hasCsslinks;
    public static final String OUTPUT_FORMAT_HTML = "html";
    public static final String REPORT_FILE = "report.html";
    public static final String IMAGE_FOLDER = "image";
    protected OutputStream out = null;
    protected IReportContent report;
    protected IReportRunnable runnable;
    protected IRenderOption renderOption;
    protected boolean outputMasterPageContent = true;
    protected boolean isEmbeddable = false;
    protected String urlEncoding = null;
    protected boolean htmlRtLFlag = false;
    protected boolean pageFooterFloatFlag = true;
    protected boolean enableMetadata = false;
    protected List ouputInstanceIDs = null;
    protected int pageNo = 0;
    protected HTMLWriter writer;
    protected IReportContext reportContext;
    protected Stack stack = new Stack();
    HashMap<Long, String> diagonalCellImageMap = new HashMap();
    protected static Logger logger = Logger.getLogger(HTMLReportEmitter.class.getName());
    protected IHTMLImageHandler imageHandler;
    protected IHTMLActionHandler actionHandler;
    protected IEmitterServices services;
    protected static final int DISPLAY_BLOCK = 1;
    protected static final int DISPLAY_INLINE = 2;
    protected static final int DISPLAY_INLINE_BLOCK = 4;
    protected static final int DISPLAY_NONE = 8;
    protected static final int DISPLAY_FLAG_ALL = 65535;
    protected ContentEmitterVisitor contentVisitor;
    protected MetadataEmitter metadataEmitter;
    protected IDGenerator idGenerator = new IDGenerator();
    private String layoutPreference;
    private boolean enableAgentStyleEngine;
    private boolean outputMasterPageMargins;
    private IMetadataFilter metadataFilter = null;
    private boolean needOutputBackgroundSize = false;
    private boolean enableInlineStyle = false;
    protected String htmlIDNamespace;
    protected int browserVersion;
    protected int imageDpi = -1;
    protected HTMLEmitter htmlEmitter;
    protected Stack tableDIVWrapedFlagStack = new Stack();
    private Set outputtedStyles = new HashSet();
    protected Stack startedGroups = new Stack();

    public HTMLReportEmitter() {
        this.contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    }

    public void initialize(IEmitterServices services) throws EngineException {
        Object ac;
        Object im;
        this.services = services;
        this.out = EmitterUtil.getOuputStream((IEmitterServices)services, (String)REPORT_FILE);
        Object emitterConfig = services.getEmitterConfig().get(OUTPUT_FORMAT_HTML);
        if (emitterConfig != null && emitterConfig instanceof HTMLEmitterConfig) {
            this.imageHandler = ((HTMLEmitterConfig)emitterConfig).getImageHandler();
            this.actionHandler = ((HTMLEmitterConfig)emitterConfig).getActionHandler();
        }
        if ((im = services.getOption("imageHandler")) != null && im instanceof IHTMLImageHandler) {
            this.imageHandler = (IHTMLImageHandler)im;
        }
        if ((ac = services.getOption("actionHandler")) != null && ac instanceof IHTMLActionHandler) {
            this.actionHandler = (IHTMLActionHandler)ac;
        }
        this.reportContext = services.getReportContext();
        this.renderOption = services.getRenderOption();
        this.runnable = services.getReportRunnable();
        this.writer = this.creatWriter();
        if (this.renderOption != null) {
            HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
            this.isEmbeddable = htmlOption.getEmbeddable();
            Map options = this.renderOption.getOutputSetting();
            if (options != null) {
                this.urlEncoding = (String)options.get("url-encoding");
            }
            this.outputMasterPageContent = htmlOption.getMasterPageContent();
            IHTMLActionHandler actHandler = htmlOption.getActionHandle();
            if (ac != null) {
                this.actionHandler = actHandler;
            }
            this.pageFooterFloatFlag = htmlOption.getPageFooterFloatFlag();
            this.enableMetadata = htmlOption.getEnableMetadata();
            if (this.enableMetadata) {
                this.metadataFilter = htmlOption.getMetadataFilter();
                if (this.metadataFilter == null) {
                    this.metadataFilter = new MetadataFilter();
                }
            }
            this.ouputInstanceIDs = htmlOption.getInstanceIDs();
            this.metadataEmitter = this.creatMetadataEmitter(this.writer, htmlOption);
            this.layoutPreference = htmlOption.getLayoutPreference();
            this.enableAgentStyleEngine = htmlOption.getEnableAgentStyleEngine();
            this.outputMasterPageMargins = htmlOption.getOutputMasterPageMargins();
            this.htmlIDNamespace = htmlOption.getHTMLIDNamespace();
            if (this.htmlIDNamespace != null) {
                if (this.htmlIDNamespace.length() > 0) {
                    this.htmlIDNamespace = String.valueOf(this.htmlIDNamespace) + "_";
                    this.metadataEmitter.setHTMLIDNamespace(this.htmlIDNamespace);
                } else {
                    this.htmlIDNamespace = null;
                }
            }
            this.writer.setIndent(htmlOption.getHTMLIndent());
            if (this.isEmbeddable) {
                this.enableInlineStyle = htmlOption.getEnableInlineStyle();
            }
            this.browserVersion = HTMLEmitterUtil.getBrowserVersion(htmlOption.getUserAgent());
        }
    }

    protected HTMLWriter creatWriter() {
        return new HTMLWriter();
    }

    protected MetadataEmitter creatMetadataEmitter(HTMLWriter writer, HTMLRenderOption htmlOption) {
        return new MetadataEmitter(writer, htmlOption, null, this.idGenerator);
    }

    public IReportContent getReport() {
        return this.report;
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT_HTML;
    }

    protected void fixTransparentPNG() {
        this.writer.writeCode("<!--[if (gte IE 5.5000)&(lt IE 7)]>");
        this.writer.writeCode("   <script  type=\"text/javascript\">");
        this.writer.writeCode("    //<![CDATA");
        if (this.htmlIDNamespace == null) {
            this.writer.writeCode("      var ie55up = true;");
        } else {
            this.writer.writeCode("      var " + this.htmlIDNamespace + "ie55up = true;");
        }
        this.writer.writeCode("    //]]>");
        this.writer.writeCode("   </script>");
        this.writer.writeCode("<![endif]-->");
        this.writer.writeCode("<script type=\"text/javascript\">");
        this.writer.writeCode(" //<![CDATA[");
        if (this.htmlIDNamespace == null) {
            this.writer.writeCode("   function fixPNG(myImage) // correctly handle PNG transparency in Win IE 5.5 or IE 6.");
            this.writer.writeCode("      {");
            this.writer.writeCode("       if ( window.ie55up )");
        } else {
            this.writer.writeCode("   function " + this.htmlIDNamespace + "fixPNG(myImage) // correctly handle PNG transparency in Win IE 5.5 or higher.");
            this.writer.writeCode("      {");
            this.writer.writeCode("       if ( window." + this.htmlIDNamespace + "ie55up )");
        }
        this.writer.writeCode("          {");
        this.writer.writeCode("           var imgID = (myImage.id) ? \"id='\" + myImage.id + \"' \" : \"\";");
        this.writer.writeCode("           var imgClass = (myImage.className) ? \"class='\" + myImage.className + \"' \" : \"\";");
        this.writer.writeCode("           var imgTitle = (myImage.title) ? \"title='\" + myImage.title + \"' \" : \"title='\" + myImage.alt + \"' \";");
        this.writer.writeCode("           var imgStyle = \"display:inline-block;\" + myImage.style.cssText;");
        this.writer.writeCode("           var strNewHTML = \"<span \" + imgID + imgClass + imgTitle;");
        this.writer.writeCode("           strNewHTML += \" style=\\\"\" + \"width:\" + myImage.width + \"px; height:\" + myImage.height + \"px;\" + imgStyle + \";\";");
        this.writer.writeCode("           strNewHTML += \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\";");
        this.writer.writeCode("           strNewHTML += \"(src=\\'\" + myImage.src + \"\\', sizingMethod='scale');\\\"></span>\";");
        this.writer.writeCode("           myImage.outerHTML = strNewHTML;");
        this.writer.writeCode("          }");
        this.writer.writeCode("      }");
        this.writer.writeCode(" //]]>");
        this.writer.writeCode("</script>");
    }

    protected void fixRedirect() {
        this.writer.writeCode("<script type=\"text/javascript\">");
        this.writer.writeCode(" //<![CDATA[");
        if (this.htmlIDNamespace == null) {
            this.writer.writeCode("   function redirect(target, url){");
        } else {
            this.writer.writeCode("   function " + this.htmlIDNamespace + "redirect(target, url){");
        }
        this.writer.writeCode("       if (target =='_blank'){");
        this.writer.writeCode("           open(url);");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else if (target == '_top'){");
        this.writer.writeCode("           window.top.location.href=url;");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else if (target == '_parent'){");
        this.writer.writeCode("           location.href=url;");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else if (target == '_self'){");
        this.writer.writeCode("           location.href =url;");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else{");
        this.writer.writeCode("           open(url);");
        this.writer.writeCode("       }");
        this.writer.writeCode("      }");
        this.writer.writeCode(" //]]>");
        this.writer.writeCode("</script>");
    }

    public void start(IReportContent report) {
        String defaultStyleName;
        logger.log(Level.FINE, "[HTMLReportEmitter] Start emitter.");
        this.report = report;
        this.writer.open(this.out, "UTF-8");
        ReportDesignHandle designHandle = null;
        Report reportDesign = null;
        if (report != null) {
            Object tmp;
            reportDesign = report.getDesign();
            designHandle = reportDesign.getReportDesign();
            Map appContext = this.reportContext.getAppContext();
            if (appContext != null && (tmp = appContext.get("CHART_RESOLUTION")) != null && tmp instanceof Number) {
                this.imageDpi = ((Number)tmp).intValue();
            }
            if (this.imageDpi <= 0) {
                this.imageDpi = designHandle.getImageDPI();
            }
            if (this.imageDpi <= 0) {
                this.imageDpi = 96;
            }
        }
        this.retrieveRtLFlag();
        if (this.layoutPreference == null && designHandle != null) {
            String reportLayoutPreference = designHandle.getLayoutPreference();
            if ("fixed layout".equals(reportLayoutPreference)) {
                this.layoutPreference = "fixed";
            } else if ("auto layout".equals(reportLayoutPreference)) {
                this.layoutPreference = "auto";
            }
        }
        this.htmlEmitter = this.enableAgentStyleEngine ? new HTMLPerformanceOptimize(this, this.writer, this.layoutPreference, this.enableInlineStyle, this.browserVersion) : new HTMLVisionOptimize(this, this.writer, this.layoutPreference, this.enableInlineStyle, this.htmlRtLFlag, this.browserVersion);
        if (this.isEmbeddable) {
            String defaultStyleName2;
            this.outputCSSStyles(reportDesign, designHandle);
            this.fixTransparentPNG();
            this.fixRedirect();
            this.openRootTag();
            this.writeBidiFlag();
            if (report != null && (defaultStyleName2 = report.getDesign().getRootStyleName()) != null) {
                if (this.enableInlineStyle) {
                    StringBuffer defaultStyleBuffer = new StringBuffer();
                    IStyle defaultStyle = report.findStyle(defaultStyleName2);
                    this.htmlEmitter.buildDefaultStyle(defaultStyleBuffer, defaultStyle);
                    if (defaultStyleBuffer.length() > 0) {
                        this.writer.attribute("style", defaultStyleBuffer.toString());
                    }
                } else if (this.htmlIDNamespace != null) {
                    this.writer.attribute("class", String.valueOf(this.htmlIDNamespace) + defaultStyleName2);
                } else {
                    this.writer.attribute("class", defaultStyleName2);
                }
            }
            return;
        }
        this.openRootTag();
        this.writeBidiFlag();
        this.writer.openTag("head");
        this.outputReportTitle(designHandle);
        this.writer.openTag("meta");
        this.writer.attribute("http-equiv", "Content-Type");
        this.writer.attribute("content", "text/html; charset=utf-8");
        this.writer.closeTag("meta");
        this.outputCSSStyles(reportDesign, designHandle);
        this.fixTransparentPNG();
        this.fixRedirect();
        this.writer.closeTag("head");
        this.writer.openTag("body");
        StringBuffer defaultStyleBuffer = new StringBuffer();
        if (report != null && (defaultStyleName = report.getDesign().getRootStyleName()) != null) {
            if (this.enableInlineStyle) {
                IStyle defaultStyle = report.findStyle(defaultStyleName);
                this.htmlEmitter.buildDefaultStyle(defaultStyleBuffer, defaultStyle);
            } else if (this.htmlIDNamespace != null) {
                this.writer.attribute("class", String.valueOf(this.htmlIDNamespace) + defaultStyleName);
            } else {
                this.writer.attribute("class", defaultStyleName);
            }
        }
        if (this.outputMasterPageContent) {
            defaultStyleBuffer.append(" margin:0px;");
        }
        if (defaultStyleBuffer.length() > 0) {
            this.writer.attribute("style", defaultStyleBuffer.toString());
        }
    }

    protected void openRootTag() {
        if (this.isEmbeddable) {
            this.writer.openTag("div");
        } else {
            this.writer.outputDoctype();
            this.writer.openTag(OUTPUT_FORMAT_HTML);
        }
    }

    protected void outputReportTitle(ReportDesignHandle designHandle) {
        String title = null;
        if (designHandle != null) {
            title = designHandle.getStringProperty("title");
        }
        if (title == null && this.renderOption != null) {
            HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
            title = htmlOption.getHtmlTitle();
        }
        if (title != null) {
            this.writer.openTag("title");
            this.writer.text(title);
            this.writer.closeTag("title");
        }
    }

    private void outputCSSStyles(Report reportDesign, ReportDesignHandle designHandle) {
        List externalCsses;
        if (this.report == null) {
            logger.log(Level.WARNING, "[HTMLReportEmitter] Report object is null.");
        } else if (!this.enableInlineStyle) {
            this.writer.openTag("style");
            this.writer.attribute("type", "text/css");
            String styleNamePrefix = this.htmlIDNamespace != null ? "." + this.htmlIDNamespace : ".";
            String defaultStyleName = reportDesign.getRootStyleName();
            Map styles = reportDesign.getStyles();
            for (Map.Entry entry : styles.entrySet()) {
                String styleName = (String)entry.getKey();
                if (styleName == null) continue;
                IStyle style = (IStyle)entry.getValue();
                StringBuffer styleBuffer = new StringBuffer();
                if (styleName.equals(defaultStyleName)) {
                    this.htmlEmitter.buildDefaultStyle(styleBuffer, style);
                } else {
                    this.htmlEmitter.buildStyle(styleBuffer, style);
                }
                if (styleBuffer.length() <= 0) continue;
                this.writer.style(String.valueOf(styleNamePrefix) + styleName, styleBuffer.toString());
                this.outputtedStyles.add(styleName);
            }
            this.writer.closeTag("style");
        }
        this.hasCsslinks = false;
        if (designHandle != null && (externalCsses = designHandle.getAllExternalIncludedCsses()) != null) {
            for (IncludedCssStyleSheetHandle cssStyleSheetHandle : externalCsses) {
                String href = cssStyleSheetHandle.getExternalCssURI();
                if (href == null) continue;
                this.hasCsslinks = true;
                this.writer.openTag("link");
                this.writer.attribute("rel", "stylesheet");
                this.writer.attribute("type", "text/css");
                this.writer.attribute("href", href);
                this.writer.closeTag("link");
            }
        }
    }

    private void appendErrorMessage(EngineResourceHandle rc, int index, ExecutionContext.ElementExceptionInfo info) {
        this.writer.writeCode("\t\t\t<div>");
        this.writer.writeCode("\t\t\t\t<div  id=\"error_title\" style=\"text-decoration:underline\">");
        String name = info.getName();
        if (name != null) {
            this.writer.text(rc.getMessage("Error.ReportErrorMessage", new Object[]{info.getType(), name}), false);
        } else {
            this.writer.text(rc.getMessage("Error.ReportErrorMessageWithID", new Object[]{info.getType(), info.getID()}), false);
        }
        this.writer.writeCode("</div>");
        ArrayList errorList = info.getErrorList();
        ArrayList countList = info.getCountList();
        int i = 0;
        while (i < errorList.size()) {
            String errorId = "document.getElementById('error_detail" + index + "_" + i + "')";
            String errorIcon = "document.getElementById('error_icon" + index + "_" + i + "')";
            String onClick = "if (" + errorId + ".style.display == 'none') { " + errorIcon + ".innerHTML = '- '; " + errorId + ".style.display = 'block'; }" + "else { " + errorIcon + ".innerHTML = '+ '; " + errorId + ".style.display = 'none'; }";
            this.writer.writeCode("<div>");
            BirtException ex = (BirtException)errorList.get(i);
            this.writer.writeCode("<span id=\"error_icon" + index + "_" + i + "\"  style=\"cursor:pointer\" onclick=\"" + onClick + "\" > + </span>");
            this.writer.text(ex.getLocalizedMessage());
            this.writer.writeCode("\t\t\t\t<pre id=\"error_detail" + index + "_" + i + "\" style=\"display:none;\" >");
            String messageTitle = rc.getMessage("Error.ReportErrorID", new Object[]{ex.getErrorCode(), countList.get(i)});
            String detailTag = rc.getMessage("Error.ReportErrorDetail");
            String messageBody = this.getDetailMessage((Throwable)ex);
            boolean indent = this.writer.isIndent();
            this.writer.setIndent(false);
            this.writer.text(messageTitle, false);
            this.writer.writeCode("\r\n");
            this.writer.text(detailTag, false);
            this.writer.text(messageBody, false);
            this.writer.setIndent(indent);
            this.writer.writeCode("\t\t\t\t</pre>");
            this.writer.writeCode("</div>");
            ++i;
        }
        this.writer.writeCode("</div>");
        this.writer.writeCode("<br>");
    }

    private String getDetailMessage(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter print = new PrintWriter(out);
        try {
            t.printStackTrace(print);
        }
        catch (Throwable throwable) {}
        print.flush();
        return out.getBuffer().toString();
    }

    protected boolean outputErrors(List errors) {
        if (errors != null && !errors.isEmpty()) {
            this.writer.writeCode("\t<hr style=\"color:red\"/>");
            this.writer.writeCode("\t<div style=\"color:red\">");
            this.writer.writeCode("\t\t<div>");
            Locale locale = this.reportContext.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            EngineResourceHandle rc = new EngineResourceHandle(ULocale.forLocale((Locale)locale));
            this.writer.text(rc.getMessage("Error.ErrorOnReportPage"), false);
            this.writer.writeCode("</div>");
            this.writer.writeCode("<br>");
            Iterator it = errors.iterator();
            int index = 0;
            while (it.hasNext()) {
                this.appendErrorMessage(rc, index++, (ExecutionContext.ElementExceptionInfo)it.next());
            }
            this.writer.writeCode("</div>");
            return true;
        }
        return false;
    }

    public void end(IReportContent report) {
        List errors;
        logger.log(Level.FINE, "[HTMLReportEmitter] End body.");
        if (report != null && (errors = report.getErrors()) != null && !errors.isEmpty()) {
            this.outputErrors(errors);
        }
        if (!this.isEmbeddable) {
            this.writer.closeTag("body");
            this.writer.closeTag(OUTPUT_FORMAT_HTML);
        } else {
            this.writer.closeTag("div");
        }
        this.writer.endWriter();
        this.writer.close();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private boolean isSameUnit(String unit1, String unit2) {
        if (unit1 == unit2) {
            return true;
        }
        return unit1 != null && unit1.equals(unit2);
    }

    private DimensionType getPageWidth(IPageContent page) {
        DimensionType pageWidth = page.getPageWidth();
        if (!this.outputMasterPageMargins) {
            DimensionType leftMargin = page.getMarginLeft();
            DimensionType rightMargin = page.getMarginRight();
            return this.removeMargin(pageWidth, leftMargin, rightMargin);
        }
        return pageWidth;
    }

    private DimensionType getPageHeight(IPageContent page) {
        DimensionType pageHeight = page.getPageHeight();
        if (!this.outputMasterPageMargins) {
            DimensionType topMargin = page.getMarginTop();
            DimensionType bottomMargin = page.getMarginBottom();
            return this.removeMargin(pageHeight, topMargin, bottomMargin);
        }
        return pageHeight;
    }

    private DimensionType removeMargin(DimensionType pageWidth, DimensionType leftMargin, DimensionType rightMargin) {
        double measure = pageWidth.getMeasure();
        String unit = pageWidth.getUnits();
        if (leftMargin != null && this.isSameUnit(unit, leftMargin.getUnits())) {
            measure -= leftMargin.getMeasure();
        }
        if (rightMargin != null && this.isSameUnit(unit, rightMargin.getUnits())) {
            measure -= rightMargin.getMeasure();
        }
        if (measure > 0.0) {
            return new DimensionType(measure, unit);
        }
        return pageWidth;
    }

    private void outputColumn(DimensionType dm) {
        this.writer.openTag("col");
        StringBuffer styleBuffer = new StringBuffer();
        styleBuffer.append("width: ");
        if (dm != null) {
            styleBuffer.append(dm.toString());
        } else {
            styleBuffer.append("0pt");
        }
        styleBuffer.append(";");
        this.writer.attribute("style", styleBuffer.toString());
        this.writer.closeTag("col");
    }

    private void outputVMargin(DimensionType margin) {
        if (margin != null) {
            this.writer.openTag("tr");
            StringBuffer styleBuffer = new StringBuffer();
            styleBuffer.append("height: ");
            styleBuffer.append(margin.toString());
            styleBuffer.append(";");
            this.writer.attribute("style", styleBuffer.toString());
            this.writer.openTag("td");
            this.writer.attribute("colspan", 3);
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
        }
    }

    private void outputHMargin(DimensionType margin) {
        this.writer.openTag("td");
        if (margin != null) {
            this.writer.openTag("div");
            StringBuffer styleBuffer = new StringBuffer();
            styleBuffer.append("width: ");
            styleBuffer.append(margin.toString());
            styleBuffer.append(";");
            this.writer.attribute("style", styleBuffer.toString());
            this.writer.closeTag("div");
        }
        this.writer.closeTag("td");
    }

    boolean showPageHeader(IPageContent page) {
        SimpleMasterPageDesign masterPage;
        boolean showHeader = true;
        Object genBy = page.getGenerateBy();
        if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowHeaderOnFirst() && page.getPageNumber() == 1L) {
            showHeader = false;
        }
        return showHeader;
    }

    boolean showPageFooter(IPageContent page) {
        SimpleMasterPageDesign masterPage;
        boolean showFooter = true;
        Object genBy = page.getGenerateBy();
        if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowFooterOnLast()) {
            long totalPage = page.getPageNumber();
            IReportContent report = page.getReportContent();
            if (report != null) {
                totalPage = report.getTotalPage();
            }
            if (page.getPageNumber() == totalPage) {
                showFooter = false;
            }
        }
        return showFooter;
    }

    private void outputPageBand(IPageContent page, IContent band) throws BirtException {
        this.writer.openTag("td");
        this.writeBidiFlag();
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildPageBandStyle(styleBuffer, page.getStyle());
        this.writer.attribute("style", styleBuffer.toString());
        this.contentVisitor.visitChildren(band, null);
        this.writer.closeTag("td");
    }

    public void startPage(IPageContent page) throws BirtException {
        ++this.pageNo;
        if (this.pageNo > 1 && !this.outputMasterPageContent) {
            this.writer.openTag("hr");
            this.writer.closeTag("hr");
        }
        if (this.pageNo > 1) {
            this.writer.writeCode(" <div style=\"visibility: hidden; height: 0px; overflow: hidden; page-break-after: always;\">page separator</div>");
        }
        boolean fixedReport = "fixed".equals(this.layoutPreference);
        DimensionType width = null;
        DimensionType height = null;
        if (page != null && this.outputMasterPageContent) {
            width = this.getPageWidth(page);
            height = this.getPageHeight(page);
            if (width != null && height != null && fixedReport && !this.pageFooterFloatFlag) {
                this.startBackgroundContainer(page.getStyle(), width, height);
            }
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.writer.openTag("table");
        this.writer.attribute("cellpadding", "0");
        styleBuffer.append(" border-collapse: collapse; empty-cells: show;");
        if (page != null && this.outputMasterPageContent) {
            this.htmlEmitter.buildPageStyle(page, styleBuffer, this.needOutputBackgroundSize);
            if (fixedReport && width != null) {
                styleBuffer.append(" width:");
                styleBuffer.append(width.toString());
                styleBuffer.append(";");
            } else if (!fixedReport) {
                styleBuffer.append(" width:100%;");
            }
            if (!this.pageFooterFloatFlag && height != null) {
                styleBuffer.append(" height:");
                styleBuffer.append(height.toString());
                styleBuffer.append(";");
            }
            if (fixedReport) {
                styleBuffer.append(" overflow: hidden;");
                styleBuffer.append(" table-layout:fixed;");
            }
        } else {
            styleBuffer.append("width:100%;");
        }
        this.writer.attribute("style", styleBuffer.toString());
        if (page != null && this.outputMasterPageContent) {
            if (this.outputMasterPageMargins) {
                this.outputColumn(page.getMarginLeft());
            }
            this.writer.openTag("col");
            this.writer.closeTag("col");
            if (this.outputMasterPageMargins) {
                this.outputColumn(page.getMarginLeft());
                this.outputVMargin(page.getMarginTop());
            }
            if (this.showPageHeader(page)) {
                this.writer.openTag("tr");
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginLeft());
                }
                this.outputPageBand(page, page.getPageHeader());
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginRight());
                }
                this.writer.closeTag("tr");
            }
        }
        this.writer.openTag("tr");
        if (!this.pageFooterFloatFlag) {
            this.writer.attribute("style", "height:100%;");
        }
        if (page != null && this.outputMasterPageContent && this.outputMasterPageMargins) {
            this.outputHMargin(page.getMarginLeft());
        }
        this.writer.openTag("td");
        this.writer.attribute("valign", "top");
        this.writeBidiFlag();
    }

    private void startBackgroundContainer(IStyle style, DimensionType pageWidth, DimensionType pageHeight) {
        String backgroundPositionY;
        String image;
        String backgroundHeight = this.parseBackgroundSize(style.getBackgroundHeight(), pageHeight);
        String backgroundWidth = this.parseBackgroundSize(style.getBackgroundWidth(), pageWidth);
        if (backgroundHeight == null && backgroundWidth == null) {
            return;
        }
        if (backgroundHeight == null) {
            backgroundHeight = "auto";
        }
        if (backgroundWidth == null) {
            backgroundWidth = "auto";
        }
        if ((image = style.getBackgroundImage()) == null || "none".equalsIgnoreCase(image)) {
            return;
        }
        this.needOutputBackgroundSize = true;
        String backgroundPositionX = style.getBackgroundPositionX();
        if (backgroundPositionX == null) {
            backgroundPositionX = "0px";
        }
        if ((backgroundPositionY = style.getBackgroundPositionY()) == null) {
            backgroundPositionY = "0px";
        }
        this.writer.openTag("div");
        this.writer.attribute("style", "width:" + pageWidth + ";height:" + pageHeight + ";");
        this.writer.openTag("img");
        this.writer.attributeAllowEmpty("alt", "");
        image = this.handleStyleImage(image, true);
        if (image != null && image.length() > 0) {
            this.writer.attribute("src", image);
            this.writer.attribute("style", "width:" + backgroundWidth + ";height:" + backgroundHeight + ";position:absolute;left:" + backgroundPositionX + ";top:" + backgroundPositionY + ";z-index:-1");
        }
        this.writer.closeTag("img");
    }

    private String parseBackgroundSize(String backgroundHeight, DimensionType pageHeight) {
        if (backgroundHeight == null) {
            return null;
        }
        if ((backgroundHeight = backgroundHeight.trim()).endsWith("%")) {
            try {
                String percent = backgroundHeight.substring(0, backgroundHeight.length() - 1);
                int percentValue = Integer.valueOf(percent);
                return String.valueOf(pageHeight.getMeasure() * (double)percentValue / 100.0) + pageHeight.getUnits();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return backgroundHeight;
    }

    private void endBackgroundContainer() {
        this.writer.closeTag("div");
    }

    public void endPage(IPageContent page) throws BirtException {
        logger.log(Level.FINE, "[HTMLReportEmitter] End page.");
        this.writer.closeTag("td");
        if (page != null && this.outputMasterPageContent && this.outputMasterPageMargins) {
            this.outputHMargin(page.getMarginRight());
        }
        this.writer.closeTag("tr");
        if (page != null && this.outputMasterPageContent) {
            if (this.showPageFooter(page)) {
                this.writer.openTag("tr");
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginLeft());
                }
                this.outputPageBand(page, page.getPageFooter());
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginRight());
                }
                this.writer.closeTag("tr");
            }
            if (this.outputMasterPageMargins) {
                this.outputVMargin(page.getMarginBottom());
            }
        }
        this.writer.closeTag("table");
        if (this.needOutputBackgroundSize) {
            this.endBackgroundContainer();
            this.needOutputBackgroundSize = false;
        }
    }

    public void startTable(ITableContent table) {
        CSSValue display;
        assert (table != null);
        boolean DIVWrap = false;
        IStyle style = table.getStyle();
        if (this.needImplementAlignTable(table)) {
            this.writer.openTag("div");
            DIVWrap = true;
            this.writer.attribute("align", style.getTextAlign());
        }
        if (IStyle.INLINE_VALUE == (display = style.getProperty(51)) || IStyle.INLINE_BLOCK_VALUE == display) {
            if (!DIVWrap) {
                this.writer.openTag("div");
                DIVWrap = true;
            }
            if (this.browserVersion == HTMLEmitterUtil.BROWSER_IE7) {
                this.writer.attribute("style", " display:-moz-inline-box !important; display:inline;");
            } else {
                this.writer.attribute("style", " display:-moz-inline-box !important; display:inline-block !important; display:inline;");
            }
        }
        this.tableDIVWrapedFlagStack.push(new Boolean(DIVWrap));
        logger.log(Level.FINE, "[HTMLTableEmitter] Start table");
        if (this.enableMetadata) {
            this.metadataEmitter.startWrapTable(table);
        }
        this.writer.openTag("table");
        String styleClass = table.getStyleClass();
        this.setStyleName(styleClass, (IContent)table);
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTableStyle(table, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(table)), table, "table");
        }
        if (!bookmarkOutput) {
            String bookmark = table.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                table.setBookmark(bookmark);
            }
            HTMLEmitterUtil.setBookmark(this.writer, "table", this.htmlIDNamespace, bookmark);
        }
        String summary = table.getSummary();
        this.writer.attribute("summary", summary);
        String caption = table.getCaption();
        if (caption != null && caption.length() > 0) {
            this.writer.openTag("caption");
            this.writer.text(caption);
            this.writer.closeTag("caption");
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startTable(table);
        }
        this.writeColumns(table);
    }

    protected void writeColumns(ITableContent table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            IColumn column = table.getColumn(i);
            this.writer.openTag("col");
            if (this.enableAgentStyleEngine) {
                String styleClass = column.getStyleClass();
                this.setStyleName(styleClass, (IContent)table);
            }
            StringBuffer styleBuffer = new StringBuffer();
            this.htmlEmitter.buildColumnStyle(column, styleBuffer);
            this.writer.attribute("style", styleBuffer.toString());
            this.htmlEmitter.handleColumnAlign(column);
            if (this.metadataFilter != null) {
                this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(column)), column, "col");
            }
            this.writer.closeTag("col");
            ++i;
        }
    }

    public void endTable(ITableContent table) {
        boolean DIVWrap;
        if (this.enableMetadata) {
            this.metadataEmitter.endTable(table);
        }
        this.writer.closeTag("table");
        if (this.enableMetadata) {
            this.metadataEmitter.endWrapTable(table);
        }
        if (DIVWrap = ((Boolean)this.tableDIVWrapedFlagStack.pop()).booleanValue()) {
            this.writer.closeTag("div");
        }
        logger.log(Level.FINE, "[HTMLTableEmitter] End table");
    }

    protected boolean needImplementAlignTable(ITableContent table) {
        IStyle style;
        CSSValue display;
        DimensionType width;
        if (!(this.report.getRoot() != table.getParent() || (width = table.getWidth()) == null || "100%".equals(width.toString()) || (display = (style = table.getStyle()).getProperty(51)) != null && IStyle.BLOCK_VALUE != display)) {
            CSSValue align = style.getProperty(25);
            if (IStyle.CENTER_VALUE.equals(align)) {
                return true;
            }
            CSSValue direction = style.getProperty(5);
            if (IStyle.RTL_VALUE.equals(direction) ? !IStyle.RIGHT_VALUE.equals(align) : IStyle.RIGHT_VALUE == align) {
                return true;
            }
        }
        return false;
    }

    public void startTableHeader(ITableBandContent band) {
        this.writer.openTag("thead");
    }

    public void endTableHeader(ITableBandContent band) {
        this.writer.closeTag("thead");
    }

    public void startTableBody(ITableBandContent band) {
        this.writer.openTag("tbody");
    }

    public void endTableBody(ITableBandContent band) {
        this.writer.closeTag("tbody");
    }

    public void startTableFooter(ITableBandContent band) {
        this.writer.openTag("tfoot");
    }

    public void endTableFooter(ITableBandContent band) {
        this.writer.closeTag("tfoot");
    }

    public void startRow(IRowContent row) {
        assert (row != null);
        this.writer.openTag("tr");
        if (this.metadataFilter != null) {
            this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(row)), row, "tr");
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startRow(row);
        }
        String styleClass = row.getStyleClass();
        this.setStyleName(styleClass, (IContent)row);
        HTMLEmitterUtil.setBookmark(this.writer, null, this.htmlIDNamespace, row.getBookmark());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildRowStyle(row, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleRowAlign(row);
        if (!this.startedGroups.isEmpty()) {
            IGroupContent group = (IGroupContent)this.startedGroups.firstElement();
            String bookmark = group.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                group.setBookmark(bookmark);
            }
            HTMLEmitterUtil.setBookmark(this.writer, null, this.htmlIDNamespace, bookmark);
            this.startedGroups.remove(group);
        }
    }

    public void endRow(IRowContent row) {
        if (this.enableMetadata) {
            this.metadataEmitter.endRow(row);
        }
        this.writer.closeTag("tr");
    }

    private boolean isCellInHead(ICellContent cell) {
        IElement row = cell.getParent();
        if (row instanceof IRowContent) {
            int type;
            IElement tableBand = row.getParent();
            if (tableBand instanceof ITableBandContent && (type = ((ITableBandContent)tableBand).getBandType()) == 1) {
                return true;
            }
            IColumn column = cell.getColumnInstance();
            if (column != null) {
                return column.isColumnHeader();
            }
        }
        return false;
    }

    public void startCell(ICellContent cell) {
        int rowSpan;
        logger.log(Level.FINE, "[HTMLTableEmitter] Start cell.");
        String tagName = null;
        boolean isHead = this.isCellInHead(cell);
        tagName = isHead ? "th" : "td";
        this.writer.openTag(tagName);
        this.writer.attribute("scope", cell.getScope());
        this.writer.attribute("id", cell.getBookmark());
        this.writer.attribute("headers", cell.getHeaders());
        String styleClass = cell.getStyleClass();
        this.setStyleName(styleClass, (IContent)cell);
        int colSpan = cell.getColSpan();
        if (colSpan > 1) {
            this.writer.attribute("colspan", colSpan);
        }
        if ((rowSpan = cell.getRowSpan()) > 1) {
            this.writer.attribute("rowspan", rowSpan);
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildCellStyle(cell, styleBuffer, isHead);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleCellAlign(cell);
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(cell)), cell, tagName);
        }
        if (!this.startedGroups.isEmpty()) {
            if (!bookmarkOutput) {
                IGroupContent group = (IGroupContent)this.startedGroups.firstElement();
                String bookmark = group.getBookmark();
                if (bookmark == null) {
                    bookmark = this.idGenerator.generateUniqueID();
                    group.setBookmark(bookmark);
                }
                HTMLEmitterUtil.setBookmark(this.writer, null, this.htmlIDNamespace, bookmark);
                this.startedGroups.remove(group);
            }
            for (IGroupContent group : this.startedGroups) {
                this.outputBookmark(group);
            }
            this.startedGroups.clear();
        }
        if (cell.hasDiagonalLine()) {
            this.startDiagonalCell(cell);
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startCell(cell);
        }
    }

    protected void startDiagonalCell(ICellContent cell) {
        DimensionType cellWidth = this.getCellWidth(cell);
        DimensionType cellHeight = this.getCellHeight(cell);
        if (cellWidth == null || cellHeight == null) {
            return;
        }
        String imgUri = this.diagonalCellImageMap.get(cell.getInstanceID().getComponentID());
        if (imgUri == null) {
            DiagonalLineImage imageCreater = new DiagonalLineImage();
            imageCreater.setDiagonalLine(cell.getDiagonalNumber(), cell.getDiagonalStyle(), cell.getDiagonalWidth(), cell.getDiagonalColor());
            imageCreater.setAntidiagonalLine(cell.getAntidiagonalNumber(), cell.getAntidiagonalStyle(), cell.getAntidiagonalWidth(), cell.getAntidiagonalColor());
            imageCreater.setImageDpi(this.imageDpi);
            imageCreater.setImageSize(cellWidth, cellHeight);
            IStyle cellComputedStyle = cell.getComputedStyle();
            String strColor = cellComputedStyle.getColor();
            imageCreater.setColor(PropertyUtil.getColor((String)strColor));
            byte[] imageByteArray = null;
            try {
                imageByteArray = imageCreater.drawImage();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            if (imageByteArray != null) {
                Image image = new Image(imageByteArray, cell.getInstanceID().toUniqueString(), ".png");
                image.setReportRunnable(this.runnable);
                image.setRenderOption(this.renderOption);
                imgUri = this.imageHandler.onCustomImage((IImage)image, this.reportContext);
                if (imgUri != null) {
                    this.diagonalCellImageMap.put(cell.getInstanceID().getComponentID(), imgUri);
                }
            }
        }
        this.writer.openTag("div");
        this.writer.attribute("style", "position: relative; height: 100%;");
        if (imgUri != null) {
            this.writer.openTag("img");
            this.writer.attributeAllowEmpty("alt", "");
            this.writer.attribute("src", imgUri);
            this.writer.attribute("style", "position: absolute; width: 100%; height: 100%; z-index: -1; left:0px;");
            if (this.htmlIDNamespace == null) {
                this.writer.attribute("onload", "fixPNG(this)");
            } else {
                this.writer.attribute("onload", String.valueOf(this.htmlIDNamespace) + "fixPNG(this)");
            }
            this.writer.closeTag("img");
        }
    }

    protected DimensionType getCellWidth(ICellContent cell) {
        IColumn column = cell.getColumnInstance();
        if (column != null) {
            return column.getWidth();
        }
        return null;
    }

    protected DimensionType getCellHeight(ICellContent cell) {
        IElement row = cell.getParent();
        if (row instanceof IRowContent) {
            return ((IRowContent)row).getHeight();
        }
        return null;
    }

    public void endCell(ICellContent cell) {
        logger.log(Level.FINE, "[HTMLReportEmitter] End cell.");
        if (this.enableMetadata) {
            this.metadataEmitter.endCell(cell);
        }
        if (cell.hasDiagonalLine()) {
            this.endDiagonalCell(cell);
        }
        if (this.isCellInHead(cell)) {
            this.writer.closeTag("th");
        } else {
            this.writer.closeTag("td");
        }
    }

    protected void endDiagonalCell(ICellContent cell) {
        DimensionType cellWidth = this.getCellWidth(cell);
        DimensionType cellHeight = this.getCellHeight(cell);
        if (cellWidth == null || cellHeight == null) {
            return;
        }
        this.writer.closeTag("div");
    }

    public void startContainer(IContainerContent container) {
        logger.log(Level.FINE, "[HTMLReportEmitter] Start container");
        this.htmlEmitter.openContainerTag(container);
        String styleClass = container.getStyleClass();
        this.setStyleName(styleClass, (IContent)container);
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(container)), container, "div");
        }
        if (!bookmarkOutput) {
            String bookmark = container.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                container.setBookmark(bookmark);
            }
            HTMLEmitterUtil.setBookmark(this.writer, "div", this.htmlIDNamespace, bookmark);
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildContainerStyle(container, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleContainerAlign(container);
    }

    public void endContainer(IContainerContent container) {
        this.htmlEmitter.closeContainerTag();
        logger.log(Level.FINE, "[HTMLContainerEmitter] End container");
    }

    public void startText(ITextContent text) {
        IStyle mergedStyle = text.getStyle();
        logger.log(Level.FINE, "[HTMLReportEmitter] Start text");
        DimensionType x = text.getX();
        DimensionType y = text.getY();
        DimensionType width = text.getWidth();
        DimensionType height = text.getHeight();
        String textValue = text.getText();
        if (textValue == null || "".equals(textValue)) {
            textValue = " ";
        }
        int display = this.htmlEmitter.getTextElementType(x, y, width, height, mergedStyle);
        String tagName = this.openTagByType(display, 65535);
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(text)), text, tagName);
        }
        String styleClass = text.getStyleClass();
        this.setStyleName(styleClass, (IContent)text);
        if (!bookmarkOutput) {
            this.outputBookmark((IContent)text, tagName);
        }
        this.writer.attribute("title", text.getHelpText());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTextStyle(text, styleBuffer, display);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleVerticalAlignBegin((IContent)text);
        String url = this.validate(text.getHyperlinkAction());
        if (url != null) {
            this.outputAction(text.getHyperlinkAction(), url);
            String strColor = mergedStyle.getColor();
            if (strColor != null) {
                styleBuffer.setLength(0);
                styleBuffer.append(" color: ");
                styleBuffer.append(strColor);
                styleBuffer.append(";");
                this.writer.attribute("style", styleBuffer.toString());
            }
            this.writer.text(textValue);
            this.writer.closeTag("a");
        } else {
            this.writer.text(textValue);
        }
        this.htmlEmitter.handleVerticalAlignEnd((IContent)text);
        this.writer.closeTag(tagName);
    }

    public void startForeign(IForeignContent foreign) {
        IStyle mergedStyle = foreign.getStyle();
        logger.log(Level.FINE, "[HTMLReportEmitter] Start foreign");
        boolean isTemplate = false;
        Object genBy = foreign.getGenerateBy();
        if (genBy instanceof TemplateDesign) {
            isTemplate = true;
            this.setupTemplateElement((TemplateDesign)genBy, (IContent)foreign);
            this.writer.openTag("div");
            this.writer.attribute("align", "center");
        }
        DimensionType x = foreign.getX();
        DimensionType y = foreign.getY();
        DimensionType width = foreign.getWidth();
        DimensionType height = foreign.getHeight();
        int display = this.getElementType(x, y, width, height, mergedStyle);
        String tagName = this.openTagByType(display, 65535);
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(foreign)), foreign, tagName);
        }
        String styleClass = foreign.getStyleClass();
        this.setStyleName(styleClass, (IContent)foreign);
        if (!bookmarkOutput) {
            this.outputBookmark((IContent)foreign, tagName);
        }
        this.writer.attribute("title", foreign.getHelpText());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildForeignStyle(foreign, styleBuffer, display);
        this.writer.attribute("style", styleBuffer.toString());
        String rawType = foreign.getRawType();
        boolean isHtml = "text/html".equalsIgnoreCase(rawType);
        if (isHtml) {
            this.htmlEmitter.handleVerticalAlignBegin((IContent)foreign);
            String url = this.validate(foreign.getHyperlinkAction());
            if (url != null) {
                this.outputAction(foreign.getHyperlinkAction(), url);
                this.outputHtmlText(foreign);
                this.writer.closeTag("a");
            } else {
                this.outputHtmlText(foreign);
            }
            this.htmlEmitter.handleVerticalAlignEnd((IContent)foreign);
        }
        this.writer.closeTag(tagName);
        if (isTemplate) {
            this.writer.closeTag("div");
        }
    }

    private void outputHtmlText(IForeignContent foreign) {
        NodeList bodys;
        boolean bIndent = this.writer.isIndent();
        this.writer.setIndent(false);
        Object rawValue = foreign.getRawValue();
        String text = rawValue == null ? null : rawValue.toString();
        Document doc = new TextParser().parse(text, TextParser.TEXT_TYPE_HTML);
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        HTMLProcessor htmlProcessor = new HTMLProcessor(design, this.reportContext.getAppContext());
        HashMap styleMap = new HashMap();
        Element body = null;
        if (doc != null && (bodys = doc.getElementsByTagName("body")).getLength() > 0) {
            body = (Element)bodys.item(0);
        }
        if (body != null) {
            htmlProcessor.execute(body, styleMap);
            this.processNodes(body, styleMap);
        }
        this.writer.setIndent(bIndent);
    }

    private void processNodes(Element ele, HashMap cssStyles) {
        Node node = ele.getFirstChild();
        while (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 3) {
                if (this.isScriptText(node)) {
                    this.writer.cdata(node.getNodeValue());
                } else {
                    this.writer.text(node.getNodeValue(), false);
                }
            } else if (nodeType == 8) {
                this.writer.comment(node.getNodeValue());
            } else if (nodeType == 1) {
                if ("br".equalsIgnoreCase(node.getNodeName())) {
                    boolean bImplicitCloseTag = this.writer.isImplicitCloseTag();
                    this.writer.setImplicitCloseTag(true);
                    this.startNode(node, cssStyles);
                    this.processNodes((Element)node, cssStyles);
                    this.endNode(node);
                    this.writer.setImplicitCloseTag(bImplicitCloseTag);
                } else {
                    this.startNode(node, cssStyles);
                    this.processNodes((Element)node, cssStyles);
                    this.endNode(node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private boolean isScriptText(Node node) {
        String tag;
        Node parent = node.getParentNode();
        return parent != null && parent.getNodeType() == 1 && "script".equalsIgnoreCase(tag = parent.getNodeName());
    }

    public void startNode(Node node, HashMap cssStyles) {
        String nodeName = node.getNodeName();
        HashMap cssStyle = (HashMap)cssStyles.get(node);
        this.writer.openTag(nodeName);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                String attrName = attribute.getNodeName();
                String attrValue = attribute.getNodeValue();
                if (attrValue != null) {
                    String attrValueTrue;
                    if ("img".equalsIgnoreCase(nodeName) && "src".equalsIgnoreCase(attrName) && (attrValueTrue = this.handleStyleImage(attrValue)) != null) {
                        attrValue = attrValueTrue;
                    }
                    this.writer.attribute(attrName, attrValue);
                }
                ++i;
            }
        }
        if (cssStyle != null) {
            StringBuffer buffer = new StringBuffer();
            for (Map.Entry entry : cssStyle.entrySet()) {
                Object keyObj = entry.getKey();
                Object valueObj = entry.getValue();
                if (keyObj == null || valueObj == null) continue;
                String key = keyObj.toString();
                String value = valueObj.toString();
                buffer.append(key);
                buffer.append(":");
                if ("background-image".equalsIgnoreCase(key)) {
                    String valueTrue = this.handleStyleImage(value, true);
                    if (valueTrue != null) {
                        value = valueTrue;
                    }
                    buffer.append("url(");
                    buffer.append(value);
                    buffer.append(")");
                } else {
                    buffer.append(value);
                }
                buffer.append(";");
            }
            if (buffer.length() != 0) {
                this.writer.attribute("style", buffer.toString());
            }
        }
    }

    public void endNode(Node node) {
        this.writer.closeTag(node.getNodeName());
    }

    public void startLabel(ILabelContent label) {
        String bookmark = label.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            label.setBookmark(bookmark);
        }
        this.startText((ITextContent)label);
    }

    public void startData(IDataContent data) {
        this.startText((ITextContent)data);
    }

    public void startImage(IImageContent image) {
        boolean useSVG;
        assert (image != null);
        IStyle mergedStyle = image.getStyle();
        logger.log(Level.FINE, "[HTMLImageEmitter] Start image");
        StringBuffer styleBuffer = new StringBuffer();
        int display = this.checkElementType(image.getX(), image.getY(), mergedStyle, styleBuffer);
        String tag = this.openTagByType(display, 1);
        boolean hasAction = this.handleAction(image.getHyperlinkAction());
        if (image.getBookmark() == null) {
            image.setBookmark(this.idGenerator.generateUniqueID());
        }
        boolean bl = useSVG = "image/svg+xml".equalsIgnoreCase(image.getMIMEType()) || ".svg".equalsIgnoreCase(image.getExtension()) || image.getURI() != null && image.getURI().toLowerCase().endsWith(".svg");
        if (useSVG) {
            image.setMIMEType("image/svg+xml");
        }
        boolean useSWT = "application/x-shockwave-flash".equalsIgnoreCase(image.getMIMEType());
        if (useSVG || useSWT) {
            this.outputSVGImage(image, styleBuffer, display);
        } else {
            String altText;
            boolean hasImageMap;
            Object imageMapObject = image.getImageMap();
            String imageMapId = null;
            boolean bl2 = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
            if (hasImageMap) {
                imageMapId = this.idGenerator.generateUniqueID();
                this.writer.openTag("map");
                this.writer.attribute("id", imageMapId);
                this.writer.attribute("name", imageMapId);
                this.writer.cdata((String)imageMapObject);
                this.writer.closeTag("map");
            }
            this.writer.openTag("img");
            this.outputImageStyleClassBookmark(image, "img");
            String ext = image.getExtension();
            String imgUri = this.getImageURI(image);
            this.writer.attribute("src", imgUri);
            if (hasImageMap) {
                if (!hasAction) {
                    this.resetImageDefaultBorders(image, styleBuffer);
                }
                this.writer.attribute("usemap", "#" + imageMapId);
            }
            if ((altText = image.getAltText()) == null) {
                this.writer.attributeAllowEmpty("alt", "");
            } else {
                this.writer.attribute("alt", altText);
            }
            String titleText = image.getHelpText();
            if (titleText == null && hasAction) {
                titleText = image.getHyperlinkAction().getTooltip();
            }
            this.writer.attribute("title", titleText);
            this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
            this.writer.attribute("style", styleBuffer.toString());
            if (".PNG".equalsIgnoreCase(ext) && this.imageHandler != null) {
                if (this.htmlIDNamespace == null) {
                    this.writer.attribute("onload", "fixPNG(this)");
                } else {
                    this.writer.attribute("onload", String.valueOf(this.htmlIDNamespace) + "fixPNG(this)");
                }
            }
            this.writer.closeTag("img");
        }
        if (hasAction) {
            this.writer.closeTag("a");
        }
        this.writer.closeTag(tag);
    }

    protected void outputImageStyleClassBookmark(IImageContent image, String tag) {
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(image)), image, tag);
        }
        String styleClass = image.getStyleClass();
        this.setStyleName(styleClass, (IContent)image);
        if (!bookmarkOutput) {
            this.outputBookmark((IContent)image, "img");
        }
    }

    protected void outputSVGImage(IImageContent image, StringBuffer styleBuffer, int display) {
        this.writer.openTag("embed");
        this.outputImageStyleClassBookmark(image, "embed");
        String htmlBookmark = this.htmlIDNamespace != null ? String.valueOf(this.htmlIDNamespace) + image.getBookmark() : image.getBookmark();
        this.writer.attribute("onresize", "document.getElementById('" + htmlBookmark + "').reload()");
        this.writer.attribute("type", image.getMIMEType());
        this.writer.attribute("src", this.getImageURI(image));
        String altText = image.getAltText();
        if (altText == null) {
            this.writer.attributeAllowEmpty("alt", "");
        } else {
            this.writer.attribute("alt", altText);
        }
        if (this.enableMetadata) {
            this.writer.attribute("wmode", "transparent");
        }
        this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
        this.writer.attribute("style", styleBuffer.toString());
        this.writer.closeTag("embed");
    }

    protected void resetImageDefaultBorders(IImageContent image, StringBuffer styleBuffer) {
        IStyle style = image.getStyle();
        if (style.getBorderTopStyle() == null) {
            styleBuffer.append("border-top-style:none;");
        } else if (style.getBorderTopColor() == null) {
            styleBuffer.append("border-top-color:black");
        }
        if (style.getBorderBottomStyle() == null) {
            styleBuffer.append("border-bottom-style:none;");
        } else if (style.getBorderBottomColor() == null) {
            styleBuffer.append("border-bottom-color:black");
        }
        if (style.getBorderLeftStyle() == null) {
            styleBuffer.append("border-left-style:none;");
        } else if (style.getBorderLeftColor() == null) {
            styleBuffer.append("border-left-color:black");
        }
        if (style.getBorderRightStyle() == null) {
            styleBuffer.append("border-right-style:none;");
        } else if (style.getBorderRightColor() == null) {
            styleBuffer.append("border-right-color:black");
        }
    }

    protected String getImageURI(IImageContent image) {
        String imgUri = null;
        if (this.imageHandler != null) {
            if (image.getImageSource() == 3) {
                return image.getURI();
            }
            Image img = new Image(image);
            img.setRenderOption(this.renderOption);
            img.setReportRunnable(this.runnable);
            switch (img.getSource()) {
                case 0: {
                    imgUri = this.imageHandler.onDesignImage((IImage)img, this.reportContext);
                    break;
                }
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)img, this.reportContext);
                    break;
                }
                case 1: {
                    imgUri = this.imageHandler.onDocImage((IImage)img, this.reportContext);
                    break;
                }
                case 4: {
                    imgUri = this.imageHandler.onCustomImage((IImage)img, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)img, this.reportContext);
                    break;
                }
            }
        }
        return imgUri;
    }

    protected void setStyleName(String styleName, IContent content) {
        String name;
        DesignElementHandle handle;
        Object genBy;
        String metadataStyleClass;
        StringBuffer classBuffer = new StringBuffer();
        if (this.enableMetadata && (metadataStyleClass = this.metadataEmitter.getMetadataStyleClass(content)) != null) {
            classBuffer.append(metadataStyleClass);
        }
        if (!this.enableInlineStyle && styleName != null && styleName.length() > 0 && this.outputtedStyles.contains(styleName)) {
            if (classBuffer.length() != 0) {
                classBuffer.append(" ");
            }
            if (this.htmlIDNamespace != null) {
                classBuffer.append(this.htmlIDNamespace);
            }
            classBuffer.append(styleName);
        }
        if (this.hasCsslinks && (genBy = content.getGenerateBy()) instanceof StyledElementDesign && (handle = ((StyledElementDesign)genBy).getHandle()) != null && (name = handle.getStringProperty("style")) != null) {
            if (classBuffer.length() != 0) {
                classBuffer.append(" " + name);
            } else {
                classBuffer.append(name);
            }
        }
        if (classBuffer.length() != 0) {
            this.writer.attribute("class", classBuffer.toString());
        }
    }

    protected void outputBookmark(IContent content, String tagName) {
        String bookmark = content.getBookmark();
        HTMLEmitterUtil.setBookmark(this.writer, tagName, this.htmlIDNamespace, bookmark);
    }

    protected int checkElementType(DimensionType x, DimensionType y, IStyle style, StringBuffer styleBuffer) {
        return this.checkElementType(x, y, null, null, style, styleBuffer);
    }

    protected int checkElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style, StringBuffer styleBuffer) {
        return this.getElementType(x, y, width, height, style);
    }

    public int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        return this.htmlEmitter.getElementType(x, y, width, height, style);
    }

    protected String openTagByType(int display, int mask) {
        String tag = HTMLEmitterUtil.getTagByType(display, mask);
        if (tag != null) {
            this.writer.openTag(tag);
        }
        return tag;
    }

    protected boolean handleAction(IHyperlinkAction action) {
        String url = this.validate(action);
        if (url != null) {
            this.outputAction(action, url);
        }
        return url != null;
    }

    protected void outputAction(IHyperlinkAction action, String url) {
        this.writer.openTag("a");
        this.writer.attribute("href", url);
        this.writer.attribute("target", action.getTargetWindow());
        this.writer.attribute("title", action.getTooltip());
    }

    private String validate(IHyperlinkAction action) {
        if (action == null) {
            return null;
        }
        String systemId = this.runnable == null ? null : this.runnable.getReportName();
        Action act = new Action(systemId, action);
        if (this.actionHandler == null) {
            return null;
        }
        String link = this.actionHandler.getURL((IAction)act, this.reportContext);
        if (link != null && !link.equals("")) {
            return link;
        }
        return null;
    }

    public String handleStyleImage(String uri) {
        return this.handleStyleImage(uri, false);
    }

    public String handleStyleImage(String uri, boolean isBackground) {
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        URL url = design.findResource(uri, 1, this.reportContext.getAppContext());
        if (url == null) {
            return uri;
        }
        uri = url.toExternalForm();
        Image image = null;
        if (isBackground && SvgFile.isSvg((String)uri)) {
            try {
                byte[] buffer = SvgFile.transSvgToArray((String)uri);
                image = new Image(buffer, uri, ".jpg");
            }
            catch (IOException iOException) {
                image = new Image(uri);
            }
        } else {
            image = new Image(uri);
        }
        image.setReportRunnable(this.runnable);
        image.setRenderOption(this.renderOption);
        String imgUri = null;
        if (this.imageHandler != null) {
            switch (image.getSource()) {
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)image, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)image, this.reportContext);
                    break;
                }
                case 4: {
                    imgUri = this.imageHandler.onCustomImage((IImage)image, this.reportContext);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return imgUri;
    }

    private void setupTemplateElement(TemplateDesign template, IContent content) {
        String allowedType;
        String bookmark = content.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            content.setBookmark(bookmark);
        }
        if ("ExtendedItem".equals(allowedType = template.getAllowedType())) {
            IStyle style = content.getStyle();
            style.setProperty(17, (CSSValue)IStyle.FALSE_VALUE);
            content.setWidth(new DimensionType(3.0, "in"));
            content.setHeight(new DimensionType(3.0, "in"));
        } else if ("Table".equals(allowedType)) {
            IStyle style = content.getStyle();
            style.setProperty(17, (CSSValue)IStyle.FALSE_VALUE);
            content.setWidth(new DimensionType(5.0, "in"));
            style.setProperty(36, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(32, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(55, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(19, (CSSValue)IStyle.DOTTED_VALUE);
            style.setProperty(56, (CSSValue)IStyle.SANS_SERIF_VALUE);
        }
    }

    public void endGroup(IGroupContent group) {
    }

    public void endListBand(IListBandContent listBand) {
    }

    public void endListGroup(IListGroupContent group) {
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
    }

    public void startGroup(IGroupContent group) {
    }

    public void startListBand(IListBandContent listBand) {
    }

    public void startListGroup(IListGroupContent group) {
        this.outputBookmark((IGroupContent)group);
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
        this.startedGroups.push(group);
    }

    private void outputBookmark(IGroupContent group) {
        String bookmark = group.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            group.setBookmark(bookmark);
        }
        this.writer.openTag("span");
        HTMLEmitterUtil.setBookmark(this.writer, null, this.htmlIDNamespace, bookmark);
        this.writer.closeTag("span");
    }

    private void writeBidiFlag() {
        if (this.htmlRtLFlag) {
            this.writer.attribute("dir", "rtl");
        }
    }

    private void retrieveRtLFlag() {
        ReportDesignHandle handle;
        HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
        Object bidiFlag = htmlOption.getOption("RTLFlag");
        if (Boolean.TRUE.equals(bidiFlag)) {
            this.htmlRtLFlag = true;
        } else if (bidiFlag == null && this.report != null && (handle = this.report.getDesign().getReportDesign()) != null) {
            this.htmlRtLFlag = handle.isDirectionRTL();
            htmlOption.setHtmlRtLFlag(this.htmlRtLFlag);
        }
    }
}

