/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NumberFormatter {
    protected static Logger logger = Logger.getLogger(NumberFormatter.class.getName());
    protected String formatPattern;
    protected boolean parseBigDecimal;
    protected ULocale locale = ULocale.getDefault();
    protected NumberFormat numberFormat;
    protected NumberFormat decimalFormat;
    protected char decimalSeparator;
    private boolean hexFlag;
    private int roundPrecision;
    private String realPattern;

    public NumberFormatter() {
        this.applyPattern(null);
    }

    public NumberFormatter(String format) {
        this.applyPattern(format);
    }

    public NumberFormatter(ULocale locale) {
        this.locale = locale;
        this.applyPattern(null);
    }

    public NumberFormatter(Locale locale) {
        this(ULocale.forLocale((Locale)locale));
    }

    public NumberFormatter(String pattern, ULocale locale) {
        this.locale = locale;
        this.parseBigDecimal = false;
        this.applyPattern(pattern);
    }

    public NumberFormatter(String pattern, Locale locale) {
        this(pattern, ULocale.forLocale((Locale)locale));
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public void applyPattern(String patternStr) {
        try {
            this.formatPattern = patternStr;
            this.hexFlag = false;
            this.roundPrecision = -1;
            this.realPattern = this.formatPattern;
            if (this.formatPattern == null) {
                this.numberFormat = NumberFormat.getInstance(this.locale.toLocale());
                this.numberFormat.setGroupingUsed(false);
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.locale.toLocale());
                this.decimalSeparator = symbols.getDecimalSeparator();
                this.decimalFormat = new DecimalFormat("", new DecimalFormatSymbols(this.locale.toLocale()));
                this.decimalFormat.setMinimumIntegerDigits(1);
                this.decimalFormat.setGroupingUsed(false);
                this.roundPrecision = this.getRoundPrecision(this.numberFormat);
                return;
            }
            if (patternStr.length() == 1) {
                this.handleSingleCharFormatString(patternStr.charAt(0));
                this.roundPrecision = this.getRoundPrecision(this.numberFormat);
                return;
            }
            this.handleNamedFormats(patternStr);
            this.roundPrecision = this.getRoundPrecision(this.numberFormat);
        }
        catch (Exception illeagueE) {
            logger.log(Level.WARNING, illeagueE.getMessage(), illeagueE);
        }
    }

    public String format(double num) {
        block8: {
            try {
                if (!Double.isNaN(num)) break block8;
                return "NaN";
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        if (this.hexFlag) {
            return Long.toHexString(new Double(num).longValue());
        }
        if (num == 0.0) {
            num = 0.0;
        }
        if (this.formatPattern == null) {
            long longValue = Math.round(num);
            if ((double)longValue == num) {
                return Long.toString(longValue);
            }
            String result = Double.toString(num);
            return result.replace('.', this.decimalSeparator);
        }
        if (num < 0.0 && num > -1.0) {
            num = this.roundValue(num);
        }
        return this.numberFormat.format(num);
    }

    public String format(BigDecimal bigDecimal) {
        try {
            if (this.hexFlag) {
                return Long.toHexString(bigDecimal.longValue());
            }
            if (this.formatPattern == null) {
                return this.decimalFormat.format(bigDecimal);
            }
            bigDecimal = this.roundValue(bigDecimal);
            return this.numberFormat.format(bigDecimal);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String format(Number number) {
        block6: {
            try {
                if (!Double.isNaN(number.doubleValue())) break block6;
                return "NaN";
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
        if (this.hexFlag) {
            return Long.toHexString(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return this.format(number.doubleValue());
        }
        if (number instanceof BigDecimal) {
            return this.format((BigDecimal)number);
        }
        return this.numberFormat.format(number);
    }

    public String format(long num) {
        if (this.hexFlag) {
            return Long.toHexString(num);
        }
        return this.numberFormat.format(num);
    }

    private void handleSingleCharFormatString(char c) {
        switch (c) {
            case 'D': 
            case 'G': 
            case 'd': 
            case 'g': {
                this.numberFormat = NumberFormat.getInstance(this.locale.toLocale());
                return;
            }
            case 'C': 
            case 'c': {
                this.numberFormat = NumberFormat.getCurrencyInstance(this.locale.toLocale());
                return;
            }
            case 'F': 
            case 'f': {
                this.realPattern = "#0.00";
                this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
                return;
            }
            case 'N': 
            case 'n': {
                this.realPattern = "###,##0.00";
                this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
                return;
            }
            case 'P': 
            case 'p': {
                this.realPattern = "###,##0.00 %";
                this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
                return;
            }
            case 'E': 
            case 'e': {
                this.realPattern = "0.000000E00";
                this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
                this.roundPrecision = -2;
                return;
            }
            case 'X': 
            case 'x': {
                this.hexFlag = true;
                return;
            }
        }
        char[] data = new char[]{c};
        String str = new String(data);
        this.numberFormat = new DecimalFormat(str, new DecimalFormatSymbols(this.locale.toLocale()));
    }

    private void handleNamedFormats(String patternStr) {
        if (patternStr.equals("General Number") || patternStr.equals("Unformatted")) {
            this.numberFormat = NumberFormat.getInstance(this.locale.toLocale());
            this.numberFormat.setGroupingUsed(false);
            return;
        }
        if (patternStr.equals("Fixed")) {
            this.realPattern = "#0.00";
            this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
            return;
        }
        if (patternStr.equals("Percent")) {
            this.realPattern = "0.00%";
            this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
            return;
        }
        if (patternStr.equals("Scientific")) {
            this.realPattern = "0.00E00";
            this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
            this.roundPrecision = -2;
            return;
        }
        if (patternStr.equals("Standard")) {
            this.realPattern = "###,##0.00";
            this.numberFormat = new DecimalFormat(this.realPattern, new DecimalFormatSymbols(this.locale.toLocale()));
            return;
        }
        this.numberFormat = new DecimalFormat(patternStr, new DecimalFormatSymbols(this.locale.toLocale()));
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public void setParseBigDecimal(boolean parseBigDecimal) {
        this.parseBigDecimal = parseBigDecimal;
    }

    public Number parse(String number) throws ParseException {
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setParseBigDecimal(this.parseBigDecimal);
        }
        return this.numberFormat.parse(number);
    }

    BigDecimal roundValue(BigDecimal bd) {
        int scale;
        if (this.roundPrecision >= 0 && (scale = bd.scale()) > this.roundPrecision) {
            bd = bd.setScale(this.roundPrecision, 5);
        }
        return bd;
    }

    double roundValue(double value) {
        BigDecimal bd;
        int scale;
        if (this.roundPrecision >= 0 && (scale = (bd = BigDecimal.valueOf(value)).scale()) > this.roundPrecision) {
            bd = bd.setScale(this.roundPrecision, 5);
            return bd.doubleValue();
        }
        return value;
    }

    int getRoundPrecision(NumberFormat format) {
        if (this.realPattern != null && this.realPattern.indexOf(69) != -1) {
            return -1;
        }
        int precision = this.numberFormat.getMaximumFractionDigits();
        if (this.numberFormat instanceof DecimalFormat) {
            int formatMultiplier = ((DecimalFormat)this.numberFormat).getMultiplier();
            precision += formatMultiplier / 10;
        }
        return precision;
    }
}

