/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCache {
    private List<ArrayList<SheetData>> columns = new ArrayList<ArrayList<SheetData>>();
    private int width;
    protected static Logger logger = Logger.getLogger(EmitterUtil.class.getName());
    private List<BookmarkDef> bookmarks = new ArrayList<BookmarkDef>();
    private int maxRowIndex = 0;
    private Map<Integer, Double> rowIndex2Height = new HashMap<Integer, Double>();

    public DataCache(int width, int height) {
        this.columns.add(new ArrayList());
        this.width = width;
    }

    public void insertColumns(int startColumn, int columnCount) {
        int startPosition;
        if (columnCount == 0) {
            return;
        }
        int i = startPosition = startColumn + 1;
        while (i <= startColumn + columnCount) {
            if (i < this.width) {
                this.columns.add(i, new ArrayList());
            }
            ++i;
        }
    }

    public void addData(int col, SheetData data) {
        int rowIndex = data.getRowIndex();
        this.columns.get(col).add(data);
        this.maxRowIndex = this.maxRowIndex > rowIndex ? this.maxRowIndex : rowIndex;
        BookmarkDef bookmark = data.getBookmark();
        if (bookmark == null) {
            return;
        }
        bookmark.setColumnNo(col + 1);
        bookmark.setRowNo(rowIndex);
        this.bookmarks.add(bookmark);
    }

    public void clearCachedSheetData() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.columns.set(i, new ArrayList());
            ++i;
        }
        this.bookmarks.clear();
        this.maxRowIndex = 1;
    }

    public int getMaxRow() {
        return this.maxRowIndex;
    }

    protected boolean valid(int row, int col) {
        return col < this.getColumnCount();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<BookmarkDef> getBookmarks() {
        return this.bookmarks;
    }

    public int getMaxRowIndex(int column) {
        SheetData lastData = this.getColumnLastData(column);
        if (lastData != null) {
            return lastData.getRowIndex();
        }
        return 0;
    }

    public void setRowHeight(int rowIndex, double height) {
        if (!this.rowIndex2Height.containsKey(rowIndex)) {
            this.rowIndex2Height.put(rowIndex, height);
        }
    }

    public SheetData getColumnLastData(int index) {
        ArrayList<SheetData> columnDatas = this.columns.get(index);
        if (!columnDatas.isEmpty()) {
            return columnDatas.get(columnDatas.size() - 1);
        }
        return null;
    }

    public DataCahceIterator getRowIterator() {
        return new DataCahceIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataCahceIterator
    implements Iterator<SheetData[]> {
        private int[] columnIndexes;
        private int rowIndex = 1;

        public DataCahceIterator() {
            this.columnIndexes = new int[DataCache.this.columns.size()];
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex <= DataCache.this.maxRowIndex;
        }

        @Override
        public SheetData[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SheetData[] rowDatas = new SheetData[this.columnIndexes.length];
            int i = 0;
            while (i < this.columnIndexes.length) {
                ArrayList columnData = (ArrayList)DataCache.this.columns.get(i);
                int cursor = this.columnIndexes[i];
                int size = columnData.size();
                int j = cursor;
                while (j < size) {
                    SheetData data = (SheetData)columnData.get(j);
                    int dataRowIndex = data.getRowIndex();
                    if (dataRowIndex == this.rowIndex) {
                        rowDatas[i] = data;
                        if (!DataCache.this.rowIndex2Height.isEmpty() && DataCache.this.rowIndex2Height.containsKey(this.rowIndex)) {
                            rowDatas[i].setRowHeight((Double)DataCache.this.rowIndex2Height.get(this.rowIndex));
                        }
                        this.columnIndexes[i] = j + 1;
                        break;
                    }
                    if (dataRowIndex > this.rowIndex) {
                        this.columnIndexes[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            ++this.rowIndex;
            return rowDatas;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

