/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.ExcelXmlWriter;
import org.eclipse.birt.report.engine.emitter.excel.IExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelWriter
implements IExcelWriter {
    private ExcelXmlWriter writer;
    private ExcelXmlWriter tempWriter;
    private final ExcelContext context;
    private final OutputStream out;
    private final boolean isRTLSheet;
    private String tempFilePath;
    private int sheetIndex = 1;

    public ExcelWriter(OutputStream out, ExcelContext context, boolean isRtlSheet) {
        this.out = out;
        this.context = context;
        this.isRTLSheet = isRtlSheet;
    }

    @Override
    public void end() throws IOException {
        this.writer.end();
    }

    @Override
    public void endRow() {
        this.writer.endRow();
    }

    @Override
    public void endSheet(String oritentation) {
        this.writer.endSheet(oritentation);
    }

    @Override
    public void outputData(SheetData data) throws IOException {
        this.writer.outputData(data);
    }

    @Override
    public void start(IReportContent report, Map<StyleEntry, Integer> styles, HashMap<String, BookmarkDef> bookmarkList) throws IOException {
        this.writer = new ExcelXmlWriter(this.out, this.context, this.isRTLSheet);
        this.writer.setSheetIndex(this.sheetIndex);
        this.writer.start(report, styles, bookmarkList);
        this.copyOutputData();
    }

    private void copyOutputData() throws IOException {
        if (this.tempWriter != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(new File(this.tempFilePath)));
                String line = reader.readLine();
                ExcelXmlWriter.XMLWriterXLS xlsWriter = this.writer.getWriter();
                while (line != null) {
                    xlsWriter.literal("\n");
                    xlsWriter.literal(line);
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                    Object var1_1 = null;
                }
            }
        }
    }

    @Override
    public void startRow(double rowHeight) {
        this.writer.startRow(rowHeight);
    }

    @Override
    public void startSheet(int[] coordinates, String pageHeader, String pageFooter) throws IOException {
        if (this.writer == null) {
            this.initializeWriterAsTempWriter();
        }
        this.writer.startSheet(coordinates, pageHeader, pageFooter);
        ++this.sheetIndex;
    }

    private void initializeWriterAsTempWriter() throws FileNotFoundException {
        this.tempFilePath = String.valueOf(this.context.getTempFileDir()) + "_BIRTEMITTER_EXCEL_TEMP_FILE" + Thread.currentThread().getId();
        FileOutputStream out = new FileOutputStream(this.tempFilePath);
        this.writer = this.tempWriter = new ExcelXmlWriter((OutputStream)out, this.context, this.isRTLSheet);
    }
}

